/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.listener;

import com.tencent.supersonic.common.pojo.Constants;
import com.tencent.supersonic.common.pojo.DataEvent;
import com.tencent.supersonic.common.pojo.enums.DictWordType;
import com.tencent.supersonic.common.pojo.enums.EventType;
import com.tencent.supersonic.common.pojo.enums.TypeEnums;
import com.tencent.supersonic.headless.chat.knowledge.DictWord;
import com.tencent.supersonic.headless.chat.knowledge.helper.HanlpHelper;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SchemaDictUpdateListener
implements ApplicationListener<DataEvent> {
    private static final Logger log = LoggerFactory.getLogger(SchemaDictUpdateListener.class);

    @Async
    public void onApplicationEvent(DataEvent dataEvent) {
        if (CollectionUtils.isEmpty((Collection)dataEvent.getDataItems())) {
            return;
        }
        dataEvent.getDataItems().forEach(dataItem -> {
            DictWord dictWord = new DictWord();
            dictWord.setWord(dataItem.getName());
            String sign = "_";
            String suffixNature = DictWordType.getSuffixNature((TypeEnums)dataItem.getType());
            String nature = sign + dataItem.getModelId() + dataItem.getId() + suffixNature;
            String natureWithFrequency = nature + " " + Constants.DEFAULT_FREQUENCY;
            dictWord.setNature(nature);
            dictWord.setNatureWithFrequency(natureWithFrequency);
            if (EventType.ADD.equals((Object)dataEvent.getEventType())) {
                HanlpHelper.addToCustomDictionary((DictWord)dictWord);
            } else if (EventType.DELETE.equals((Object)dataEvent.getEventType())) {
                HanlpHelper.removeFromCustomDictionary((DictWord)dictWord);
            } else if (EventType.UPDATE.equals((Object)dataEvent.getEventType())) {
                HanlpHelper.removeFromCustomDictionary((DictWord)dictWord);
                dictWord.setWord(dataItem.getNewName());
                HanlpHelper.addToCustomDictionary((DictWord)dictWord);
            }
        });
    }
}

