/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.manager;

import com.tencent.supersonic.headless.api.pojo.enums.IdentifyType;
import com.tencent.supersonic.headless.api.pojo.response.DimensionResp;
import com.tencent.supersonic.headless.server.pojo.yaml.DimensionYamlTpl;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DimensionYamlManager {
    private static final Logger log = LoggerFactory.getLogger(DimensionYamlManager.class);

    public static List<DimensionYamlTpl> convert2DimensionYaml(List<DimensionResp> dimensions) {
        if (CollectionUtils.isEmpty(dimensions)) {
            return new ArrayList<DimensionYamlTpl>();
        }
        return dimensions.stream().filter(dimension -> !dimension.getType().equalsIgnoreCase(IdentifyType.primary.name())).map(DimensionYamlManager::convert2DimensionYamlTpl).collect(Collectors.toList());
    }

    public static DimensionYamlTpl convert2DimensionYamlTpl(DimensionResp dimension) {
        DimensionYamlTpl dimensionYamlTpl = new DimensionYamlTpl();
        BeanUtils.copyProperties((Object)dimension, (Object)dimensionYamlTpl);
        dimensionYamlTpl.setName(dimension.getBizName());
        dimensionYamlTpl.setOwners(dimension.getCreatedBy());
        return dimensionYamlTpl;
    }
}

