/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.manager;

import com.tencent.supersonic.common.pojo.ModelRela;
import com.tencent.supersonic.common.pojo.enums.FilterOperatorEnum;
import com.tencent.supersonic.headless.api.pojo.Field;
import com.tencent.supersonic.headless.api.pojo.enums.TagDefineType;
import com.tencent.supersonic.headless.api.pojo.response.DatabaseResp;
import com.tencent.supersonic.headless.api.pojo.response.SemanticSchemaResp;
import com.tencent.supersonic.headless.api.pojo.response.TagResp;
import com.tencent.supersonic.headless.core.translator.calcite.s2sql.DataSource;
import com.tencent.supersonic.headless.core.translator.calcite.s2sql.DataType;
import com.tencent.supersonic.headless.core.translator.calcite.s2sql.Dimension;
import com.tencent.supersonic.headless.core.translator.calcite.s2sql.DimensionTimeTypeParams;
import com.tencent.supersonic.headless.core.translator.calcite.s2sql.Identify;
import com.tencent.supersonic.headless.core.translator.calcite.s2sql.JoinRelation;
import com.tencent.supersonic.headless.core.translator.calcite.s2sql.Materialization;
import com.tencent.supersonic.headless.core.translator.calcite.s2sql.Measure;
import com.tencent.supersonic.headless.core.translator.calcite.s2sql.Metric;
import com.tencent.supersonic.headless.core.translator.calcite.s2sql.MetricTypeParams;
import com.tencent.supersonic.headless.core.translator.calcite.s2sql.SemanticModel;
import com.tencent.supersonic.headless.core.translator.calcite.schema.SemanticSchema;
import com.tencent.supersonic.headless.server.pojo.yaml.DataModelYamlTpl;
import com.tencent.supersonic.headless.server.pojo.yaml.DimensionTimeTypeParamsTpl;
import com.tencent.supersonic.headless.server.pojo.yaml.DimensionYamlTpl;
import com.tencent.supersonic.headless.server.pojo.yaml.FieldParamYamlTpl;
import com.tencent.supersonic.headless.server.pojo.yaml.IdentifyYamlTpl;
import com.tencent.supersonic.headless.server.pojo.yaml.MeasureYamlTpl;
import com.tencent.supersonic.headless.server.pojo.yaml.MetricParamYamlTpl;
import com.tencent.supersonic.headless.server.pojo.yaml.MetricTypeParamsYamlTpl;
import com.tencent.supersonic.headless.server.pojo.yaml.MetricYamlTpl;
import com.tencent.supersonic.headless.server.utils.DatabaseConverter;
import com.tencent.supersonic.headless.server.web.service.SchemaService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SemanticSchemaManager {
    private static final Logger log = LoggerFactory.getLogger(SemanticSchemaManager.class);
    private final SchemaService schemaService;

    public SemanticSchemaManager(SchemaService schemaService) {
        this.schemaService = schemaService;
    }

    public SemanticModel getSemanticModel(SemanticSchemaResp semanticSchemaResp) {
        SemanticModel semanticModel = new SemanticModel();
        semanticModel.setSchemaKey(semanticSchemaResp.getSchemaKey());
        HashMap<String, List<DimensionYamlTpl>> dimensionYamlTpls = new HashMap<String, List<DimensionYamlTpl>>();
        ArrayList<DataModelYamlTpl> dataModelYamlTpls = new ArrayList<DataModelYamlTpl>();
        ArrayList<MetricYamlTpl> metricYamlTpls = new ArrayList<MetricYamlTpl>();
        HashMap<Long, String> modelIdName = new HashMap<Long, String>();
        this.schemaService.getSchemaYamlTpl(semanticSchemaResp, dimensionYamlTpls, dataModelYamlTpls, metricYamlTpls, modelIdName);
        DatabaseResp databaseResp = semanticSchemaResp.getDatabaseResp();
        semanticModel.setDatabase(DatabaseConverter.convert(databaseResp));
        if (!CollectionUtils.isEmpty((Collection)semanticSchemaResp.getModelRelas())) {
            semanticModel.setJoinRelations(SemanticSchemaManager.getJoinRelation(semanticSchemaResp.getModelRelas(), modelIdName));
        }
        if (!dataModelYamlTpls.isEmpty()) {
            Map<String, DataSource> dataSourceMap = dataModelYamlTpls.stream().map(SemanticSchemaManager::getDatasource).collect(Collectors.toMap(DataSource::getName, item -> item, (k1, k2) -> k1));
            semanticModel.setDatasourceMap(dataSourceMap);
        }
        if (!dimensionYamlTpls.isEmpty()) {
            HashMap<String, List<Dimension>> dimensionMap = new HashMap<String, List<Dimension>>();
            for (Map.Entry entry : dimensionYamlTpls.entrySet()) {
                dimensionMap.put((String)entry.getKey(), SemanticSchemaManager.getDimensions((List)entry.getValue()));
            }
            semanticModel.setDimensionMap(dimensionMap);
        }
        if (!metricYamlTpls.isEmpty()) {
            semanticModel.setMetrics(SemanticSchemaManager.getMetrics(metricYamlTpls));
        }
        return semanticModel;
    }

    public SemanticModel getTagSemanticModel(SemanticSchemaResp semanticSchemaResp) throws Exception {
        if (CollectionUtils.isEmpty((Collection)semanticSchemaResp.getTags())) {
            throw new Exception("semanticSchemaResp tag is empty");
        }
        SemanticModel semanticModel = this.getSemanticModel(semanticSchemaResp);
        HashMap tagMap = new HashMap();
        for (TagResp tagResp : semanticSchemaResp.getTags()) {
            if (!tagMap.containsKey(tagResp.getModelId())) {
                tagMap.put(tagResp.getModelId(), new ArrayList());
            }
            ((List)tagMap.get(tagResp.getModelId())).add(tagResp);
        }
        if (Objects.nonNull(semanticModel.getDatasourceMap()) && !semanticModel.getDatasourceMap().isEmpty()) {
            for (Map.Entry entry : semanticModel.getDatasourceMap().entrySet()) {
                ArrayList<Dimension> modelDimensions = new ArrayList();
                if (!semanticModel.getDimensionMap().containsKey(entry.getKey())) {
                    semanticModel.getDimensionMap().put((String)entry.getKey(), modelDimensions);
                } else {
                    modelDimensions = (List)semanticModel.getDimensionMap().get(entry.getKey());
                }
                if (!tagMap.containsKey(((DataSource)entry.getValue()).getId())) continue;
                for (TagResp tagResp : (List)tagMap.get(((DataSource)entry.getValue()).getId())) {
                    this.addTagModel(tagResp, modelDimensions, semanticModel.getMetrics());
                }
            }
        }
        return semanticModel;
    }

    private void addTagModel(TagResp tagResp, List<Dimension> modelDimensions, List<Metric> modelMetrics) throws Exception {
        TagDefineType tagDefineType = TagDefineType.valueOf((String)tagResp.getTagDefineType());
        switch (tagDefineType) {
            case FIELD: 
            case DIMENSION: {
                Optional modelDimension;
                if (TagDefineType.DIMENSION.equals((Object)tagResp.getTagDefineType()) && (modelDimension = modelDimensions.stream().findFirst()).isPresent()) {
                    ((Dimension)modelDimension.get()).setName(tagResp.getBizName());
                    return;
                }
                Dimension dimension = Dimension.builder().build();
                dimension.setType("");
                dimension.setName(tagResp.getBizName());
                dimension.setOwners("");
                dimension.setBizName(tagResp.getBizName());
                if (Objects.isNull(dimension.getDataType())) {
                    dimension.setDataType(DataType.UNKNOWN);
                }
                DimensionTimeTypeParams dimensionTimeTypeParams = new DimensionTimeTypeParams();
                dimension.setDimensionTimeTypeParams(dimensionTimeTypeParams);
                modelDimensions.add(dimension);
                return;
            }
            case METRIC: {
                Optional modelMetric = modelMetrics.stream().findFirst();
                if (!modelMetric.isPresent()) {
                    throw new Exception(String.format("tag [{}] cant find the metric", tagResp.getBizName()));
                }
                ((Metric)modelMetric.get()).setName(tagResp.getBizName());
                return;
            }
        }
    }

    public static List<Metric> getMetrics(List<MetricYamlTpl> t) {
        return SemanticSchemaManager.getMetricsByMetricYamlTpl(t);
    }

    public static List<Dimension> getDimensions(List<DimensionYamlTpl> t) {
        return SemanticSchemaManager.getDimension(t);
    }

    public static DataSource getDatasource(DataModelYamlTpl d) {
        DataSource datasource = DataSource.builder().id(d.getId()).sourceId(d.getSourceId()).type(d.getType()).sqlQuery(d.getSqlQuery()).name(d.getName()).tableQuery(d.getTableQuery()).identifiers(SemanticSchemaManager.getIdentify(d.getIdentifiers())).measures(SemanticSchemaManager.getMeasureParams(d.getMeasures())).dimensions(SemanticSchemaManager.getDimensions(d.getDimensions())).build();
        datasource.setAggTime(SemanticSchemaManager.getDataSourceAggTime(datasource.getDimensions()));
        if (Objects.nonNull(d.getModelSourceTypeEnum())) {
            datasource.setTimePartType(Materialization.TimePartType.of((String)d.getModelSourceTypeEnum().name()));
        }
        if (Objects.nonNull(d.getFields()) && !CollectionUtils.isEmpty(d.getFields())) {
            Set measures = datasource.getMeasures().stream().map(mm -> mm.getName()).collect(Collectors.toSet());
            for (Field f : d.getFields()) {
                if (measures.contains(f.getFieldName())) continue;
                datasource.getMeasures().add(Measure.builder().expr(f.getFieldName()).name(f.getFieldName()).agg("").build());
            }
        }
        return datasource;
    }

    private static String getDataSourceAggTime(List<Dimension> dimensions) {
        Optional<Dimension> timeDimension = dimensions.stream().filter(d -> "time".equalsIgnoreCase(d.getType())).findFirst();
        if (timeDimension.isPresent() && Objects.nonNull(timeDimension.get().getDimensionTimeTypeParams())) {
            return timeDimension.get().getDimensionTimeTypeParams().getTimeGranularity();
        }
        return "none";
    }

    private static List<Metric> getMetricsByMetricYamlTpl(List<MetricYamlTpl> metricYamlTpls) {
        ArrayList<Metric> metrics = new ArrayList<Metric>();
        for (MetricYamlTpl metricYamlTpl : metricYamlTpls) {
            Metric metric = new Metric();
            metric.setMetricTypeParams(SemanticSchemaManager.getMetricTypeParams(metricYamlTpl.getTypeParams()));
            metric.setOwners(metricYamlTpl.getOwners());
            metric.setType(metricYamlTpl.getType());
            metric.setName(metricYamlTpl.getName());
            metrics.add(metric);
        }
        return metrics;
    }

    private static MetricTypeParams getMetricTypeParams(MetricTypeParamsYamlTpl metricTypeParamsYamlTpl) {
        MetricTypeParams metricTypeParams = new MetricTypeParams();
        metricTypeParams.setExpr(metricTypeParamsYamlTpl.getExpr());
        metricTypeParams.setFieldMetric(false);
        if (!CollectionUtils.isEmpty(metricTypeParamsYamlTpl.getMeasures())) {
            metricTypeParams.setMeasures(SemanticSchemaManager.getMeasureParams(metricTypeParamsYamlTpl.getMeasures()));
        }
        if (!CollectionUtils.isEmpty(metricTypeParamsYamlTpl.getMetrics())) {
            metricTypeParams.setMeasures(SemanticSchemaManager.getMetricParams(metricTypeParamsYamlTpl.getMetrics()));
            metricTypeParams.setExpr(((Measure)metricTypeParams.getMeasures().get(0)).getExpr());
            metricTypeParams.setFieldMetric(true);
        }
        if (!CollectionUtils.isEmpty(metricTypeParamsYamlTpl.getFields())) {
            metricTypeParams.setMeasures(SemanticSchemaManager.getFieldParams(metricTypeParamsYamlTpl.getFields()));
            metricTypeParams.setExpr(((Measure)metricTypeParams.getMeasures().get(0)).getExpr());
            metricTypeParams.setFieldMetric(true);
        }
        return metricTypeParams;
    }

    private static List<Measure> getFieldParams(List<FieldParamYamlTpl> fieldParamYamlTpls) {
        ArrayList<Measure> measures = new ArrayList<Measure>();
        for (FieldParamYamlTpl fieldParamYamlTpl : fieldParamYamlTpls) {
            Measure measure = new Measure();
            measure.setName(fieldParamYamlTpl.getFieldName());
            measure.setExpr(fieldParamYamlTpl.getFieldName());
            measures.add(measure);
        }
        return measures;
    }

    private static List<Measure> getMetricParams(List<MetricParamYamlTpl> metricParamYamlTpls) {
        ArrayList<Measure> measures = new ArrayList<Measure>();
        for (MetricParamYamlTpl metricParamYamlTpl : metricParamYamlTpls) {
            Measure measure = new Measure();
            measure.setName(metricParamYamlTpl.getBizName());
            measure.setExpr(metricParamYamlTpl.getBizName());
            measures.add(measure);
        }
        return measures;
    }

    private static List<Measure> getMeasureParams(List<MeasureYamlTpl> measureYamlTpls) {
        ArrayList<Measure> measures = new ArrayList<Measure>();
        for (MeasureYamlTpl measureYamlTpl : measureYamlTpls) {
            Measure measure = new Measure();
            measure.setCreateMetric(measureYamlTpl.getCreateMetric());
            measure.setExpr(measureYamlTpl.getExpr());
            measure.setAgg(measureYamlTpl.getAgg());
            measure.setName(measureYamlTpl.getName());
            measure.setAlias(measureYamlTpl.getAlias());
            measure.setConstraint(measureYamlTpl.getConstraint());
            measures.add(measure);
        }
        return measures;
    }

    private static List<Dimension> getDimension(List<DimensionYamlTpl> dimensionYamlTpls) {
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
        for (DimensionYamlTpl dimensionYamlTpl : dimensionYamlTpls) {
            Dimension dimension = Dimension.builder().build();
            dimension.setType(dimensionYamlTpl.getType());
            dimension.setExpr(dimensionYamlTpl.getExpr());
            dimension.setName(dimensionYamlTpl.getName());
            dimension.setOwners(dimensionYamlTpl.getOwners());
            dimension.setBizName(dimensionYamlTpl.getBizName());
            dimension.setDefaultValues(dimensionYamlTpl.getDefaultValues());
            if (Objects.nonNull(dimensionYamlTpl.getDataType())) {
                dimension.setDataType(DataType.of((String)dimensionYamlTpl.getDataType().getType()));
            }
            if (Objects.isNull(dimension.getDataType())) {
                dimension.setDataType(DataType.UNKNOWN);
            }
            if (Objects.nonNull(dimensionYamlTpl.getExt())) {
                dimension.setExt(dimensionYamlTpl.getExt());
            }
            dimension.setDimensionTimeTypeParams(SemanticSchemaManager.getDimensionTimeTypeParams(dimensionYamlTpl.getTypeParams()));
            dimensions.add(dimension);
        }
        return dimensions;
    }

    private static DimensionTimeTypeParams getDimensionTimeTypeParams(DimensionTimeTypeParamsTpl dimensionTimeTypeParamsTpl) {
        DimensionTimeTypeParams dimensionTimeTypeParams = new DimensionTimeTypeParams();
        if (dimensionTimeTypeParamsTpl != null) {
            dimensionTimeTypeParams.setTimeGranularity(dimensionTimeTypeParamsTpl.getTimeGranularity());
            dimensionTimeTypeParams.setIsPrimary(dimensionTimeTypeParamsTpl.getIsPrimary());
        }
        return dimensionTimeTypeParams;
    }

    private static List<Identify> getIdentify(List<IdentifyYamlTpl> identifyYamlTpls) {
        ArrayList<Identify> identifies = new ArrayList<Identify>();
        for (IdentifyYamlTpl identifyYamlTpl : identifyYamlTpls) {
            Identify identify = new Identify();
            identify.setType(identifyYamlTpl.getType());
            identify.setName(identifyYamlTpl.getName());
            identifies.add(identify);
        }
        return identifies;
    }

    private static List<JoinRelation> getJoinRelation(List<ModelRela> modelRelas, Map<Long, String> modelIdName) {
        ArrayList<JoinRelation> joinRelations = new ArrayList<JoinRelation>();
        modelRelas.stream().forEach(r -> {
            if (modelIdName.containsKey(r.getFromModelId()) && modelIdName.containsKey(r.getToModelId())) {
                JoinRelation joinRelation = JoinRelation.builder().left((String)modelIdName.get(r.getFromModelId())).right((String)modelIdName.get(r.getToModelId())).joinType(r.getJoinType()).build();
                ArrayList conditions = new ArrayList();
                r.getJoinConditions().stream().forEach(rr -> {
                    if (FilterOperatorEnum.isValueCompare((FilterOperatorEnum)rr.getOperator())) {
                        conditions.add(Triple.of((Object)rr.getLeftField(), (Object)rr.getOperator().getValue(), (Object)rr.getRightField()));
                    }
                });
                joinRelation.setId(r.getId());
                joinRelation.setJoinCondition(conditions);
                joinRelations.add(joinRelation);
            }
        });
        return joinRelations;
    }

    public static void update(SemanticSchema schema, List<Metric> metric) throws Exception {
        if (schema != null) {
            SemanticSchemaManager.updateMetric(metric, schema.getMetrics());
        }
    }

    public static void update(SemanticSchema schema, DataSource datasourceYamlTpl) throws Exception {
        if (schema != null) {
            String dataSourceName = datasourceYamlTpl.getName();
            Optional<Map.Entry> datasourceYamlTplMap = schema.getDatasource().entrySet().stream().filter(t -> ((String)t.getKey()).equalsIgnoreCase(dataSourceName)).findFirst();
            if (datasourceYamlTplMap.isPresent()) {
                datasourceYamlTplMap.get().setValue(datasourceYamlTpl);
            } else {
                schema.getDatasource().put(dataSourceName, datasourceYamlTpl);
            }
        }
    }

    public static void update(SemanticSchema schema, String datasourceBizName, List<Dimension> dimensionYamlTpls) throws Exception {
        if (schema != null) {
            Optional<Map.Entry> datasourceYamlTplMap = schema.getDimension().entrySet().stream().filter(t -> ((String)t.getKey()).equalsIgnoreCase(datasourceBizName)).findFirst();
            if (datasourceYamlTplMap.isPresent()) {
                SemanticSchemaManager.updateDimension(dimensionYamlTpls, (List)datasourceYamlTplMap.get().getValue());
            } else {
                ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
                SemanticSchemaManager.updateDimension(dimensionYamlTpls, dimensions);
                schema.getDimension().put(datasourceBizName, dimensions);
            }
        }
    }

    private static void updateDimension(List<Dimension> dimensionYamlTpls, List<Dimension> dimensions) {
        if (CollectionUtils.isEmpty(dimensionYamlTpls)) {
            return;
        }
        Set toAdd = dimensionYamlTpls.stream().map(m -> m.getName()).collect(Collectors.toSet());
        Iterator<Dimension> iterator = dimensions.iterator();
        while (iterator.hasNext()) {
            Dimension cur = iterator.next();
            if (!toAdd.contains(cur.getName())) continue;
            iterator.remove();
        }
        dimensions.addAll(dimensionYamlTpls);
    }

    private static void updateMetric(List<Metric> metricYamlTpls, List<Metric> metrics) {
        if (CollectionUtils.isEmpty(metricYamlTpls)) {
            return;
        }
        Set toAdd = metricYamlTpls.stream().map(m -> m.getName()).collect(Collectors.toSet());
        Iterator<Metric> iterator = metrics.iterator();
        while (iterator.hasNext()) {
            Metric cur = iterator.next();
            if (!toAdd.contains(cur.getName())) continue;
            iterator.remove();
        }
        metrics.addAll(metricYamlTpls);
    }
}

