/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.persistence.repository.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Stopwatch;
import com.tencent.supersonic.headless.api.pojo.ItemDateFilter;
import com.tencent.supersonic.headless.api.pojo.request.DateInfoReq;
import com.tencent.supersonic.headless.server.persistence.dataobject.DateInfoDO;
import com.tencent.supersonic.headless.server.persistence.mapper.DateInfoMapper;
import com.tencent.supersonic.headless.server.persistence.repository.DateInfoRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class DateInfoRepositoryImpl
implements DateInfoRepository {
    private static final Logger log = LoggerFactory.getLogger(DateInfoRepositoryImpl.class);
    private ObjectMapper mapper = new ObjectMapper();
    @Autowired
    private DateInfoMapper dateInfoMapper;

    @Override
    public Integer upsertDateInfo(List<DateInfoReq> dateInfoCommends) {
        ArrayList<DateInfoDO> dateInfoDOList = new ArrayList<DateInfoDO>();
        if (CollectionUtils.isEmpty(dateInfoCommends)) {
            log.info("dateInfoCommends size is 0");
            return 0;
        }
        dateInfoCommends.stream().forEach(commend -> {
            DateInfoDO dateInfoDO = new DateInfoDO();
            BeanUtils.copyProperties((Object)commend, (Object)dateInfoDO);
            try {
                dateInfoDO.setUnavailableDateList(this.mapper.writeValueAsString((Object)commend.getUnavailableDateList()));
                dateInfoDO.setCreatedBy("admin");
                dateInfoDO.setUpdatedBy("admin");
            }
            catch (JsonProcessingException e) {
                log.info("e,", (Throwable)e);
            }
            dateInfoDOList.add(dateInfoDO);
        });
        return this.batchUpsert(dateInfoDOList);
    }

    @Override
    public List<DateInfoDO> getDateInfos(ItemDateFilter itemDateFilter) {
        if (Objects.nonNull(itemDateFilter) && CollectionUtils.isEmpty((Collection)itemDateFilter.getItemIds())) {
            return new ArrayList<DateInfoDO>();
        }
        return this.dateInfoMapper.getDateInfos(itemDateFilter);
    }

    private Integer batchUpsert(List<DateInfoDO> dateInfoDOList) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        for (DateInfoDO dateInfoDO : dateInfoDOList) {
            this.dateInfoMapper.upsertDateInfo(dateInfoDO);
        }
        log.info("before final, elapsed time:{}", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return 0;
    }
}

