/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.persistence.repository.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.tencent.supersonic.common.pojo.enums.TypeEnums;
import com.tencent.supersonic.headless.api.pojo.request.DictItemFilter;
import com.tencent.supersonic.headless.api.pojo.request.DictSingleTaskReq;
import com.tencent.supersonic.headless.api.pojo.response.DictItemResp;
import com.tencent.supersonic.headless.api.pojo.response.DictTaskResp;
import com.tencent.supersonic.headless.api.pojo.response.DimensionResp;
import com.tencent.supersonic.headless.server.persistence.dataobject.DictConfDO;
import com.tencent.supersonic.headless.server.persistence.dataobject.DictTaskDO;
import com.tencent.supersonic.headless.server.persistence.mapper.DictConfMapper;
import com.tencent.supersonic.headless.server.persistence.mapper.DictTaskMapper;
import com.tencent.supersonic.headless.server.persistence.repository.DictRepository;
import com.tencent.supersonic.headless.server.utils.DictUtils;
import com.tencent.supersonic.headless.server.web.service.DimensionService;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class DictRepositoryImpl
implements DictRepository {
    private static final Logger log = LoggerFactory.getLogger(DictRepositoryImpl.class);
    @Value(value="${s2.dict.task.num:10}")
    private Integer dictTaskNum;
    private final DictTaskMapper dictTaskMapper;
    private final DictConfMapper dictConfMapper;
    private final DictUtils dictConverter;
    private final DimensionService dimensionService;

    public DictRepositoryImpl(DictTaskMapper dictTaskMapper, DictConfMapper dictConfMapper, DictUtils dictConverter, DimensionService dimensionService) {
        this.dictTaskMapper = dictTaskMapper;
        this.dictConfMapper = dictConfMapper;
        this.dictConverter = dictConverter;
        this.dimensionService = dimensionService;
    }

    @Override
    public Long addDictTask(DictTaskDO dictTaskDO) {
        this.dictTaskMapper.insert(dictTaskDO);
        return dictTaskDO.getId();
    }

    @Override
    public Long editDictTask(DictTaskDO dictTaskDO) {
        this.dictTaskMapper.updateById(dictTaskDO);
        return dictTaskDO.getId();
    }

    @Override
    public DictTaskDO queryDictTask(DictItemFilter filter) {
        List dictTaskDOList;
        QueryWrapper wrapper = new QueryWrapper();
        if (Objects.nonNull(filter.getItemId())) {
            wrapper.lambda().eq(DictTaskDO::getItemId, (Object)filter.getItemId());
        }
        if (Objects.nonNull(filter.getType())) {
            wrapper.lambda().eq(DictTaskDO::getType, (Object)filter.getType());
        }
        if (Objects.nonNull(filter.getId())) {
            wrapper.lambda().eq(DictTaskDO::getId, (Object)filter.getId());
        }
        if (CollectionUtils.isEmpty((Collection)(dictTaskDOList = this.dictTaskMapper.selectList((Wrapper)wrapper)))) {
            return null;
        }
        return (DictTaskDO)dictTaskDOList.get(0);
    }

    @Override
    public DictTaskDO queryDictTaskById(Long id) {
        return (DictTaskDO)this.dictTaskMapper.selectById(id);
    }

    @Override
    public DictTaskResp queryLatestDictTask(DictSingleTaskReq taskReq) {
        DictTaskResp taskResp = new DictTaskResp();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.lambda().eq(DictTaskDO::getItemId, (Object)taskReq.getItemId());
        wrapper.lambda().eq(DictTaskDO::getType, (Object)taskReq.getType());
        List dictTaskDOList = this.dictTaskMapper.selectList((Wrapper)wrapper).stream().sorted(Comparator.comparing(DictTaskDO::getCreatedAt).reversed()).limit(this.dictTaskNum.intValue()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(dictTaskDOList)) {
            return taskResp;
        }
        taskResp = this.dictConverter.taskDO2Resp((DictTaskDO)dictTaskDOList.get(0));
        DimensionResp dimension = this.dimensionService.getDimension(taskReq.getItemId());
        taskResp.setBizName(dimension.getBizName());
        taskResp.setModelId(dimension.getModelId());
        return taskResp;
    }

    @Override
    public Long addDictConf(DictConfDO dictConfDO) {
        this.dictConfMapper.insert(dictConfDO);
        return dictConfDO.getId();
    }

    @Override
    public Long editDictConf(DictConfDO dictConfDO) {
        DictItemFilter filter = DictItemFilter.builder().type(TypeEnums.valueOf((String)dictConfDO.getType())).itemId(dictConfDO.getItemId()).build();
        List<DictConfDO> dictConfDOList = this.getDictConfDOList(filter);
        if (CollectionUtils.isEmpty(dictConfDOList)) {
            return -1L;
        }
        dictConfDO.setId(dictConfDOList.get(0).getId());
        this.dictConfMapper.updateById(dictConfDO);
        return dictConfDO.getId();
    }

    @Override
    public List<DictItemResp> queryDictConf(DictItemFilter dictItemFilter) {
        List<DictConfDO> dictConfDOList = this.getDictConfDOList(dictItemFilter);
        return this.dictConverter.dictDOList2Req(dictConfDOList);
    }

    private List<DictConfDO> getDictConfDOList(DictItemFilter dictItemFilter) {
        QueryWrapper wrapper = new QueryWrapper();
        if (Objects.nonNull(dictItemFilter.getId())) {
            wrapper.lambda().eq(DictConfDO::getId, (Object)dictItemFilter.getId());
        }
        if (Objects.nonNull(dictItemFilter.getType())) {
            wrapper.lambda().eq(DictConfDO::getType, (Object)dictItemFilter.getType().name());
        }
        if (Objects.nonNull(dictItemFilter.getItemId())) {
            wrapper.lambda().eq(DictConfDO::getItemId, (Object)dictItemFilter.getItemId());
        }
        if (Objects.nonNull(dictItemFilter.getStatus())) {
            wrapper.lambda().eq(DictConfDO::getStatus, (Object)dictItemFilter.getStatus().name());
        }
        List dictConfDOList = this.dictConfMapper.selectList((Wrapper)wrapper);
        return dictConfDOList;
    }
}

