/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.persistence.repository.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.tencent.supersonic.common.pojo.enums.StatusEnum;
import com.tencent.supersonic.headless.server.persistence.dataobject.ModelDO;
import com.tencent.supersonic.headless.server.persistence.mapper.ModelDOCustomMapper;
import com.tencent.supersonic.headless.server.persistence.mapper.ModelDOMapper;
import com.tencent.supersonic.headless.server.persistence.repository.ModelRepository;
import com.tencent.supersonic.headless.server.pojo.ModelFilter;
import java.util.List;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ModelRepositoryImpl
implements ModelRepository {
    private ModelDOMapper modelDOMapper;
    private ModelDOCustomMapper modelDOCustomMapper;

    public ModelRepositoryImpl(ModelDOMapper modelDOMapper, ModelDOCustomMapper modelDOCustomMapper) {
        this.modelDOMapper = modelDOMapper;
        this.modelDOCustomMapper = modelDOCustomMapper;
    }

    @Override
    public void createModel(ModelDO datasourceDO) {
        this.modelDOMapper.insert(datasourceDO);
    }

    @Override
    public void updateModel(ModelDO datasourceDO) {
        this.modelDOMapper.updateById(datasourceDO);
    }

    @Override
    public List<ModelDO> getModelList(ModelFilter modelFilter) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.lambda().ne(ModelDO::getStatus, (Object)StatusEnum.DELETED.getCode());
        if (modelFilter.getDatabaseId() != null) {
            wrapper.lambda().eq(ModelDO::getDatabaseId, (Object)modelFilter.getDatabaseId());
        }
        if (!CollectionUtils.isEmpty(modelFilter.getDomainIds())) {
            wrapper.lambda().in(ModelDO::getDomainId, modelFilter.getDomainIds());
        }
        if (modelFilter.getDomainId() != null) {
            wrapper.lambda().eq(ModelDO::getDomainId, (Object)modelFilter.getDomainId());
        }
        if (!CollectionUtils.isEmpty(modelFilter.getIds())) {
            wrapper.lambda().in(ModelDO::getId, modelFilter.getIds());
        }
        if (!CollectionUtils.isEmpty(modelFilter.getModelIds())) {
            wrapper.lambda().in(ModelDO::getId, modelFilter.getModelIds());
        }
        if (modelFilter.getIncludesDetail() != null && !modelFilter.getIncludesDetail().booleanValue()) {
            wrapper.select(ModelDO.class, modelDO -> !modelDO.getColumn().equals("model_detail"));
        }
        return this.modelDOMapper.selectList((Wrapper)wrapper);
    }

    @Override
    public ModelDO getModelById(Long id) {
        return (ModelDO)this.modelDOMapper.selectById(id);
    }

    @Override
    public void batchUpdate(List<ModelDO> modelDOS) {
        this.modelDOCustomMapper.batchUpdateStatus(modelDOS);
    }
}

