/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.task;

import com.tencent.supersonic.common.config.EmbeddingConfig;
import com.tencent.supersonic.common.service.EmbeddingService;
import com.tencent.supersonic.headless.server.web.service.DimensionService;
import com.tencent.supersonic.headless.server.web.service.MetricService;
import dev.langchain4j.inmemory.spring.InMemoryEmbeddingStoreFactory;
import dev.langchain4j.store.embedding.EmbeddingStoreFactory;
import dev.langchain4j.store.embedding.EmbeddingStoreFactoryProvider;
import dev.langchain4j.store.embedding.TextSegmentConvert;
import java.util.List;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@Order(value=2)
public class MetaEmbeddingTask
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(MetaEmbeddingTask.class);
    @Autowired
    private EmbeddingService embeddingService;
    @Autowired
    private EmbeddingConfig embeddingConfig;
    @Autowired
    private MetricService metricService;
    @Autowired
    private DimensionService dimensionService;

    @PreDestroy
    public void onShutdown() {
        this.embeddingStorePersistFile();
    }

    private void embeddingStorePersistFile() {
        EmbeddingStoreFactory embeddingStoreFactory = EmbeddingStoreFactoryProvider.getFactory();
        if (embeddingStoreFactory instanceof InMemoryEmbeddingStoreFactory) {
            long startTime = System.currentTimeMillis();
            InMemoryEmbeddingStoreFactory inMemoryFactory = (InMemoryEmbeddingStoreFactory)embeddingStoreFactory;
            inMemoryFactory.persistFile();
            long duration = System.currentTimeMillis() - startTime;
            log.info("Embedding file has been regularly persisted in {} milliseconds", (Object)duration);
        }
    }

    @Scheduled(cron="${s2.inMemoryEmbeddingStore.persist.cron:0 0 * * * ?}")
    public void executePersistFileTask() {
        this.embeddingStorePersistFile();
    }

    @Scheduled(cron="${s2.reload.meta.embedding.corn:0 0 */2 * * ?}")
    public void reloadMetaEmbedding() {
        long startTime = System.currentTimeMillis();
        try {
            List metricDataItems = this.metricService.getDataEvent().getDataItems();
            this.embeddingService.addQuery(this.embeddingConfig.getMetaCollectionName(), TextSegmentConvert.convertToEmbedding((List)metricDataItems));
            List dimensionDataItems = this.dimensionService.getDataEvent().getDataItems();
            this.embeddingService.addQuery(this.embeddingConfig.getMetaCollectionName(), TextSegmentConvert.convertToEmbedding((List)dimensionDataItems));
        }
        catch (Exception e) {
            log.error("Failed to reload meta embedding.", (Throwable)e);
        }
        long duration = System.currentTimeMillis() - startTime;
        log.info("Embedding has been regularly reloaded  in {} milliseconds", (Object)duration);
    }

    public void run(String ... args) throws Exception {
        try {
            this.reloadMetaEmbedding();
        }
        catch (Exception e) {
            log.error("initMetaEmbedding error", (Throwable)e);
        }
    }
}

