/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.utils;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.output.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AliasGenerateHelper {
    private static final Logger log = LoggerFactory.getLogger(AliasGenerateHelper.class);
    @Autowired
    private ChatLanguageModel chatLanguageModel;

    public String getChatCompletion(String message) {
        SystemMessage from = SystemMessage.from((String)message);
        Response response = this.chatLanguageModel.generate(new ChatMessage[]{from});
        log.info("message:{}\n response:{}", (Object)message, (Object)response);
        return ((AiMessage)response.content()).text();
    }

    public String generateAlias(String mockType, String name, String bizName, String table, String desc, Boolean isPercentage) {
        String msg = "Assuming you are a professional data analyst specializing in metrics and dimensions, you have a vast amount of data analysis metrics content. You are familiar with the basic format of the content,Now, Construct your answer Based on the following json-schema.\n{\n\"$schema\": \"http://json-schema.org/draft-07/schema#\",\n\"type\": \"array\",\n\"minItems\": 2,\n\"maxItems\": 4,\n\"items\": {\n\"type\": \"string\",\n\"description\": \"Assuming you are a data analyst and give a defined " + mockType + " name: " + name + ",this " + mockType + " is from database and table: " + table + ",This " + mockType + " calculates the field source: " + bizName + ", The description of this metrics is: " + desc + ", provide some aliases for this, please take chinese or english,You must adhere to the following rules:\n1. Please do not generate aliases like xxx1, xxx2, xxx3.\n2. Please do not generate aliases that are the same as the original names of metrics/dimensions.\n3. Please pay attention to the quality of the generated aliases and    avoid creating aliases that look like test data.\n4. Please generate more Chinese aliases.},\n\"additionalProperties\":false}\nPlease double-check whether the answer conforms to the format described in the JSON-schema.\nANSWER JSON:";
        log.info("msg:{}", (Object)msg);
        return this.getChatCompletion(msg);
    }

    public String generateDimensionValueAlias(String json) {
        String msg = "Assuming you are a professional data analyst specializing in indicators,for you a json list\uff0cthe required content to follow is as follows: 1. The format of JSON,2. Only return in JSON format,3. the array item > 1 and < 5,more alias,for example\uff1ainput:[\"qq_music\",\"kugou_music\"],out:{\"tran\":[\"qq\u97f3\u4e50\",\"\u9177\u72d7\u97f3\u4e50\"],\"alias\":{\"qq_music\":[\"q\u97f3\",\"qq\u97f3\u4e50\"],\"kugou_music\":[\"kugou\",\"\u9177\u72d7\"]}},now input: " + json + ",answer json:";
        log.info("msg:{}", (Object)msg);
        return this.getChatCompletion(msg);
    }
}

