/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.utils;

import com.tencent.supersonic.common.util.ContextUtils;
import com.tencent.supersonic.common.util.JsonUtil;
import com.tencent.supersonic.headless.api.pojo.SemanticParseInfo;
import com.tencent.supersonic.headless.api.pojo.enums.ChatWorkflowState;
import com.tencent.supersonic.headless.api.pojo.request.SemanticQueryReq;
import com.tencent.supersonic.headless.api.pojo.response.ParseResp;
import com.tencent.supersonic.headless.api.pojo.response.SemanticTranslateResp;
import com.tencent.supersonic.headless.chat.ChatQueryContext;
import com.tencent.supersonic.headless.chat.corrector.SemanticCorrector;
import com.tencent.supersonic.headless.chat.mapper.SchemaMapper;
import com.tencent.supersonic.headless.chat.parser.SemanticParser;
import com.tencent.supersonic.headless.chat.query.QueryManager;
import com.tencent.supersonic.headless.chat.query.SemanticQuery;
import com.tencent.supersonic.headless.chat.query.rule.RuleSemanticQuery;
import com.tencent.supersonic.headless.server.facade.service.SemanticLayerService;
import com.tencent.supersonic.headless.server.processor.ResultProcessor;
import com.tencent.supersonic.headless.server.utils.ComponentFactory;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ChatWorkflowEngine {
    private static final Logger log = LoggerFactory.getLogger(ChatWorkflowEngine.class);
    private static final Logger keyPipelineLog = LoggerFactory.getLogger((String)"keyPipeline");
    private List<SchemaMapper> schemaMappers = ComponentFactory.getSchemaMappers();
    private List<SemanticParser> semanticParsers = ComponentFactory.getSemanticParsers();
    private List<SemanticCorrector> semanticCorrectors = ComponentFactory.getSemanticCorrectors();
    private List<ResultProcessor> resultProcessors = ComponentFactory.getResultProcessors();

    public void execute(ChatQueryContext queryCtx, ParseResp parseResult) {
        queryCtx.setChatWorkflowState(ChatWorkflowState.MAPPING);
        block6: while (queryCtx.getChatWorkflowState() != ChatWorkflowState.FINISHED) {
            switch (queryCtx.getChatWorkflowState()) {
                case MAPPING: {
                    this.performMapping(queryCtx);
                    if (queryCtx.getMapInfo().getMatchedDataSetInfos().size() == 0) {
                        parseResult.setState(ParseResp.ParseState.FAILED);
                        parseResult.setErrorMsg("No semantic entities can be mapped against user question.");
                        queryCtx.setChatWorkflowState(ChatWorkflowState.FINISHED);
                        continue block6;
                    }
                    queryCtx.setChatWorkflowState(ChatWorkflowState.PARSING);
                    continue block6;
                }
                case PARSING: {
                    this.performParsing(queryCtx);
                    if (queryCtx.getCandidateQueries().size() == 0) {
                        parseResult.setState(ParseResp.ParseState.FAILED);
                        parseResult.setErrorMsg("No semantic queries can be parsed out.");
                        queryCtx.setChatWorkflowState(ChatWorkflowState.FINISHED);
                        continue block6;
                    }
                    queryCtx.setChatWorkflowState(ChatWorkflowState.CORRECTING);
                    continue block6;
                }
                case CORRECTING: {
                    this.performCorrecting(queryCtx);
                    queryCtx.setChatWorkflowState(ChatWorkflowState.TRANSLATING);
                    continue block6;
                }
                case TRANSLATING: {
                    long start = System.currentTimeMillis();
                    this.performTranslating(queryCtx);
                    parseResult.getParseTimeCost().setSqlTime(System.currentTimeMillis() - start);
                    queryCtx.setChatWorkflowState(ChatWorkflowState.PROCESSING);
                    continue block6;
                }
            }
            this.performProcessing(queryCtx, parseResult);
            if (parseResult.getState().equals((Object)ParseResp.ParseState.PENDING)) {
                parseResult.setState(ParseResp.ParseState.COMPLETED);
            }
            queryCtx.setChatWorkflowState(ChatWorkflowState.FINISHED);
        }
    }

    private void performMapping(ChatQueryContext queryCtx) {
        if (Objects.isNull(queryCtx.getMapInfo()) || MapUtils.isEmpty((Map)queryCtx.getMapInfo().getDataSetElementMatches())) {
            this.schemaMappers.forEach(mapper -> mapper.map(queryCtx));
        }
    }

    private void performParsing(ChatQueryContext queryCtx) {
        this.semanticParsers.forEach(parser -> {
            parser.parse(queryCtx);
            log.debug("{} result:{}", (Object)parser.getClass().getSimpleName(), (Object)JsonUtil.toString((Object)queryCtx));
        });
    }

    private void performCorrecting(ChatQueryContext queryCtx) {
        List candidateQueries = queryCtx.getCandidateQueries();
        if (CollectionUtils.isNotEmpty((Collection)candidateQueries)) {
            block0: for (SemanticQuery semanticQuery : candidateQueries) {
                if (semanticQuery instanceof RuleSemanticQuery) continue;
                for (SemanticCorrector corrector : this.semanticCorrectors) {
                    corrector.correct(queryCtx, semanticQuery.getParseInfo());
                    if (ChatWorkflowState.CORRECTING.equals((Object)queryCtx.getChatWorkflowState())) continue;
                    continue block0;
                }
            }
        }
    }

    private void performProcessing(ChatQueryContext queryCtx, ParseResp parseResult) {
        this.resultProcessors.forEach(processor -> processor.process(parseResult, queryCtx));
    }

    private void performTranslating(ChatQueryContext chatQueryContext) {
        List<SemanticParseInfo> semanticParseInfos = chatQueryContext.getCandidateQueries().stream().map(SemanticQuery::getParseInfo).collect(Collectors.toList());
        semanticParseInfos.forEach(parseInfo -> {
            try {
                SemanticQuery semanticQuery = QueryManager.createQuery((String)parseInfo.getQueryMode());
                if (Objects.isNull(semanticQuery)) {
                    return;
                }
                semanticQuery.setParseInfo(parseInfo);
                SemanticQueryReq semanticQueryReq = semanticQuery.buildSemanticQueryReq();
                SemanticLayerService queryService = (SemanticLayerService)ContextUtils.getBean(SemanticLayerService.class);
                SemanticTranslateResp explain = queryService.translate(semanticQueryReq, chatQueryContext.getUser());
                parseInfo.getSqlInfo().setQuerySQL(explain.getQuerySQL());
                keyPipelineLog.info("SqlInfoProcessor results:\nParsed S2SQL: {}\nCorrected S2SQL: {}\nQuery SQL: {}", new Object[]{StringUtils.normalizeSpace((String)parseInfo.getSqlInfo().getParsedS2SQL()), StringUtils.normalizeSpace((String)parseInfo.getSqlInfo().getCorrectedS2SQL()), StringUtils.normalizeSpace((String)parseInfo.getSqlInfo().getQuerySQL())});
            }
            catch (Exception e) {
                log.warn("get sql info failed:{}", parseInfo, (Object)e);
            }
        });
    }
}

