/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.utils;

import com.tencent.supersonic.common.util.ContextUtils;
import com.tencent.supersonic.headless.chat.corrector.SemanticCorrector;
import com.tencent.supersonic.headless.chat.mapper.SchemaMapper;
import com.tencent.supersonic.headless.chat.parser.SemanticParser;
import com.tencent.supersonic.headless.server.processor.ResultProcessor;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.support.SpringFactoriesLoader;

public class ComponentFactory {
    private static final Logger log = LoggerFactory.getLogger(ComponentFactory.class);
    private static List<ResultProcessor> resultProcessors = new ArrayList<ResultProcessor>();
    private static List<SchemaMapper> schemaMappers = new ArrayList<SchemaMapper>();
    private static List<SemanticParser> semanticParsers = new ArrayList<SemanticParser>();
    private static List<SemanticCorrector> semanticCorrectors = new ArrayList<SemanticCorrector>();

    public static List<ResultProcessor> getResultProcessors() {
        return CollectionUtils.isEmpty(resultProcessors) ? ComponentFactory.init(ResultProcessor.class, resultProcessors) : resultProcessors;
    }

    public static List<SchemaMapper> getSchemaMappers() {
        return CollectionUtils.isEmpty(schemaMappers) ? ComponentFactory.init(SchemaMapper.class, schemaMappers) : schemaMappers;
    }

    public static List<SemanticParser> getSemanticParsers() {
        return CollectionUtils.isEmpty(semanticParsers) ? ComponentFactory.init(SemanticParser.class, semanticParsers) : semanticParsers;
    }

    public static List<SemanticCorrector> getSemanticCorrectors() {
        return CollectionUtils.isEmpty(semanticCorrectors) ? ComponentFactory.init(SemanticCorrector.class, semanticCorrectors) : semanticCorrectors;
    }

    public static <T> T getBean(String name, Class<T> tClass) {
        return (T)ContextUtils.getContext().getBean(name, tClass);
    }

    private static <T> List<T> init(Class<T> factoryType, List list) {
        list.addAll(SpringFactoriesLoader.loadFactories(factoryType, (ClassLoader)Thread.currentThread().getContextClassLoader()));
        return list;
    }

    private static <T> T init(Class<T> factoryType) {
        return (T)SpringFactoriesLoader.loadFactories(factoryType, (ClassLoader)Thread.currentThread().getContextClassLoader()).get(0);
    }
}

