/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.utils;

import com.tencent.supersonic.common.jsqlparser.SqlSelectFunctionHelper;
import com.tencent.supersonic.common.pojo.exception.InvalidArgumentException;
import com.tencent.supersonic.headless.api.pojo.MetricDefineByMetricParams;
import com.tencent.supersonic.headless.api.pojo.enums.MetricDefineType;
import com.tencent.supersonic.headless.api.pojo.request.MetricReq;
import com.tencent.supersonic.headless.server.utils.NameCheckUtils;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class MetricCheckUtils {
    public static void checkParam(MetricReq metricReq) {
        MetricDefineByMetricParams typeParams;
        String expr = "";
        if (MetricDefineType.METRIC.equals((Object)metricReq.getMetricDefineType())) {
            typeParams = metricReq.getMetricDefineByMetricParams();
            if (typeParams == null) {
                throw new InvalidArgumentException("\u6307\u6807\u5b9a\u4e49\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a");
            }
            expr = typeParams.getExpr();
            if (CollectionUtils.isEmpty((Collection)typeParams.getMetrics())) {
                throw new InvalidArgumentException("\u5b9a\u4e49\u6307\u6807\u7684\u6307\u6807\u5217\u8868\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a");
            }
            if (MetricCheckUtils.hasAggregateFunction(expr)) {
                throw new InvalidArgumentException("\u57fa\u4e8e\u6307\u6807\u6765\u521b\u5efa\u6307\u6807,\u8868\u8fbe\u5f0f\u4e2d\u4e0d\u53ef\u518d\u5305\u542b\u805a\u5408\u51fd\u6570");
            }
        }
        if (MetricDefineType.MEASURE.equals((Object)metricReq.getMetricDefineType())) {
            typeParams = metricReq.getMetricDefineByMeasureParams();
            if (typeParams == null) {
                throw new InvalidArgumentException("\u6307\u6807\u5b9a\u4e49\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a");
            }
            expr = typeParams.getExpr();
            if (CollectionUtils.isEmpty((Collection)typeParams.getMeasures())) {
                throw new InvalidArgumentException("\u5b9a\u4e49\u6307\u6807\u7684\u5ea6\u91cf\u5217\u8868\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a");
            }
            if (MetricCheckUtils.hasAggregateFunction(expr)) {
                throw new InvalidArgumentException("\u57fa\u4e8e\u5ea6\u91cf\u6765\u521b\u5efa\u6307\u6807,\u8868\u8fbe\u5f0f\u4e2d\u4e0d\u53ef\u518d\u5305\u542b\u805a\u5408\u51fd\u6570");
            }
        }
        if (MetricDefineType.FIELD.equals((Object)metricReq.getMetricDefineType())) {
            typeParams = metricReq.getMetricDefineByFieldParams();
            if (typeParams == null) {
                throw new InvalidArgumentException("\u6307\u6807\u5b9a\u4e49\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a");
            }
            expr = typeParams.getExpr();
            if (CollectionUtils.isEmpty((Collection)typeParams.getFields())) {
                throw new InvalidArgumentException("\u5b9a\u4e49\u6307\u6807\u7684\u5b57\u6bb5\u5217\u8868\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a");
            }
            if (!MetricCheckUtils.hasAggregateFunction(expr)) {
                throw new InvalidArgumentException("\u57fa\u4e8e\u5b57\u6bb5\u6765\u521b\u5efa\u6307\u6807,\u8868\u8fbe\u5f0f\u4e2d\u5fc5\u987b\u5305\u542b\u805a\u5408\u51fd\u6570");
            }
        }
        if (StringUtils.isBlank((CharSequence)expr)) {
            throw new InvalidArgumentException("\u8868\u8fbe\u5f0f\u4e0d\u53ef\u4e3a\u7a7a");
        }
        String forbiddenCharacters = NameCheckUtils.findForbiddenCharacters(metricReq.getName());
        if (StringUtils.isNotBlank((CharSequence)forbiddenCharacters)) {
            throw new InvalidArgumentException(String.format("\u540d\u79f0\u5305\u542b\u7279\u6b8a\u5b57\u7b26%s, \u8bf7\u4fee\u6539", forbiddenCharacters));
        }
    }

    private static boolean hasAggregateFunction(String expr) {
        String sql = String.format("select %s from table", expr);
        return SqlSelectFunctionHelper.hasAggregateFunction((String)sql);
    }
}

