/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.utils;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.common.pojo.enums.StatusEnum;
import com.tencent.supersonic.common.util.BeanMapper;
import com.tencent.supersonic.common.util.JsonUtil;
import com.tencent.supersonic.headless.api.pojo.Dim;
import com.tencent.supersonic.headless.api.pojo.DrillDownDimension;
import com.tencent.supersonic.headless.api.pojo.Identify;
import com.tencent.supersonic.headless.api.pojo.Measure;
import com.tencent.supersonic.headless.api.pojo.MeasureParam;
import com.tencent.supersonic.headless.api.pojo.MetricDefineByMeasureParams;
import com.tencent.supersonic.headless.api.pojo.ModelDetail;
import com.tencent.supersonic.headless.api.pojo.enums.DimensionType;
import com.tencent.supersonic.headless.api.pojo.enums.MetricDefineType;
import com.tencent.supersonic.headless.api.pojo.enums.SemanticType;
import com.tencent.supersonic.headless.api.pojo.request.DimensionReq;
import com.tencent.supersonic.headless.api.pojo.request.MetricReq;
import com.tencent.supersonic.headless.api.pojo.request.ModelReq;
import com.tencent.supersonic.headless.api.pojo.response.DomainResp;
import com.tencent.supersonic.headless.api.pojo.response.MeasureResp;
import com.tencent.supersonic.headless.api.pojo.response.ModelResp;
import com.tencent.supersonic.headless.server.persistence.dataobject.ModelDO;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

public class ModelConverter {
    public static ModelDO convert(ModelReq modelReq, User user) {
        ModelDO modelDO = new ModelDO();
        ModelDetail modelDetail = ModelConverter.createModelDetail(modelReq);
        modelReq.createdBy(user.getName());
        BeanMapper.mapper((Object)modelReq, (Object)modelDO);
        modelDO.setStatus(StatusEnum.ONLINE.getCode());
        modelDO.setModelDetail(JSONObject.toJSONString((Object)modelDetail));
        modelDO.setDrillDownDimensions(JSONObject.toJSONString((Object)modelReq.getDrillDownDimensions()));
        if (modelReq.getExt() != null) {
            modelDO.setExt(JSONObject.toJSONString((Object)modelReq.getExt()));
        }
        return modelDO;
    }

    public static ModelResp convert(ModelDO modelDO) {
        ModelResp modelResp = new ModelResp();
        BeanUtils.copyProperties((Object)modelDO, (Object)modelResp);
        modelResp.setAdmins((List)(StringUtils.isBlank((CharSequence)modelDO.getAdmin()) ? Lists.newArrayList() : Arrays.asList(modelDO.getAdmin().split(","))));
        modelResp.setAdminOrgs((List)(StringUtils.isBlank((CharSequence)modelDO.getAdminOrg()) ? Lists.newArrayList() : Arrays.asList(modelDO.getAdminOrg().split(","))));
        modelResp.setViewers((List)(StringUtils.isBlank((CharSequence)modelDO.getViewer()) ? Lists.newArrayList() : Arrays.asList(modelDO.getViewer().split(","))));
        modelResp.setViewOrgs((List)(StringUtils.isBlank((CharSequence)modelDO.getViewOrg()) ? Lists.newArrayList() : Arrays.asList(modelDO.getViewOrg().split(","))));
        modelResp.setDrillDownDimensions(JsonUtil.toList((String)modelDO.getDrillDownDimensions(), DrillDownDimension.class));
        modelResp.setModelDetail((ModelDetail)JsonUtil.toObject((String)modelDO.getModelDetail(), ModelDetail.class));
        modelResp.setExt((Map)JsonUtil.toObject((String)modelDO.getExt(), Map.class));
        return modelResp;
    }

    public static ModelResp convert(ModelDO modelDO, Map<Long, DomainResp> domainRespMap) {
        ModelResp modelResp = ModelConverter.convert(modelDO);
        DomainResp domainResp = domainRespMap.get(modelResp.getDomainId());
        if (domainResp != null) {
            String fullBizNamePath = domainResp.getFullPath() + modelResp.getBizName();
            modelResp.setFullPath(fullBizNamePath);
        }
        return modelResp;
    }

    public static ModelDO convert(ModelDO modelDO, ModelReq modelReq, User user) {
        ModelDetail modelDetail = ModelConverter.updateModelDetail(modelReq);
        BeanMapper.mapper((Object)modelReq, (Object)modelDO);
        if (modelReq.getDrillDownDimensions() != null) {
            modelDO.setDrillDownDimensions(JSONObject.toJSONString((Object)modelReq.getDrillDownDimensions()));
        }
        modelDO.setModelDetail(JSONObject.toJSONString((Object)modelDetail));
        if (modelReq.getExt() != null) {
            modelDO.setExt(JSONObject.toJSONString((Object)modelReq.getExt()));
        }
        modelDO.setUpdatedBy(user.getName());
        modelDO.setUpdatedAt(new Date());
        return modelDO;
    }

    public static MeasureResp convert(Measure measure, ModelResp modelResp) {
        MeasureResp measureResp = new MeasureResp();
        BeanUtils.copyProperties((Object)measure, (Object)measureResp);
        measureResp.setDatasourceId(modelResp.getId());
        measureResp.setDatasourceName(modelResp.getName());
        measureResp.setDatasourceBizName(modelResp.getBizName());
        measureResp.setModelId(modelResp.getId());
        return measureResp;
    }

    public static DimensionReq convert(Dim dim, ModelDO modelDO) {
        DimensionReq dimensionReq = new DimensionReq();
        dimensionReq.setName(dim.getName());
        dimensionReq.setBizName(dim.getBizName());
        dimensionReq.setDescription(dim.getName());
        dimensionReq.setSemanticType(SemanticType.CATEGORY.name());
        dimensionReq.setModelId(modelDO.getId());
        dimensionReq.setExpr(dim.getBizName());
        dimensionReq.setType(DimensionType.categorical.name());
        dimensionReq.setDescription(Objects.isNull(dim.getDescription()) ? "" : dim.getDescription());
        dimensionReq.setIsTag(dim.getIsTag());
        return dimensionReq;
    }

    public static MetricReq convert(Measure measure, ModelDO modelDO) {
        MetricReq metricReq = new MetricReq();
        metricReq.setName(measure.getName());
        metricReq.setBizName(measure.getExpr());
        metricReq.setDescription(measure.getName());
        metricReq.setModelId(modelDO.getId());
        MetricDefineByMeasureParams exprTypeParams = new MetricDefineByMeasureParams();
        exprTypeParams.setExpr(measure.getBizName());
        MeasureParam measureParam = new MeasureParam();
        BeanMapper.mapper((Object)measure, (Object)measureParam);
        exprTypeParams.setMeasures((List)Lists.newArrayList((Object[])new MeasureParam[]{measureParam}));
        metricReq.setMetricDefineByMeasureParams(exprTypeParams);
        metricReq.setMetricDefineType(MetricDefineType.MEASURE);
        return metricReq;
    }

    public static DimensionReq convert(Identify identify, ModelDO modelDO) {
        DimensionReq dimensionReq = new DimensionReq();
        dimensionReq.setName(identify.getName());
        dimensionReq.setBizName(identify.getBizName());
        dimensionReq.setDescription(identify.getName());
        dimensionReq.setSemanticType(SemanticType.CATEGORY.name());
        dimensionReq.setModelId(modelDO.getId());
        dimensionReq.setExpr(identify.getBizName());
        dimensionReq.setType(identify.getType());
        return dimensionReq;
    }

    public static List<ModelResp> convertList(List<ModelDO> modelDOS) {
        List<Object> modelDescs = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(modelDOS)) {
            modelDescs = modelDOS.stream().map(ModelConverter::convert).collect(Collectors.toList());
        }
        return modelDescs;
    }

    private static boolean isCreateDimension(Dim dim) {
        return dim.getIsCreateDimension() == 1 && StringUtils.isNotBlank((CharSequence)dim.getName()) && !dim.getType().equalsIgnoreCase(DimensionType.time.name());
    }

    private static boolean isCreateDimension(Identify identify) {
        return identify.getIsCreateDimension() == 1 && StringUtils.isNotBlank((CharSequence)identify.getName());
    }

    private static boolean isCreateMetric(Measure measure) {
        return measure.getIsCreateMetric() == 1 && StringUtils.isNotBlank((CharSequence)measure.getName());
    }

    public static List<Dim> getDimToCreateDimension(ModelDetail modelDetail) {
        if (CollectionUtils.isEmpty((Collection)modelDetail.getDimensions())) {
            return Lists.newArrayList();
        }
        return modelDetail.getDimensions().stream().filter(ModelConverter::isCreateDimension).collect(Collectors.toList());
    }

    public static List<Identify> getIdentityToCreateDimension(ModelDetail modelDetail) {
        if (CollectionUtils.isEmpty((Collection)modelDetail.getIdentifiers())) {
            return Lists.newArrayList();
        }
        return modelDetail.getIdentifiers().stream().filter(ModelConverter::isCreateDimension).collect(Collectors.toList());
    }

    public static List<Measure> getMeasureToCreateMetric(ModelDetail modelDetail) {
        if (CollectionUtils.isEmpty((Collection)modelDetail.getMeasures())) {
            return Lists.newArrayList();
        }
        return modelDetail.getMeasures().stream().filter(ModelConverter::isCreateMetric).collect(Collectors.toList());
    }

    public static List<DimensionReq> convertDimensionList(ModelDO modelDO) {
        List<Identify> identifies;
        List<Object> dimensionReqs = Lists.newArrayList();
        ModelDetail modelDetail = (ModelDetail)JSONObject.parseObject((String)modelDO.getModelDetail(), ModelDetail.class);
        List<Dim> dims = ModelConverter.getDimToCreateDimension(modelDetail);
        if (!CollectionUtils.isEmpty(dims)) {
            dimensionReqs = dims.stream().filter(dim -> StringUtils.isNotBlank((CharSequence)dim.getName())).map(dim -> ModelConverter.convert(dim, modelDO)).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(identifies = ModelConverter.getIdentityToCreateDimension(modelDetail))) {
            return dimensionReqs;
        }
        dimensionReqs.addAll(identifies.stream().map(identify -> ModelConverter.convert(identify, modelDO)).collect(Collectors.toList()));
        return dimensionReqs;
    }

    public static List<MetricReq> convertMetricList(ModelDO modelDO) {
        ModelDetail modelDetail = (ModelDetail)JSONObject.parseObject((String)modelDO.getModelDetail(), ModelDetail.class);
        List<Measure> measures = ModelConverter.getMeasureToCreateMetric(modelDetail);
        if (CollectionUtils.isEmpty(measures)) {
            return Lists.newArrayList();
        }
        return measures.stream().map(measure -> ModelConverter.convert(measure, modelDO)).collect(Collectors.toList());
    }

    private static ModelDetail createModelDetail(ModelReq modelReq) {
        ModelDetail modelDetail = new ModelDetail();
        List measures = modelReq.getModelDetail().getMeasures();
        if (measures == null) {
            measures = Lists.newArrayList();
        }
        for (Measure measure : measures) {
            if (StringUtils.isBlank((CharSequence)measure.getBizName())) continue;
            measure.setExpr(measure.getBizName());
            measure.setBizName(String.format("%s_%s", modelReq.getBizName(), measure.getExpr()));
        }
        BeanMapper.mapper((Object)modelReq.getModelDetail(), (Object)modelDetail);
        return modelDetail;
    }

    private static ModelDetail updateModelDetail(ModelReq modelReq) {
        ModelDetail modelDetail = new ModelDetail();
        List measures = modelReq.getModelDetail().getMeasures();
        if (measures == null) {
            measures = Lists.newArrayList();
        }
        for (Measure measure : measures) {
            if (StringUtils.isBlank((CharSequence)measure.getBizName())) continue;
            String oriFieldName = measure.getBizName().replaceFirst(modelReq.getBizName() + "_", "");
            measure.setExpr(oriFieldName);
            if (measure.getBizName().startsWith(modelReq.getBizName())) continue;
            measure.setBizName(String.format("%s_%s", modelReq.getBizName(), oriFieldName));
        }
        BeanMapper.mapper((Object)modelReq.getModelDetail(), (Object)modelDetail);
        return modelDetail;
    }
}

