/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.utils;

import com.tencent.supersonic.common.jsqlparser.SqlReplaceHelper;
import com.tencent.supersonic.common.jsqlparser.SqlSelectFunctionHelper;
import com.tencent.supersonic.common.jsqlparser.SqlSelectHelper;
import com.tencent.supersonic.common.pojo.Aggregator;
import com.tencent.supersonic.common.pojo.enums.AggOperatorEnum;
import com.tencent.supersonic.common.pojo.enums.QueryType;
import com.tencent.supersonic.common.pojo.enums.TimeDimensionEnum;
import com.tencent.supersonic.headless.api.pojo.MetricDefineByMeasureParams;
import com.tencent.supersonic.headless.api.pojo.MetricTable;
import com.tencent.supersonic.headless.api.pojo.QueryParam;
import com.tencent.supersonic.headless.api.pojo.SchemaItem;
import com.tencent.supersonic.headless.api.pojo.enums.AggOption;
import com.tencent.supersonic.headless.api.pojo.enums.EngineType;
import com.tencent.supersonic.headless.api.pojo.enums.MetricDefineType;
import com.tencent.supersonic.headless.api.pojo.enums.MetricType;
import com.tencent.supersonic.headless.api.pojo.request.QuerySqlReq;
import com.tencent.supersonic.headless.api.pojo.request.QueryStructReq;
import com.tencent.supersonic.headless.api.pojo.response.DatabaseResp;
import com.tencent.supersonic.headless.api.pojo.response.MetricResp;
import com.tencent.supersonic.headless.api.pojo.response.MetricSchemaResp;
import com.tencent.supersonic.headless.api.pojo.response.ModelResp;
import com.tencent.supersonic.headless.api.pojo.response.SemanticSchemaResp;
import com.tencent.supersonic.headless.core.adaptor.db.DbAdaptor;
import com.tencent.supersonic.headless.core.adaptor.db.DbAdaptorFactory;
import com.tencent.supersonic.headless.core.pojo.DataSetQueryParam;
import com.tencent.supersonic.headless.core.pojo.QueryStatement;
import com.tencent.supersonic.headless.core.utils.SqlGenerateUtils;
import com.tencent.supersonic.headless.server.utils.QueryStructUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class QueryReqConverter {
    private static final Logger log = LoggerFactory.getLogger(QueryReqConverter.class);
    @Autowired
    private QueryStructUtils queryStructUtils;
    @Autowired
    private SqlGenerateUtils sqlGenerateUtils;

    public QueryStatement convert(QuerySqlReq querySQLReq, SemanticSchemaResp semanticSchemaResp) throws Exception {
        if (semanticSchemaResp == null) {
            return new QueryStatement();
        }
        this.convertNameToBizName(querySQLReq, semanticSchemaResp);
        this.functionNameCorrector(querySQLReq, semanticSchemaResp);
        this.correctTableName(querySQLReq);
        String tableName = SqlSelectHelper.getTableName((String)querySQLReq.getSql());
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            return new QueryStatement();
        }
        String reqSql = querySQLReq.getSql();
        querySQLReq.setSql(SqlReplaceHelper.replaceAggAliasOrderItem((String)querySQLReq.getSql()));
        log.debug("replaceOrderAggSameAlias {} -> {}", (Object)reqSql, (Object)querySQLReq.getSql());
        List allFields = SqlSelectHelper.getAllFields((String)querySQLReq.getSql());
        List<MetricSchemaResp> metricSchemas = this.getMetrics(semanticSchemaResp, allFields);
        List metrics = metricSchemas.stream().map(m -> m.getBizName()).collect(Collectors.toList());
        QueryStructReq queryStructReq = new QueryStructReq();
        MetricTable metricTable = new MetricTable();
        metricTable.setMetrics(metrics);
        Set<String> dimensions = this.getDimensions(semanticSchemaResp, allFields);
        metricTable.setDimensions(new ArrayList<String>(dimensions));
        metricTable.setAlias(tableName.toLowerCase());
        if (CollectionUtils.isEmpty((Collection)metricTable.getMetrics())) {
            metricTable.setMetrics(new ArrayList());
            metricTable.getMetrics().add(this.sqlGenerateUtils.generateInternalMetricName(((ModelResp)semanticSchemaResp.getModelResps().get(0)).getBizName()));
        } else {
            queryStructReq.setAggregators(metricTable.getMetrics().stream().map(m -> new Aggregator(m, AggOperatorEnum.UNKNOWN)).collect(Collectors.toList()));
        }
        AggOption aggOption = this.getAggOption(querySQLReq, metricSchemas);
        metricTable.setAggOption(aggOption);
        ArrayList<MetricTable> tables = new ArrayList<MetricTable>();
        tables.add(metricTable);
        DataSetQueryParam result = new DataSetQueryParam();
        BeanUtils.copyProperties((Object)querySQLReq, (Object)result);
        result.setTables(tables);
        DatabaseResp database = semanticSchemaResp.getDatabaseResp();
        if (!this.sqlGenerateUtils.isSupportWith(EngineType.fromString((String)database.getType().toUpperCase()), database.getVersion())) {
            result.setSupportWith(false);
            result.setWithAlias(false);
        }
        this.generateDerivedMetric(semanticSchemaResp, aggOption, result);
        queryStructReq.setDateInfo(this.queryStructUtils.getDateConfBySql(querySQLReq.getSql()));
        queryStructReq.setDataSetId(querySQLReq.getDataSetId());
        queryStructReq.setQueryType(this.getQueryType(aggOption));
        log.debug("QueryReqConverter queryStructReq[{}]", (Object)queryStructReq);
        QueryParam queryParam = new QueryParam();
        this.convert(queryStructReq, queryParam);
        QueryStatement queryStatement = new QueryStatement();
        queryStatement.setQueryParam(queryParam);
        queryStatement.setDataSetQueryParam(result);
        queryStatement.setIsS2SQL(Boolean.valueOf(true));
        queryStatement.setMinMaxTime(this.queryStructUtils.getBeginEndTime(queryStructReq));
        queryStatement.setDataSetId(querySQLReq.getDataSetId());
        queryStatement.setLimit(querySQLReq.getLimit());
        return queryStatement;
    }

    public void convert(QueryStructReq queryStructReq, QueryParam queryParam) {
        BeanUtils.copyProperties((Object)queryStructReq, (Object)queryParam);
        queryParam.setOrders(queryStructReq.getOrders());
        queryParam.setMetrics(queryStructReq.getMetrics());
        queryParam.setGroups(queryStructReq.getGroups());
    }

    private AggOption getAggOption(QuerySqlReq databaseReq, List<MetricSchemaResp> metricSchemas) {
        String sql = databaseReq.getSql();
        if (!SqlSelectFunctionHelper.hasAggregateFunction((String)sql) || SqlSelectFunctionHelper.hasFunction((String)sql, (String)"count") || SqlSelectFunctionHelper.hasFunction((String)sql, (String)"count_distinct")) {
            return AggOption.OUTER;
        }
        if (databaseReq.isInnerLayerNative()) {
            return AggOption.NATIVE;
        }
        if (SqlSelectHelper.hasSubSelect((String)sql).booleanValue() || SqlSelectHelper.hasWith((String)sql).booleanValue() || SqlSelectHelper.hasGroupBy((String)sql)) {
            return AggOption.OUTER;
        }
        long defaultAggNullCnt = metricSchemas.stream().filter(m -> Objects.isNull(m.getDefaultAgg()) || StringUtils.isBlank((CharSequence)m.getDefaultAgg())).count();
        if (defaultAggNullCnt > 0L) {
            log.debug("getAggOption find null defaultAgg metric set to NATIVE");
            return AggOption.OUTER;
        }
        return AggOption.DEFAULT;
    }

    private void convertNameToBizName(QuerySqlReq querySqlReq, SemanticSchemaResp semanticSchemaResp) {
        Map<String, String> fieldNameToBizNameMap = this.getFieldNameToBizNameMap(semanticSchemaResp);
        String sql = querySqlReq.getSql();
        log.debug("dataSetId:{},convert name to bizName before:{}", (Object)querySqlReq.getDataSetId(), (Object)sql);
        String replaceFields = SqlReplaceHelper.replaceFields((String)sql, fieldNameToBizNameMap, (boolean)true);
        log.debug("dataSetId:{},convert name to bizName after:{}", (Object)querySqlReq.getDataSetId(), (Object)replaceFields);
        querySqlReq.setSql(replaceFields);
    }

    private Set<String> getDimensions(SemanticSchemaResp semanticSchemaResp, List<String> allFields) {
        Map<String, String> dimensionLowerToNameMap = semanticSchemaResp.getDimensions().stream().collect(Collectors.toMap(entry -> entry.getBizName().toLowerCase(), SchemaItem::getBizName, (k1, k2) -> k1));
        Map<String, String> internalLowerToNameMap = QueryStructUtils.internalCols.stream().collect(Collectors.toMap(String::toLowerCase, a -> a));
        dimensionLowerToNameMap.putAll(internalLowerToNameMap);
        return allFields.stream().filter(entry -> dimensionLowerToNameMap.containsKey(entry.toLowerCase())).map(entry -> (String)dimensionLowerToNameMap.get(entry.toLowerCase())).collect(Collectors.toSet());
    }

    private List<MetricSchemaResp> getMetrics(SemanticSchemaResp semanticSchemaResp, List<String> allFields) {
        Map<String, MetricSchemaResp> metricLowerToNameMap = semanticSchemaResp.getMetrics().stream().collect(Collectors.toMap(entry -> entry.getBizName().toLowerCase(), entry -> entry));
        return allFields.stream().filter(entry -> metricLowerToNameMap.containsKey(entry.toLowerCase())).map(entry -> (MetricSchemaResp)metricLowerToNameMap.get(entry.toLowerCase())).collect(Collectors.toList());
    }

    private void functionNameCorrector(QuerySqlReq databaseReq, SemanticSchemaResp semanticSchemaResp) {
        DatabaseResp database = semanticSchemaResp.getDatabaseResp();
        if (Objects.isNull(database) || Objects.isNull(database.getType())) {
            return;
        }
        String type = database.getType();
        DbAdaptor engineAdaptor = DbAdaptorFactory.getEngineAdaptor((String)type.toLowerCase());
        if (Objects.nonNull(engineAdaptor)) {
            String functionNameCorrector = engineAdaptor.functionNameCorrector(databaseReq.getSql());
            databaseReq.setSql(functionNameCorrector);
        }
    }

    protected Map<String, String> getFieldNameToBizNameMap(SemanticSchemaResp semanticSchemaResp) {
        Map<String, String> dimensionResults = semanticSchemaResp.getDimensions().stream().flatMap(entry -> this.getPairStream(entry.getAlias(), entry.getName(), entry.getBizName())).collect(Collectors.toMap(Pair::getLeft, Pair::getRight, (k1, k2) -> k1));
        Map<String, String> metricResults = semanticSchemaResp.getMetrics().stream().flatMap(entry -> this.getPairStream(entry.getAlias(), entry.getName(), entry.getBizName())).collect(Collectors.toMap(Pair::getLeft, Pair::getRight, (k1, k2) -> k1));
        dimensionResults.putAll(TimeDimensionEnum.getChNameToNameMap());
        dimensionResults.putAll(TimeDimensionEnum.getNameToNameMap());
        dimensionResults.putAll(metricResults);
        return dimensionResults;
    }

    private Stream<Pair<String, String>> getPairStream(String aliasStr, String name, String bizName) {
        HashSet<Pair> elements = new HashSet<Pair>();
        elements.add(Pair.of((Object)name, (Object)bizName));
        if (StringUtils.isNotBlank((CharSequence)aliasStr)) {
            List aliasList = SchemaItem.getAliasList((String)aliasStr);
            for (String alias : aliasList) {
                elements.add(Pair.of((Object)alias, (Object)bizName));
            }
        }
        return elements.stream();
    }

    public void correctTableName(QuerySqlReq querySqlReq) {
        String sql = querySqlReq.getSql();
        sql = SqlReplaceHelper.replaceTable((String)sql, (String)("t_" + querySqlReq.getDataSetId()));
        log.debug("correctTableName after:{}", (Object)sql);
        querySqlReq.setSql(sql);
    }

    private QueryType getQueryType(AggOption aggOption) {
        boolean isAgg = AggOption.isAgg((AggOption)aggOption);
        QueryType queryType = QueryType.DETAIL;
        if (isAgg) {
            queryType = QueryType.METRIC;
        }
        return queryType;
    }

    private void generateDerivedMetric(SemanticSchemaResp semanticSchemaResp, AggOption aggOption, DataSetQueryParam viewQueryParam) {
        String sql = viewQueryParam.getSql();
        for (MetricTable metricTable : viewQueryParam.getTables()) {
            HashSet<String> measures = new HashSet<String>();
            HashMap<String, String> replaces = new HashMap<String, String>();
            this.generateDerivedMetric(semanticSchemaResp, aggOption, metricTable.getMetrics(), metricTable.getDimensions(), measures, replaces);
            if (CollectionUtils.isEmpty(replaces)) continue;
            sql = SqlReplaceHelper.replaceSqlByExpression((String)sql, replaces);
            metricTable.setAggOption(AggOption.NATIVE);
            if (CollectionUtils.isEmpty(measures)) continue;
            metricTable.setMetrics(new ArrayList<String>(measures));
        }
        viewQueryParam.setSql(sql);
    }

    private void generateDerivedMetric(SemanticSchemaResp semanticSchemaResp, AggOption aggOption, List<String> metrics, List<String> dimensions, Set<String> measures, Map<String, String> replaces) {
        List metricResps = semanticSchemaResp.getMetrics();
        List dimensionResps = semanticSchemaResp.getDimensions();
        if (!metricResps.stream().anyMatch(m -> metrics.contains(m.getBizName()) && MetricType.isDerived((MetricDefineType)m.getMetricDefineType(), (MetricDefineByMeasureParams)m.getMetricDefineByMeasureParams()) != false)) {
            return;
        }
        log.debug("begin to generateDerivedMetric {} [{}]", (Object)aggOption, metrics);
        HashSet allFields = new HashSet();
        HashMap allMeasures = new HashMap();
        semanticSchemaResp.getModelResps().forEach(modelResp -> {
            allFields.addAll(modelResp.getFieldList());
            if (Objects.nonNull(modelResp.getModelDetail().getMeasures())) {
                modelResp.getModelDetail().getMeasures().stream().forEach(mm -> allMeasures.put(mm.getBizName(), mm));
            }
        });
        HashSet deriveDimension = new HashSet();
        HashSet deriveMetric = new HashSet();
        HashSet visitedMetric = new HashSet();
        if (!CollectionUtils.isEmpty((Collection)metricResps)) {
            for (MetricResp metricResp : metricResps) {
                if (!metrics.contains(metricResp.getBizName())) continue;
                if (MetricType.isDerived((MetricDefineType)metricResp.getMetricDefineType(), (MetricDefineByMeasureParams)metricResp.getMetricDefineByMeasureParams()).booleanValue()) {
                    String expr = this.sqlGenerateUtils.generateDerivedMetric(metricResps, allFields, allMeasures, dimensionResps, this.sqlGenerateUtils.getExpr(metricResp), metricResp.getMetricDefineType(), aggOption, visitedMetric, deriveMetric, deriveDimension);
                    replaces.put(metricResp.getBizName(), expr);
                    log.debug("derived metric {}->{}", (Object)metricResp.getBizName(), (Object)expr);
                    continue;
                }
                measures.add(metricResp.getBizName());
            }
        }
        measures.addAll(deriveMetric);
        deriveDimension.stream().filter(d -> !dimensions.contains(d)).forEach(d -> dimensions.add((String)d));
    }
}

