/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.web.rest;

import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.auth.api.authentication.utils.UserHolder;
import com.tencent.supersonic.headless.api.pojo.request.ClassReq;
import com.tencent.supersonic.headless.api.pojo.response.ClassResp;
import com.tencent.supersonic.headless.server.pojo.ClassFilter;
import com.tencent.supersonic.headless.server.web.service.ClassService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/semantic/class"})
public class ClassController {
    private final ClassService classService;

    public ClassController(ClassService classService) {
        this.classService = classService;
    }

    @PostMapping(value={"/create"})
    public ClassResp create(@RequestBody @Valid ClassReq classReq, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.classService.create(classReq, user);
    }

    @PutMapping(value={"/update"})
    public ClassResp update(@RequestBody @Valid ClassReq classReq, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.classService.update(classReq, user);
    }

    @DeleteMapping(value={"delete/{id}/{force}"})
    public Boolean delete(@PathVariable(value="id") Long id, @PathVariable(value="force") Boolean force, HttpServletRequest request, HttpServletResponse response) throws Exception {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.classService.delete(id, force, user);
    }

    @GetMapping(value={"delete/{id}/{force}"})
    public List<ClassResp> get(@RequestBody @Valid ClassFilter filter, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.classService.getClassList(filter, user);
    }
}

