/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.web.rest;

import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.auth.api.authentication.utils.UserHolder;
import com.tencent.supersonic.headless.api.pojo.request.DatabaseReq;
import com.tencent.supersonic.headless.api.pojo.request.SqlExecuteReq;
import com.tencent.supersonic.headless.api.pojo.response.DatabaseResp;
import com.tencent.supersonic.headless.api.pojo.response.SemanticQueryResp;
import com.tencent.supersonic.headless.server.pojo.DatabaseParameter;
import com.tencent.supersonic.headless.server.web.service.DatabaseService;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/semantic/database"})
public class DatabaseController {
    private DatabaseService databaseService;

    public DatabaseController(DatabaseService databaseService) {
        this.databaseService = databaseService;
    }

    @PostMapping(value={"/testConnect"})
    public boolean testConnect(@RequestBody DatabaseReq databaseReq, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.databaseService.testConnect(databaseReq, user);
    }

    @PostMapping(value={"/createOrUpdateDatabase"})
    public DatabaseResp createOrUpdateDatabase(@RequestBody DatabaseReq databaseReq, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.databaseService.createOrUpdateDatabase(databaseReq, user);
    }

    @GetMapping(value={"/{id}"})
    public DatabaseResp getDatabase(@PathVariable(value="id") Long id, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.databaseService.getDatabase(id, user);
    }

    @GetMapping(value={"/getDatabaseList"})
    public List<DatabaseResp> getDatabaseList(HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.databaseService.getDatabaseList(user);
    }

    @DeleteMapping(value={"/{id}"})
    public boolean deleteDatabase(@PathVariable(value="id") Long id) {
        this.databaseService.deleteDatabase(id);
        return true;
    }

    @PostMapping(value={"/executeSql"})
    public SemanticQueryResp executeSql(@RequestBody SqlExecuteReq sqlExecuteReq, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.databaseService.executeSql(sqlExecuteReq, sqlExecuteReq.getId(), user);
    }

    @RequestMapping(value={"/getDbNames/{id}"})
    public SemanticQueryResp getDbNames(@PathVariable(value="id") Long id) {
        return this.databaseService.getDbNames(id);
    }

    @RequestMapping(value={"/getTables/{id}/{db}"})
    public SemanticQueryResp getTables(@PathVariable(value="id") Long id, @PathVariable(value="db") String db) {
        return this.databaseService.getTables(id, db);
    }

    @RequestMapping(value={"/getColumns/{id}/{db}/{table}"})
    public SemanticQueryResp getColumns(@PathVariable(value="id") Long id, @PathVariable(value="db") String db, @PathVariable(value="table") String table) {
        return this.databaseService.getColumns(id, db, table);
    }

    @GetMapping(value={"/getDatabaseParameters"})
    public Map<String, List<DatabaseParameter>> getDatabaseParameters(HttpServletRequest request, HttpServletResponse response) {
        return this.databaseService.getDatabaseParameters();
    }
}

