/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.web.rest;

import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.auth.api.authentication.utils.UserHolder;
import com.tencent.supersonic.common.pojo.enums.SensitiveLevelEnum;
import com.tencent.supersonic.headless.api.pojo.DimValueMap;
import com.tencent.supersonic.headless.api.pojo.request.DimensionReq;
import com.tencent.supersonic.headless.api.pojo.request.DimensionValueReq;
import com.tencent.supersonic.headless.api.pojo.request.MetaBatchReq;
import com.tencent.supersonic.headless.api.pojo.request.PageDimensionReq;
import com.tencent.supersonic.headless.api.pojo.response.DimensionResp;
import com.tencent.supersonic.headless.api.pojo.response.SemanticQueryResp;
import com.tencent.supersonic.headless.server.facade.service.SemanticLayerService;
import com.tencent.supersonic.headless.server.pojo.DimensionFilter;
import com.tencent.supersonic.headless.server.pojo.MetaFilter;
import com.tencent.supersonic.headless.server.web.service.DimensionService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/semantic/dimension"})
public class DimensionController {
    @Autowired
    private DimensionService dimensionService;
    @Autowired
    private SemanticLayerService queryService;

    @PostMapping(value={"/createDimension"})
    public DimensionResp createDimension(@RequestBody DimensionReq dimensionReq, HttpServletRequest request, HttpServletResponse response) throws Exception {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.dimensionService.createDimension(dimensionReq, user);
    }

    @PostMapping(value={"/updateDimension"})
    public Boolean updateDimension(@RequestBody DimensionReq dimensionReq, HttpServletRequest request, HttpServletResponse response) throws Exception {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        this.dimensionService.updateDimension(dimensionReq, user);
        return true;
    }

    @PostMapping(value={"/batchUpdateStatus"})
    public Boolean batchUpdateStatus(@RequestBody MetaBatchReq metaBatchReq, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        this.dimensionService.batchUpdateStatus(metaBatchReq, user);
        return true;
    }

    @PostMapping(value={"/batchUpdateSensitiveLevel"})
    public Boolean batchUpdateSensitiveLevel(@RequestBody MetaBatchReq metaBatchReq, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        this.dimensionService.batchUpdateSensitiveLevel(metaBatchReq, user);
        return true;
    }

    @PostMapping(value={"/mockDimensionAlias"})
    public List<String> mockMetricAlias(@RequestBody DimensionReq dimensionReq, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.dimensionService.mockAlias(dimensionReq, "dimension", user);
    }

    @PostMapping(value={"/mockDimensionValuesAlias"})
    public List<DimValueMap> mockDimensionValuesAlias(@RequestBody DimensionReq dimensionReq, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.dimensionService.mockDimensionValueAlias(dimensionReq, user);
    }

    @GetMapping(value={"/getDimensionList/{modelId}"})
    public List<DimensionResp> getDimension(@PathVariable(value="modelId") Long modelId) {
        DimensionFilter dimensionFilter = new DimensionFilter();
        dimensionFilter.setModelIds(Lists.newArrayList((Object[])new Long[]{modelId}));
        return this.dimensionService.getDimensions(dimensionFilter);
    }

    @GetMapping(value={"/getDimensionInModelCluster/{modelId}"})
    public List<DimensionResp> getDimensionInModelCluster(@PathVariable(value="modelId") Long modelId) {
        return this.dimensionService.getDimensionInModelCluster(modelId);
    }

    @GetMapping(value={"/{modelId}/{dimensionName}"})
    public DimensionResp getDimensionDescByNameAndId(@PathVariable(value="modelId") Long modelId, @PathVariable(value="dimensionName") String dimensionBizName) {
        return this.dimensionService.getDimension(dimensionBizName, modelId);
    }

    @PostMapping(value={"/queryDimension"})
    public PageInfo<DimensionResp> queryDimension(@RequestBody PageDimensionReq pageDimensionReq) {
        return this.dimensionService.queryDimension(pageDimensionReq);
    }

    @PostMapping(value={"/queryDimValue"})
    public SemanticQueryResp queryDimValue(@RequestBody DimensionValueReq dimensionValueReq, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.queryService.queryDimensionValue(dimensionValueReq, user);
    }

    @DeleteMapping(value={"deleteDimension/{id}"})
    public Boolean deleteDimension(@PathVariable(value="id") Long id, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        this.dimensionService.deleteDimension(id, user);
        return true;
    }

    @GetMapping(value={"/getAllHighSensitiveDimension"})
    public List<DimensionResp> getAllHighSensitiveDimension() {
        MetaFilter metaFilter = new MetaFilter();
        metaFilter.setSensitiveLevel(SensitiveLevelEnum.HIGH.getCode());
        return this.dimensionService.getDimensions(metaFilter);
    }
}

