/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.web.rest;

import com.github.pagehelper.PageInfo;
import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.auth.api.authentication.utils.UserHolder;
import com.tencent.supersonic.headless.api.pojo.request.DictItemFilter;
import com.tencent.supersonic.headless.api.pojo.request.DictItemReq;
import com.tencent.supersonic.headless.api.pojo.request.DictSingleTaskReq;
import com.tencent.supersonic.headless.api.pojo.request.DictValueReq;
import com.tencent.supersonic.headless.api.pojo.response.DictItemResp;
import com.tencent.supersonic.headless.api.pojo.response.DictTaskResp;
import com.tencent.supersonic.headless.api.pojo.response.DictValueResp;
import com.tencent.supersonic.headless.server.task.MetaEmbeddingTask;
import com.tencent.supersonic.headless.server.web.service.DictConfService;
import com.tencent.supersonic.headless.server.web.service.DictTaskService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/semantic/knowledge"})
public class KnowledgeController {
    @Autowired
    private DictTaskService taskService;
    @Autowired
    private DictConfService confService;
    @Autowired
    private MetaEmbeddingTask embeddingTask;

    @PostMapping(value={"/conf"})
    public DictItemResp addDictConf(@RequestBody @Valid DictItemReq dictItemReq, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.confService.addDictConf(dictItemReq, user);
    }

    @PutMapping(value={"/conf"})
    public DictItemResp editDictConf(@RequestBody @Valid DictItemReq dictItemReq, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.confService.editDictConf(dictItemReq, user);
    }

    @PostMapping(value={"/conf/query"})
    public List<DictItemResp> queryDictConf(@RequestBody @Valid DictItemFilter filter, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.confService.queryDictConf(filter, user);
    }

    @PostMapping(value={"/task"})
    public Long addDictTask(@RequestBody DictSingleTaskReq taskReq, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.taskService.addDictTask(taskReq, user);
    }

    @PutMapping(value={"/task/delete"})
    public Long deleteDictTask(@RequestBody DictSingleTaskReq taskReq, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.taskService.deleteDictTask(taskReq, user);
    }

    @PutMapping(value={"/task/all"})
    public Boolean dailyDictTask(HttpServletRequest request, HttpServletResponse response) {
        return this.taskService.dailyDictTask();
    }

    @PostMapping(value={"/task/search"})
    public DictTaskResp queryLatestDictTask(@RequestBody DictSingleTaskReq taskReq, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.taskService.queryLatestDictTask(taskReq, user);
    }

    @GetMapping(value={"/meta/embedding/reload"})
    public Object reloadMetaEmbedding() {
        this.embeddingTask.reloadMetaEmbedding();
        return true;
    }

    @GetMapping(value={"/embedding/persistFile"})
    public Object executePersistFileTask() {
        this.embeddingTask.executePersistFileTask();
        return true;
    }

    @PostMapping(value={"/dict/data"})
    public PageInfo<DictValueResp> queryDictValue(@RequestBody @Valid DictValueReq dictValueReq, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.taskService.queryDictValue(dictValueReq, user);
    }

    @PostMapping(value={"/dict/file"})
    public String queryDictFilePath(@RequestBody @Valid DictValueReq dictValueReq, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.taskService.queryDictFilePath(dictValueReq, user);
    }
}

