/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.web.rest;

import com.google.common.collect.Lists;
import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.auth.api.authentication.utils.UserHolder;
import com.tencent.supersonic.common.pojo.enums.AuthType;
import com.tencent.supersonic.headless.api.pojo.request.FieldRemovedReq;
import com.tencent.supersonic.headless.api.pojo.request.MetaBatchReq;
import com.tencent.supersonic.headless.api.pojo.request.ModelReq;
import com.tencent.supersonic.headless.api.pojo.response.DatabaseResp;
import com.tencent.supersonic.headless.api.pojo.response.ModelResp;
import com.tencent.supersonic.headless.api.pojo.response.UnAvailableItemResp;
import com.tencent.supersonic.headless.server.pojo.ModelFilter;
import com.tencent.supersonic.headless.server.web.service.ModelService;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/semantic/model"})
public class ModelController {
    private ModelService modelService;

    public ModelController(ModelService modelService) {
        this.modelService = modelService;
    }

    @PostMapping(value={"/createModel"})
    public Boolean createModel(@RequestBody ModelReq modelReq, HttpServletRequest request, HttpServletResponse response) throws Exception {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        this.modelService.createModel(modelReq, user);
        return true;
    }

    @PostMapping(value={"/updateModel"})
    public Boolean updateModel(@RequestBody ModelReq modelReq, HttpServletRequest request, HttpServletResponse response) throws Exception {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        this.modelService.updateModel(modelReq, user);
        return true;
    }

    @DeleteMapping(value={"/deleteModel/{modelId}"})
    public Boolean deleteModel(@PathVariable(value="modelId") Long modelId, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        this.modelService.deleteModel(modelId, user);
        return true;
    }

    @GetMapping(value={"/getModelList/{domainId}"})
    public List<ModelResp> getModelList(@PathVariable(value="domainId") Long domainId, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.modelService.getModelListWithAuth(user, domainId, AuthType.ADMIN);
    }

    @GetMapping(value={"/getModel/{id}"})
    public ModelResp getModel(@PathVariable(value="id") Long id) {
        return this.modelService.getModel(id);
    }

    @GetMapping(value={"/getModelListByIds/{modelIds}"})
    public List<ModelResp> getModelListByIds(@PathVariable(value="modelIds") String modelIds) {
        List<Long> ids = Arrays.stream(modelIds.split(",")).map(Long::parseLong).collect(Collectors.toList());
        ModelFilter modelFilter = new ModelFilter();
        modelFilter.setIds(ids);
        return this.modelService.getModelList(modelFilter);
    }

    @GetMapping(value={"/getAllModelByDomainId"})
    public List<ModelResp> getAllModelByDomainId(@RequestParam(value="domainId") Long domainId) {
        return this.modelService.getAllModelByDomainIds(Lists.newArrayList((Object[])new Long[]{domainId}));
    }

    @GetMapping(value={"/getModelDatabase/{modelId}"})
    public DatabaseResp getModelDatabase(@PathVariable(value="modelId") Long modelId) {
        return this.modelService.getDatabaseByModelId(modelId);
    }

    @PostMapping(value={"/batchUpdateStatus"})
    public Boolean batchUpdateStatus(@RequestBody MetaBatchReq metaBatchReq, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        this.modelService.batchUpdateStatus(metaBatchReq, user);
        return true;
    }

    @PostMapping(value={"/getUnAvailableItem"})
    public UnAvailableItemResp getUnAvailableItem(@RequestBody FieldRemovedReq fieldRemovedReq) {
        return this.modelService.getUnAvailableItem(fieldRemovedReq);
    }
}

