/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.web.rest;

import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.auth.api.authentication.utils.UserHolder;
import com.tencent.supersonic.common.pojo.enums.AuthType;
import com.tencent.supersonic.headless.api.pojo.response.DomainResp;
import com.tencent.supersonic.headless.api.pojo.response.ModelResp;
import com.tencent.supersonic.headless.server.web.service.SchemaService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/semantic/schema"})
public class SchemaController {
    @Autowired
    private SchemaService schemaService;

    @GetMapping(value={"/domain/list"})
    public List<DomainResp> getDomainList(HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.schemaService.getDomainList(user);
    }

    @GetMapping(value={"/model/list"})
    public List<ModelResp> getModelList(@RequestParam(value="domainId") Long domainId, @RequestParam(value="authType") String authType, HttpServletRequest request, HttpServletResponse response) {
        User user = UserHolder.findUser((HttpServletRequest)request, (HttpServletResponse)response);
        return this.schemaService.getModelList(user, AuthType.valueOf((String)authType), domainId);
    }
}

