/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.web.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.common.pojo.enums.AuthType;
import com.tencent.supersonic.headless.api.pojo.request.CanvasReq;
import com.tencent.supersonic.headless.api.pojo.response.CanvasSchemaResp;
import com.tencent.supersonic.headless.api.pojo.response.DimensionResp;
import com.tencent.supersonic.headless.api.pojo.response.MetricResp;
import com.tencent.supersonic.headless.api.pojo.response.ModelResp;
import com.tencent.supersonic.headless.server.persistence.dataobject.CanvasDO;
import com.tencent.supersonic.headless.server.persistence.mapper.CanvasDOMapper;
import com.tencent.supersonic.headless.server.pojo.MetaFilter;
import com.tencent.supersonic.headless.server.web.service.CanvasService;
import com.tencent.supersonic.headless.server.web.service.DimensionService;
import com.tencent.supersonic.headless.server.web.service.MetricService;
import com.tencent.supersonic.headless.server.web.service.ModelService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CanvasServiceImpl
extends ServiceImpl<CanvasDOMapper, CanvasDO>
implements CanvasService {
    @Autowired
    private ModelService modelService;
    @Autowired
    private DimensionService dimensionService;
    @Autowired
    private MetricService metricService;

    @Override
    public List<CanvasDO> getCanvasList(Long domainId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(CanvasDO::getDomainId, (Object)domainId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<CanvasSchemaResp> getCanvasSchema(Long domainId, User user) {
        ArrayList canvasSchemaResps = Lists.newArrayList();
        List<ModelResp> modelResps = this.modelService.getModelListWithAuth(user, domainId, AuthType.ADMIN);
        for (ModelResp modelResp : modelResps) {
            CanvasSchemaResp canvasSchemaResp = new CanvasSchemaResp();
            MetaFilter metaFilter = new MetaFilter();
            metaFilter.setModelIds(Lists.newArrayList((Object[])new Long[]{modelResp.getId()}));
            List<MetricResp> metricResps = this.metricService.getMetrics(metaFilter);
            List<DimensionResp> dimensionResps = this.dimensionService.getDimensions(metaFilter);
            canvasSchemaResp.setModel(modelResp);
            canvasSchemaResp.setDimensions(dimensionResps);
            canvasSchemaResp.setMetrics(metricResps);
            canvasSchemaResp.setDomainId(domainId);
            canvasSchemaResps.add(canvasSchemaResp);
        }
        return canvasSchemaResps;
    }

    @Override
    public CanvasDO createOrUpdateCanvas(CanvasReq canvasReq, User user) {
        if (canvasReq.getId() == null) {
            canvasReq.createdBy(user.getName());
            CanvasDO viewInfoDO = new CanvasDO();
            BeanUtils.copyProperties((Object)canvasReq, (Object)viewInfoDO);
            this.save(viewInfoDO);
            return viewInfoDO;
        }
        Long id = canvasReq.getId();
        CanvasDO viewInfoDO = (CanvasDO)this.getById(id);
        canvasReq.updatedBy(user.getName());
        BeanUtils.copyProperties((Object)canvasReq, (Object)viewInfoDO);
        this.updateById(viewInfoDO);
        return viewInfoDO;
    }

    @Override
    public void deleteCanvas(Long id) {
        this.removeById(id);
    }
}

