/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.web.service.impl;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.common.jsqlparser.SqlSelectHelper;
import com.tencent.supersonic.common.pojo.enums.AuthType;
import com.tencent.supersonic.common.pojo.enums.QueryType;
import com.tencent.supersonic.common.pojo.enums.StatusEnum;
import com.tencent.supersonic.common.pojo.enums.TypeEnums;
import com.tencent.supersonic.common.pojo.exception.InvalidArgumentException;
import com.tencent.supersonic.common.util.BeanMapper;
import com.tencent.supersonic.headless.api.pojo.DataSetDetail;
import com.tencent.supersonic.headless.api.pojo.QueryConfig;
import com.tencent.supersonic.headless.api.pojo.SchemaItem;
import com.tencent.supersonic.headless.api.pojo.enums.TagDefineType;
import com.tencent.supersonic.headless.api.pojo.request.DataSetReq;
import com.tencent.supersonic.headless.api.pojo.request.QueryDataSetReq;
import com.tencent.supersonic.headless.api.pojo.request.QuerySqlReq;
import com.tencent.supersonic.headless.api.pojo.request.QueryStructReq;
import com.tencent.supersonic.headless.api.pojo.request.SemanticQueryReq;
import com.tencent.supersonic.headless.api.pojo.response.DataSetResp;
import com.tencent.supersonic.headless.api.pojo.response.DimensionResp;
import com.tencent.supersonic.headless.api.pojo.response.DomainResp;
import com.tencent.supersonic.headless.api.pojo.response.MetricResp;
import com.tencent.supersonic.headless.api.pojo.response.TagItem;
import com.tencent.supersonic.headless.server.persistence.dataobject.DataSetDO;
import com.tencent.supersonic.headless.server.persistence.mapper.DataSetDOMapper;
import com.tencent.supersonic.headless.server.pojo.MetaFilter;
import com.tencent.supersonic.headless.server.web.service.DataSetService;
import com.tencent.supersonic.headless.server.web.service.DimensionService;
import com.tencent.supersonic.headless.server.web.service.DomainService;
import com.tencent.supersonic.headless.server.web.service.MetricService;
import com.tencent.supersonic.headless.server.web.service.TagMetaService;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DataSetServiceImpl
extends ServiceImpl<DataSetDOMapper, DataSetDO>
implements DataSetService {
    private static final Logger log = LoggerFactory.getLogger(DataSetServiceImpl.class);
    @Autowired
    private DomainService domainService;
    @Lazy
    @Autowired
    private DimensionService dimensionService;
    @Lazy
    @Autowired
    private MetricService metricService;
    @Lazy
    @Autowired
    private TagMetaService tagMetaService;

    @Override
    public DataSetResp save(DataSetReq dataSetReq, User user) {
        dataSetReq.createdBy(user.getName());
        DataSetDO dataSetDO = this.convert(dataSetReq);
        dataSetDO.setStatus(StatusEnum.ONLINE.getCode());
        DataSetResp dataSetResp = this.convert(dataSetDO);
        this.conflictCheck(dataSetResp);
        this.save(dataSetDO);
        dataSetResp.setId(dataSetDO.getId());
        return dataSetResp;
    }

    @Override
    public DataSetResp update(DataSetReq dataSetReq, User user) {
        dataSetReq.updatedBy(user.getName());
        DataSetDO dataSetDO = this.convert(dataSetReq);
        DataSetResp dataSetResp = this.convert(dataSetDO);
        this.conflictCheck(dataSetResp);
        this.updateById(dataSetDO);
        return dataSetResp;
    }

    @Override
    public DataSetResp getDataSet(Long id) {
        DataSetDO dataSetDO = (DataSetDO)this.getById(id);
        return this.convert(dataSetDO);
    }

    @Override
    public List<DataSetResp> getDataSetList(MetaFilter metaFilter) {
        QueryWrapper wrapper = new QueryWrapper();
        if (metaFilter.getDomainId() != null) {
            wrapper.lambda().eq(DataSetDO::getDomainId, (Object)metaFilter.getDomainId());
        }
        if (!CollectionUtils.isEmpty(metaFilter.getIds())) {
            wrapper.lambda().in(DataSetDO::getId, metaFilter.getIds());
        }
        if (metaFilter.getStatus() != null) {
            wrapper.lambda().eq(DataSetDO::getStatus, (Object)metaFilter.getStatus());
        }
        if (metaFilter.getName() != null) {
            wrapper.lambda().eq(DataSetDO::getName, (Object)metaFilter.getName());
        }
        if (!CollectionUtils.isEmpty(metaFilter.getNames())) {
            wrapper.lambda().in(DataSetDO::getName, metaFilter.getNames());
        }
        wrapper.lambda().ne(DataSetDO::getStatus, (Object)StatusEnum.DELETED.getCode());
        return this.list((Wrapper)wrapper).stream().map(this::convert).collect(Collectors.toList());
    }

    @Override
    public void delete(Long id, User user) {
        DataSetDO dataSetDO = (DataSetDO)this.getById(id);
        dataSetDO.setStatus(StatusEnum.DELETED.getCode());
        dataSetDO.setUpdatedBy(user.getName());
        dataSetDO.setUpdatedAt(new Date());
        this.updateById(dataSetDO);
    }

    @Override
    public List<DataSetResp> getDataSets(String dataSetName, User user) {
        MetaFilter metaFilter = new MetaFilter();
        metaFilter.setName(dataSetName);
        return this.getDataSetsByAuth(user, metaFilter);
    }

    @Override
    public List<DataSetResp> getDataSets(List<String> dataSetNames, User user) {
        MetaFilter metaFilter = new MetaFilter();
        metaFilter.setNames(dataSetNames);
        return this.getDataSetsByAuth(user, metaFilter);
    }

    private List<DataSetResp> getDataSetsByAuth(User user, MetaFilter metaFilter) {
        List<DataSetResp> dataSetResps = this.getDataSetList(metaFilter);
        return this.getDataSetFilterByAuth(dataSetResps, user);
    }

    @Override
    public List<DataSetResp> getDataSetsInheritAuth(User user, Long domainId) {
        List<DataSetResp> dataSetResps = this.getDataSetList(new MetaFilter());
        List<DataSetResp> inheritAuthFormDomain = this.getDataSetFilterByDomainAuth(dataSetResps, user);
        Set<Object> dataSetRespSet = new HashSet<DataSetResp>(inheritAuthFormDomain);
        List<DataSetResp> dataSetFilterByAuth = this.getDataSetFilterByAuth(dataSetResps, user);
        dataSetRespSet.addAll(dataSetFilterByAuth);
        if (domainId != null && domainId > 0L) {
            dataSetRespSet = dataSetRespSet.stream().filter(modelResp -> modelResp.getDomainId().equals(domainId)).collect(Collectors.toSet());
        }
        return dataSetRespSet.stream().sorted(Comparator.comparingLong(SchemaItem::getId)).collect(Collectors.toList());
    }

    private List<DataSetResp> getDataSetFilterByAuth(List<DataSetResp> dataSetResps, User user) {
        return dataSetResps.stream().filter(dataSetResp -> DataSetServiceImpl.checkAdminPermission(user, dataSetResp)).collect(Collectors.toList());
    }

    private List<DataSetResp> getDataSetFilterByDomainAuth(List<DataSetResp> dataSetResps, User user) {
        Set<DomainResp> domainResps = this.domainService.getDomainAuthSet(user, AuthType.ADMIN);
        if (CollectionUtils.isEmpty(domainResps)) {
            return Lists.newArrayList();
        }
        Set domainIds = domainResps.stream().map(SchemaItem::getId).collect(Collectors.toSet());
        return dataSetResps.stream().filter(dataSetResp -> domainIds.contains(dataSetResp.getDomainId())).collect(Collectors.toList());
    }

    private DataSetResp convert(DataSetDO dataSetDO) {
        DataSetResp dataSetResp = new DataSetResp();
        BeanMapper.mapper((Object)dataSetDO, (Object)dataSetResp);
        dataSetResp.setDataSetDetail((DataSetDetail)JSONObject.parseObject((String)dataSetDO.getDataSetDetail(), DataSetDetail.class));
        if (dataSetDO.getQueryConfig() != null) {
            dataSetResp.setQueryConfig((QueryConfig)JSONObject.parseObject((String)dataSetDO.getQueryConfig(), QueryConfig.class));
        }
        dataSetResp.setAdmins((List)(StringUtils.isBlank((CharSequence)dataSetDO.getAdmin()) ? Lists.newArrayList() : Arrays.asList(dataSetDO.getAdmin().split(","))));
        dataSetResp.setAdminOrgs((List)(StringUtils.isBlank((CharSequence)dataSetDO.getAdminOrg()) ? Lists.newArrayList() : Arrays.asList(dataSetDO.getAdminOrg().split(","))));
        dataSetResp.setTypeEnum(TypeEnums.DATASET);
        List<TagItem> dimensionItems = this.tagMetaService.getTagItems(dataSetResp.dimensionIds(), TagDefineType.DIMENSION);
        dataSetResp.setAllDimensions(dimensionItems);
        List<TagItem> metricItems = this.tagMetaService.getTagItems(dataSetResp.metricIds(), TagDefineType.METRIC);
        dataSetResp.setAllMetrics(metricItems);
        return dataSetResp;
    }

    private DataSetDO convert(DataSetReq dataSetReq) {
        DataSetDO dataSetDO = new DataSetDO();
        BeanMapper.mapper((Object)dataSetReq, (Object)dataSetDO);
        dataSetDO.setDataSetDetail(JSONObject.toJSONString((Object)dataSetReq.getDataSetDetail(), (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        dataSetDO.setQueryConfig(JSONObject.toJSONString((Object)dataSetReq.getQueryConfig(), (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        return dataSetDO;
    }

    @Override
    public SemanticQueryReq convert(QueryDataSetReq queryDataSetReq) {
        QueryStructReq queryReq = new QueryStructReq();
        if (StringUtils.isNotBlank((CharSequence)queryDataSetReq.getSql())) {
            queryReq = new QuerySqlReq();
        }
        BeanUtils.copyProperties((Object)queryDataSetReq, (Object)queryReq);
        if (Objects.nonNull(queryDataSetReq.getQueryType()) && QueryType.DETAIL.equals((Object)queryDataSetReq.getQueryType())) {
            queryReq.setInnerLayerNative(true);
        }
        return queryReq;
    }

    public static boolean checkAdminPermission(User user, DataSetResp dataSetResp) {
        List admins = dataSetResp.getAdmins();
        if (user.isSuperAdmin()) {
            return true;
        }
        String userName = user.getName();
        return admins.contains(userName) || dataSetResp.getCreatedBy().equals(userName);
    }

    @Override
    public Map<Long, List<Long>> getModelIdToDataSetIds(List<Long> dataSetIds, User user) {
        MetaFilter metaFilter = new MetaFilter();
        metaFilter.setStatus(StatusEnum.ONLINE.getCode());
        metaFilter.setIds(dataSetIds);
        List<DataSetResp> dataSetList = this.getDataSetList(metaFilter);
        return dataSetList.stream().flatMap(dataSetResp -> dataSetResp.getAllModels().stream().map(modelId -> Pair.of((Object)modelId, (Object)dataSetResp.getId()))).collect(Collectors.groupingBy(Pair::getLeft, Collectors.mapping(Pair::getRight, Collectors.toList())));
    }

    @Override
    public Map<Long, List<Long>> getModelIdToDataSetIds() {
        return this.getModelIdToDataSetIds(Lists.newArrayList(), User.getFakeUser());
    }

    private void conflictCheck(DataSetResp dataSetResp) {
        List allDimensionIds = dataSetResp.dimensionIds();
        List allMetricIds = dataSetResp.metricIds();
        MetaFilter metaFilter = new MetaFilter();
        if (!CollectionUtils.isEmpty((Collection)allDimensionIds)) {
            metaFilter.setIds(allDimensionIds);
            List<DimensionResp> dimensionResps = this.dimensionService.getDimensions(metaFilter);
            List<String> duplicateDimensionNames = this.findDuplicates(dimensionResps, SchemaItem::getName);
            List<String> duplicateDimensionBizNames = this.findDuplicates(dimensionResps, SchemaItem::getBizName);
            if (!duplicateDimensionNames.isEmpty()) {
                throw new InvalidArgumentException("\u5b58\u5728\u76f8\u540c\u7684\u7ef4\u5ea6\u540d: " + duplicateDimensionNames);
            }
            if (!duplicateDimensionBizNames.isEmpty()) {
                throw new InvalidArgumentException("\u5b58\u5728\u76f8\u540c\u7684\u7ef4\u5ea6\u82f1\u6587\u540d: " + duplicateDimensionBizNames);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)allMetricIds)) {
            metaFilter.setIds(allMetricIds);
            List<MetricResp> metricResps = this.metricService.getMetrics(metaFilter);
            List<String> duplicateMetricNames = this.findDuplicates(metricResps, SchemaItem::getName);
            List<String> duplicateMetricBizNames = this.findDuplicates(metricResps, SchemaItem::getBizName);
            if (!duplicateMetricNames.isEmpty()) {
                throw new InvalidArgumentException("\u5b58\u5728\u76f8\u540c\u7684\u6307\u6807\u540d: " + duplicateMetricNames);
            }
            if (!duplicateMetricBizNames.isEmpty()) {
                throw new InvalidArgumentException("\u5b58\u5728\u76f8\u540c\u7684\u6307\u6807\u82f1\u6587\u540d: " + duplicateMetricBizNames);
            }
        }
    }

    private <T, R> List<String> findDuplicates(List<T> list, Function<T, R> keyExtractor) {
        return list.stream().collect(Collectors.groupingBy(keyExtractor, Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).map(Object::toString).collect(Collectors.toList());
    }

    @Override
    public Long getDataSetIdFromSql(String sql, User user) {
        List<DataSetResp> dataSets = null;
        try {
            String tableName = SqlSelectHelper.getTableName((String)sql);
            dataSets = this.getDataSets(tableName, user);
        }
        catch (Exception e) {
            log.error("getDataSetIdFromSql error:{}", (Throwable)e);
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(dataSets)) {
            throw new InvalidArgumentException("\u4eceSql\u53c2\u6570\u4e2d\u65e0\u6cd5\u83b7\u53d6\u5230DataSetId");
        }
        Long dataSetId = dataSets.get(0).getId();
        log.info("getDataSetIdFromSql dataSetId:{}", (Object)dataSetId);
        return dataSetId;
    }
}

