/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.web.service.impl;

import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.headless.api.pojo.request.DictItemFilter;
import com.tencent.supersonic.headless.api.pojo.request.DictItemReq;
import com.tencent.supersonic.headless.api.pojo.response.DictItemResp;
import com.tencent.supersonic.headless.server.persistence.dataobject.DictConfDO;
import com.tencent.supersonic.headless.server.persistence.repository.DictRepository;
import com.tencent.supersonic.headless.server.utils.DictUtils;
import com.tencent.supersonic.headless.server.web.service.DictConfService;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class DictConfServiceImpl
implements DictConfService {
    private static final Logger log = LoggerFactory.getLogger(DictConfServiceImpl.class);
    private final DictRepository dictRepository;
    private final DictUtils dictConverter;

    public DictConfServiceImpl(DictRepository dictRepository, DictUtils dictConverter) {
        this.dictRepository = dictRepository;
        this.dictConverter = dictConverter;
    }

    @Override
    public DictItemResp addDictConf(DictItemReq itemValueReq, User user) {
        DictConfDO dictConfDO = this.dictConverter.generateDictConfDO(itemValueReq, user);
        Boolean exist = this.checkConfExist(itemValueReq, user);
        if (exist.booleanValue()) {
            throw new RuntimeException("dictConf is existed");
        }
        Long id = this.dictRepository.addDictConf(dictConfDO);
        log.debug("dictConfDO:{}", (Object)dictConfDO);
        DictItemFilter filter = DictItemFilter.builder().id(id).status(itemValueReq.getStatus()).build();
        Optional dictItemResp = this.queryDictConf(filter, user).stream().findFirst();
        if (dictItemResp.isPresent()) {
            return (DictItemResp)dictItemResp.get();
        }
        return null;
    }

    private Boolean checkConfExist(DictItemReq itemValueReq, User user) {
        DictItemFilter filter = DictItemFilter.builder().build();
        BeanUtils.copyProperties((Object)itemValueReq, (Object)filter);
        filter.setStatus(null);
        Optional dictItemResp = this.queryDictConf(filter, user).stream().findFirst();
        if (dictItemResp.isPresent()) {
            return true;
        }
        return false;
    }

    @Override
    public DictItemResp editDictConf(DictItemReq itemValueReq, User user) {
        DictConfDO dictConfDO = this.dictConverter.generateDictConfDO(itemValueReq, user);
        this.dictRepository.editDictConf(dictConfDO);
        DictItemFilter filter = DictItemFilter.builder().build();
        BeanUtils.copyProperties((Object)itemValueReq, (Object)filter);
        Optional dictItemResp = this.queryDictConf(filter, user).stream().findFirst();
        if (dictItemResp.isPresent()) {
            return (DictItemResp)dictItemResp.get();
        }
        return null;
    }

    @Override
    public List<DictItemResp> queryDictConf(DictItemFilter dictItemFilter, User user) {
        return this.dictRepository.queryDictConf(dictItemFilter);
    }
}

