/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.web.service.impl;

import com.github.pagehelper.PageInfo;
import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.common.pojo.enums.StatusEnum;
import com.tencent.supersonic.common.pojo.enums.TaskStatusEnum;
import com.tencent.supersonic.headless.api.pojo.request.DictItemFilter;
import com.tencent.supersonic.headless.api.pojo.request.DictSingleTaskReq;
import com.tencent.supersonic.headless.api.pojo.request.DictValueReq;
import com.tencent.supersonic.headless.api.pojo.response.DictItemResp;
import com.tencent.supersonic.headless.api.pojo.response.DictTaskResp;
import com.tencent.supersonic.headless.api.pojo.response.DictValueResp;
import com.tencent.supersonic.headless.chat.knowledge.KnowledgeBaseService;
import com.tencent.supersonic.headless.chat.knowledge.file.FileHandler;
import com.tencent.supersonic.headless.chat.knowledge.helper.HanlpHelper;
import com.tencent.supersonic.headless.server.persistence.dataobject.DictTaskDO;
import com.tencent.supersonic.headless.server.persistence.repository.DictRepository;
import com.tencent.supersonic.headless.server.utils.DictUtils;
import com.tencent.supersonic.headless.server.web.service.DictTaskService;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DictTaskServiceImpl
implements DictTaskService {
    private static final Logger log = LoggerFactory.getLogger(DictTaskServiceImpl.class);
    @Value(value="${dict.flush.enable:true}")
    private Boolean dictFlushEnable;
    @Value(value="${dict.flush.daily.enable:true}")
    private Boolean dictFlushDailyEnable;
    @Value(value="${dict.file.type:txt}")
    private String dictFileType;
    private String dimValue = "DimValue_%d_%d";
    private final DictRepository dictRepository;
    private final DictUtils dictConverter;
    private final DictUtils dictUtils;
    private final FileHandler fileHandler;

    public DictTaskServiceImpl(DictRepository dictRepository, DictUtils dictConverter, DictUtils dictUtils, FileHandler fileHandler, KnowledgeBaseService knowledgeBaseService) {
        this.dictRepository = dictRepository;
        this.dictConverter = dictConverter;
        this.dictUtils = dictUtils;
        this.fileHandler = fileHandler;
    }

    @Override
    public Long addDictTask(DictSingleTaskReq taskReq, User user) {
        if (!this.dictFlushEnable.booleanValue()) {
            return 0L;
        }
        DictItemResp dictItemResp = this.fetchDictItemResp(taskReq);
        return this.handleDictTaskByItemResp(dictItemResp, user);
    }

    private Long handleDictTaskByItemResp(DictItemResp dictItemResp, User user) {
        DictTaskDO dictTaskDO = this.dictConverter.generateDictTaskDO(dictItemResp, user, TaskStatusEnum.PENDING);
        log.info("[addDictTask] dictTaskDO:{}", (Object)dictTaskDO);
        this.dictRepository.addDictTask(dictTaskDO);
        Long idInDb = dictTaskDO.getId();
        dictItemResp.setId(idInDb);
        this.runDictTask(dictItemResp, user);
        return idInDb;
    }

    private DictItemResp fetchDictItemResp(DictSingleTaskReq taskReq) {
        DictItemFilter dictItemFilter = DictItemFilter.builder().itemId(taskReq.getItemId()).type(taskReq.getType()).build();
        List<DictItemResp> dictItemRespList = this.dictRepository.queryDictConf(dictItemFilter);
        if (!CollectionUtils.isEmpty(dictItemRespList)) {
            return dictItemRespList.get(0);
        }
        return null;
    }

    private void runDictTask(DictItemResp dictItemResp, User user) {
        if (Objects.isNull(dictItemResp)) {
            return;
        }
        DictTaskDO dictTaskDO = this.dictRepository.queryDictTaskById(dictItemResp.getId());
        dictTaskDO.setStatus(TaskStatusEnum.RUNNING.getStatus());
        this.dictRepository.editDictTask(dictTaskDO);
        List<String> data = this.dictUtils.fetchItemValue(dictItemResp);
        String fileName = dictItemResp.fetchDictFileName() + "." + this.dictFileType;
        this.fileHandler.writeFile(data, fileName, Boolean.valueOf(false));
        try {
            HanlpHelper.reloadCustomDictionary();
            dictTaskDO.setStatus(TaskStatusEnum.SUCCESS.getStatus());
            this.dictRepository.editDictTask(dictTaskDO);
        }
        catch (IOException e) {
            log.error("reloadCustomDictionary error", (Throwable)e);
        }
    }

    @Override
    public Long deleteDictTask(DictSingleTaskReq taskReq, User user) {
        DictItemResp dictItemResp = this.fetchDictItemResp(taskReq);
        String fileName = dictItemResp.fetchDictFileName() + "." + this.dictFileType;
        this.fileHandler.deleteDictFile(fileName);
        try {
            HanlpHelper.reloadCustomDictionary();
        }
        catch (Exception e) {
            log.error("reloadCustomDictionary error", (Throwable)e);
        }
        DictTaskDO dictTaskDO = this.dictConverter.generateDictTaskDO(dictItemResp, user, TaskStatusEnum.INITIAL);
        log.info("[addDictTask] dictTaskDO:{}", (Object)dictTaskDO);
        this.dictRepository.addDictTask(dictTaskDO);
        return 0L;
    }

    @Override
    @Scheduled(cron="${knowledge.dimension.value.cron:0 0 0 * * ?}")
    public Boolean dailyDictTask() {
        log.info("[dailyDictTask] start");
        if (!this.dictFlushDailyEnable.booleanValue()) {
            log.info("dictFlushDailyEnable is false, now finish dailyDictTask");
        }
        DictItemFilter filter = DictItemFilter.builder().status(StatusEnum.ONLINE).build();
        List<DictItemResp> dictItemRespList = this.dictRepository.queryDictConf(filter);
        dictItemRespList.stream().forEach(item -> this.handleDictTaskByItemResp((DictItemResp)item, null));
        log.info("[dailyDictTask] finish");
        return true;
    }

    @Override
    public DictTaskResp queryLatestDictTask(DictSingleTaskReq taskReq, User user) {
        return this.dictRepository.queryLatestDictTask(taskReq);
    }

    @Override
    public PageInfo<DictValueResp> queryDictValue(DictValueReq dictValueReq, User user) {
        String fileName = String.format("dic_value_%d_%s_%s", dictValueReq.getModelId(), dictValueReq.getType().name(), dictValueReq.getItemId()) + "." + this.dictFileType;
        PageInfo dictValueRespList = this.fileHandler.queryDictValue(fileName, dictValueReq);
        return dictValueRespList;
    }

    @Override
    public String queryDictFilePath(DictValueReq dictValueReq, User user) {
        String fileName = String.format("dic_value_%d_%s_%s", dictValueReq.getModelId(), dictValueReq.getType().name(), dictValueReq.getItemId()) + "." + this.dictFileType;
        return this.fileHandler.queryDictFilePath(fileName);
    }
}

