/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.web.service.impl;

import com.google.common.collect.Lists;
import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.auth.api.authentication.service.UserService;
import com.tencent.supersonic.common.pojo.enums.AuthType;
import com.tencent.supersonic.common.pojo.enums.StatusEnum;
import com.tencent.supersonic.common.util.BeanMapper;
import com.tencent.supersonic.headless.api.pojo.SchemaItem;
import com.tencent.supersonic.headless.api.pojo.request.DomainReq;
import com.tencent.supersonic.headless.api.pojo.request.DomainUpdateReq;
import com.tencent.supersonic.headless.api.pojo.response.DomainResp;
import com.tencent.supersonic.headless.api.pojo.response.ModelResp;
import com.tencent.supersonic.headless.server.persistence.dataobject.DomainDO;
import com.tencent.supersonic.headless.server.persistence.repository.DomainRepository;
import com.tencent.supersonic.headless.server.utils.DomainConvert;
import com.tencent.supersonic.headless.server.web.service.DomainService;
import com.tencent.supersonic.headless.server.web.service.ModelService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.util.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DomainServiceImpl
implements DomainService {
    private static final Logger log = LoggerFactory.getLogger(DomainServiceImpl.class);
    private final DomainRepository domainRepository;
    private final ModelService modelService;
    private final UserService userService;

    public DomainServiceImpl(DomainRepository domainRepository, @Lazy ModelService modelService, UserService userService) {
        this.domainRepository = domainRepository;
        this.modelService = modelService;
        this.userService = userService;
    }

    @Override
    public DomainResp createDomain(DomainReq domainReq, User user) {
        DomainDO domainDO = DomainConvert.convert(domainReq, user);
        domainDO.setStatus(StatusEnum.ONLINE.getCode());
        this.domainRepository.createDomain(domainDO);
        return DomainConvert.convert(domainDO);
    }

    @Override
    public DomainResp updateDomain(DomainUpdateReq domainUpdateReq, User user) {
        domainUpdateReq.updatedBy(user.getName());
        DomainDO domainDO = this.getDomainDO(domainUpdateReq.getId());
        BeanMapper.mapper((Object)domainUpdateReq, (Object)domainDO);
        this.domainRepository.updateDomain(domainDO);
        return DomainConvert.convert(domainDO);
    }

    @Override
    public void deleteDomain(Long id) {
        List<ModelResp> modelResps = this.modelService.getModelByDomainIds(Lists.newArrayList((Object[])new Long[]{id}));
        if (!CollectionUtils.isEmpty(modelResps)) {
            throw new RuntimeException("\u8be5\u4e3b\u9898\u57df\u4e0b\u8fd8\u5b58\u5728\u6a21\u578b, \u6682\u4e0d\u80fd\u5220\u9664, \u8bf7\u786e\u8ba4");
        }
        List<DomainResp> domainList = this.getDomainList();
        for (DomainResp domainResp : domainList) {
            if (!id.equals(domainResp.getParentId())) continue;
            throw new RuntimeException("\u8be5\u4e3b\u9898\u57df\u4e0b\u8fd8\u5b58\u5728\u5b50\u4e3b\u9898\u57df, \u6682\u4e0d\u80fd\u5220\u9664, \u8bf7\u786e\u8ba4");
        }
        this.domainRepository.deleteDomain(id);
    }

    @Override
    public List<DomainResp> getDomainList() {
        return this.convertList(this.domainRepository.getDomainList());
    }

    @Override
    public List<DomainResp> getDomainList(List<Long> domainIds) {
        return this.getDomainList().stream().filter(domainDO -> domainIds.contains(domainDO.getId())).collect(Collectors.toList());
    }

    @Override
    public List<DomainResp> getDomainListWithAdminAuth(User user) {
        Set<DomainResp> domainWithAuthAll = this.getDomainAuthSet(user, AuthType.ADMIN);
        if (!CollectionUtils.isEmpty(domainWithAuthAll)) {
            List<Long> domainIds = domainWithAuthAll.stream().map(SchemaItem::getId).collect(Collectors.toList());
            domainWithAuthAll.addAll(this.getParentDomain(domainIds));
        }
        List<ModelResp> modelResps = this.modelService.getModelAuthList(user, null, AuthType.ADMIN);
        List<Long> domainIdsFromModel = modelResps.stream().map(ModelResp::getDomainId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(modelResps)) {
            domainWithAuthAll.addAll(this.getParentDomain(domainIdsFromModel));
        }
        for (DomainResp domainResp : domainWithAuthAll) {
            if (!domainIdsFromModel.contains(domainResp.getId())) continue;
            domainResp.setHasModel(true);
        }
        return new ArrayList<DomainResp>(domainWithAuthAll).stream().sorted(Comparator.comparingLong(SchemaItem::getId)).collect(Collectors.toList());
    }

    @Override
    public Set<DomainResp> getDomainAuthSet(User user, AuthType authTypeEnum) {
        List<DomainResp> domainResps = this.getDomainList();
        Set orgIds = this.userService.getUserAllOrgId(user.getName());
        List<Object> domainWithAuth = Lists.newArrayList();
        if (authTypeEnum.equals((Object)AuthType.ADMIN)) {
            domainWithAuth = domainResps.stream().filter(domainResp -> this.checkAdminPermission(orgIds, user, (DomainResp)domainResp)).collect(Collectors.toList());
        }
        if (authTypeEnum.equals((Object)AuthType.VISIBLE)) {
            domainWithAuth = domainResps.stream().filter(domainResp -> this.checkViewPermission(orgIds, user, (DomainResp)domainResp)).collect(Collectors.toList());
        }
        List<Long> domainIds = domainWithAuth.stream().map(SchemaItem::getId).collect(Collectors.toList());
        return this.getDomainChildren(domainIds).stream().peek(domainResp -> domainResp.setHasEditPermission(true)).collect(Collectors.toSet());
    }

    private Set<DomainResp> getParentDomain(List<Long> ids) {
        HashSet<DomainResp> domainSet = new HashSet<DomainResp>();
        if (CollectionUtils.isEmpty(ids)) {
            return Sets.newHashSet(domainSet);
        }
        Map<Long, DomainResp> domainRespMap = this.getDomainMap();
        for (Long domainId : ids) {
            DomainResp domainResp = domainRespMap.get(domainId);
            while (domainResp != null) {
                domainSet.add(domainResp);
                domainResp = domainRespMap.get(domainResp.getParentId());
            }
        }
        return domainSet;
    }

    @Override
    public DomainResp getDomain(Long id) {
        Map<Long, String> fullDomainPathMap = this.getDomainFullPathMap();
        return DomainConvert.convert(this.getDomainDO(id), fullDomainPathMap);
    }

    @Override
    public Map<Long, String> getDomainFullPath() {
        return this.getDomainFullPathMap();
    }

    private List<DomainResp> convertList(List<DomainDO> domainDOS) {
        ArrayList domainDescs = Lists.newArrayList();
        if (CollectionUtils.isEmpty(domainDOS)) {
            return domainDescs;
        }
        Map<Long, String> fullDomainPathMap = this.getDomainFullPath();
        return domainDOS.stream().map(domainDO -> DomainConvert.convert(domainDO, fullDomainPathMap)).collect(Collectors.toList());
    }

    @Override
    public Map<Long, DomainResp> getDomainMap() {
        return this.getDomainList().stream().collect(Collectors.toMap(SchemaItem::getId, a -> a, (k1, k2) -> k1));
    }

    @Override
    public Set<DomainResp> getDomainChildren(List<Long> domainIds) {
        HashSet<DomainResp> childDomains = new HashSet<DomainResp>();
        if (CollectionUtils.isEmpty(domainIds)) {
            return childDomains;
        }
        Map<Long, DomainResp> allDomainMap = this.getDomainMap();
        for (Long domainId : domainIds) {
            DomainResp domain = allDomainMap.get(domainId);
            if (domain == null) continue;
            childDomains.add(domain);
            LinkedList<DomainResp> queue = new LinkedList<DomainResp>();
            queue.add(domain);
            while (!queue.isEmpty()) {
                DomainResp currentDomain = (DomainResp)queue.poll();
                for (DomainResp child : allDomainMap.values()) {
                    if (!Objects.equals(child.getParentId(), currentDomain.getId())) continue;
                    childDomains.add(child);
                    queue.add(child);
                }
            }
        }
        return childDomains;
    }

    public Map<Long, String> getDomainFullPathMap() {
        HashMap<Long, String> domainFullPathMap = new HashMap<Long, String>();
        List<DomainDO> domainDOList = this.domainRepository.getDomainList();
        Map<Long, DomainDO> domainDOMap = domainDOList.stream().collect(Collectors.toMap(DomainDO::getId, a -> a, (k1, k2) -> k1));
        for (DomainDO domainDO : domainDOList) {
            Long domainId = domainDO.getId();
            StringBuilder fullPath = new StringBuilder(domainDO.getBizName() + "/");
            Long parentId = domainDO.getParentId();
            while (parentId != null && parentId > 0L) {
                domainDO = domainDOMap.get(parentId);
                if (domainDO == null) {
                    String message = String.format("get domain : %s failed", parentId);
                    throw new RuntimeException(message);
                }
                fullPath.insert(0, domainDO.getBizName() + "/");
                parentId = domainDO.getParentId();
            }
            domainFullPathMap.put(domainId, fullPath.toString());
        }
        return domainFullPathMap;
    }

    protected DomainDO getDomainDO(Long id) {
        return this.domainRepository.getDomainById(id);
    }

    private boolean checkAdminPermission(Set<String> orgIds, User user, DomainResp domainResp) {
        List admins = domainResp.getAdmins();
        List adminOrgs = domainResp.getAdminOrgs();
        if (user.isSuperAdmin()) {
            return true;
        }
        if (admins.contains(user.getName()) || domainResp.getCreatedBy().equals(user.getName())) {
            return true;
        }
        if (CollectionUtils.isEmpty((Collection)adminOrgs)) {
            return false;
        }
        for (String orgId : orgIds) {
            if (!adminOrgs.contains(orgId)) continue;
            return true;
        }
        return false;
    }

    private boolean checkViewPermission(Set<String> orgIds, User user, DomainResp domainResp) {
        if (this.checkAdminPermission(orgIds, user, domainResp)) {
            return true;
        }
        List viewers = domainResp.getViewers();
        List viewOrgs = domainResp.getViewOrgs();
        if (domainResp.openToAll()) {
            return true;
        }
        if (viewers.contains(user.getName())) {
            return true;
        }
        if (CollectionUtils.isEmpty((Collection)viewOrgs)) {
            return false;
        }
        for (String orgId : orgIds) {
            if (!viewOrgs.contains(orgId)) continue;
            return true;
        }
        return false;
    }
}

