/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.web.service.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.util.FileUtils;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.google.common.collect.Lists;
import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.common.pojo.Aggregator;
import com.tencent.supersonic.common.pojo.DateConf;
import com.tencent.supersonic.common.pojo.QueryColumn;
import com.tencent.supersonic.common.pojo.enums.TimeDimensionEnum;
import com.tencent.supersonic.common.util.DateUtils;
import com.tencent.supersonic.headless.api.pojo.DrillDownDimension;
import com.tencent.supersonic.headless.api.pojo.RelateDimension;
import com.tencent.supersonic.headless.api.pojo.SchemaItem;
import com.tencent.supersonic.headless.api.pojo.enums.SemanticType;
import com.tencent.supersonic.headless.api.pojo.request.BatchDownloadReq;
import com.tencent.supersonic.headless.api.pojo.request.DownloadMetricReq;
import com.tencent.supersonic.headless.api.pojo.request.QueryMetricReq;
import com.tencent.supersonic.headless.api.pojo.request.QuerySqlReq;
import com.tencent.supersonic.headless.api.pojo.request.QueryStructReq;
import com.tencent.supersonic.headless.api.pojo.request.SemanticQueryReq;
import com.tencent.supersonic.headless.api.pojo.response.DimensionResp;
import com.tencent.supersonic.headless.api.pojo.response.MetricResp;
import com.tencent.supersonic.headless.api.pojo.response.SemanticQueryResp;
import com.tencent.supersonic.headless.core.utils.DataTransformUtils;
import com.tencent.supersonic.headless.server.facade.service.SemanticLayerService;
import com.tencent.supersonic.headless.server.pojo.DataDownload;
import com.tencent.supersonic.headless.server.pojo.MetaFilter;
import com.tencent.supersonic.headless.server.web.service.DimensionService;
import com.tencent.supersonic.headless.server.web.service.DownloadService;
import com.tencent.supersonic.headless.server.web.service.MetricService;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DownloadServiceImpl
implements DownloadService {
    private static final Logger log = LoggerFactory.getLogger(DownloadServiceImpl.class);
    private static final String internMetricCol = "\u6307\u6807\u540d\u79f0";
    private static final long downloadSize = 10000L;
    private MetricService metricService;
    private DimensionService dimensionService;
    private SemanticLayerService queryService;

    public DownloadServiceImpl(MetricService metricService, DimensionService dimensionService, SemanticLayerService queryService) {
        this.metricService = metricService;
        this.dimensionService = dimensionService;
        this.queryService = queryService;
    }

    @Override
    public void downloadByStruct(DownloadMetricReq downloadMetricReq, User user, HttpServletResponse response) throws Exception {
        String fileName = String.format("%s_%s.xlsx", "supersonic", DateUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss"));
        File file = FileUtils.createTmpFile((String)fileName);
        try {
            QueryStructReq queryStructReq = this.metricService.convert((QueryMetricReq)downloadMetricReq);
            SemanticQueryResp queryResult = this.queryService.queryByReq((SemanticQueryReq)queryStructReq.convert(true), user);
            DataDownload dataDownload = this.buildDataDownload(queryResult, queryStructReq, downloadMetricReq.isTransform());
            ((ExcelWriterSheetBuilder)EasyExcel.write((File)file).sheet("Sheet1").head(dataDownload.getHeaders())).doWrite(dataDownload.getData());
        }
        catch (RuntimeException e) {
            ((ExcelWriterSheetBuilder)EasyExcel.write((File)file).sheet("Sheet1").head(this.buildErrMessageHead())).doWrite(this.buildErrMessageData(e.getMessage()));
            return;
        }
        this.downloadFile(response, file, fileName);
    }

    @Override
    public void batchDownload(BatchDownloadReq batchDownloadReq, User user, HttpServletResponse response) throws Exception {
        String fileName = String.format("%s_%s.xlsx", "supersonic", DateUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss"));
        File file = FileUtils.createTmpFile((String)fileName);
        List metricIds = batchDownloadReq.getMetricIds();
        if (CollectionUtils.isEmpty((Collection)metricIds)) {
            return;
        }
        this.batchDownload(batchDownloadReq, user, file);
        this.downloadFile(response, file, fileName);
    }

    public void batchDownload(BatchDownloadReq batchDownloadReq, User user, File file) throws Exception {
        List metricIds = batchDownloadReq.getMetricIds();
        MetaFilter metaFilter = new MetaFilter();
        metaFilter.setIds(metricIds);
        List<MetricResp> metricResps = this.metricService.getMetrics(metaFilter);
        Map<String, List<MetricResp>> metricMap = this.getMetricMap(metricResps);
        List<Long> dimensionIds = metricResps.stream().map(metricResp -> this.metricService.getDrillDownDimension(metricResp.getId())).flatMap(Collection::stream).map(DrillDownDimension::getDimensionId).collect(Collectors.toList());
        metaFilter.setIds(dimensionIds);
        Map<Long, DimensionResp> dimensionRespMap = this.dimensionService.getDimensions(metaFilter).stream().collect(Collectors.toMap(SchemaItem::getId, d -> d));
        ExcelWriter excelWriter = EasyExcel.write((File)file).build();
        int sheetCount = 1;
        for (List<MetricResp> metrics : metricMap.values()) {
            if (CollectionUtils.isEmpty(metrics)) continue;
            MetricResp metricResp2 = metrics.get(0);
            List<DimensionResp> dimensions = this.getMetricRelaDimensions(metricResp2, dimensionRespMap);
            for (MetricResp metric : metrics) {
                try {
                    QueryStructReq queryStructReq = this.buildDownloadReq(dimensions, metric, batchDownloadReq);
                    QuerySqlReq querySqlReq = queryStructReq.convert();
                    querySqlReq.setNeedAuth(true);
                    SemanticQueryResp queryResult = this.queryService.queryByReq((SemanticQueryReq)querySqlReq, user);
                    DataDownload dataDownload = this.buildDataDownload(queryResult, queryStructReq, batchDownloadReq.isTransform());
                    WriteSheet writeSheet = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((String)("Sheet" + sheetCount)).head(dataDownload.getHeaders())).build();
                    excelWriter.write(dataDownload.getData(), writeSheet);
                }
                catch (RuntimeException e) {
                    ((ExcelWriterSheetBuilder)EasyExcel.write((File)file).sheet("Sheet1").head(this.buildErrMessageHead())).doWrite(this.buildErrMessageData(e.getMessage()));
                    return;
                }
            }
            ++sheetCount;
        }
        excelWriter.finish();
    }

    private List<List<String>> buildErrMessageHead() {
        ArrayList headers = Lists.newArrayList();
        headers.add(Lists.newArrayList((Object[])new String[]{"\u5f02\u5e38\u63d0\u793a"}));
        return headers;
    }

    private List<List<String>> buildErrMessageData(String errMsg) {
        ArrayList data = Lists.newArrayList();
        data.add(Lists.newArrayList((Object[])new String[]{errMsg}));
        return data;
    }

    private List<List<String>> buildHeader(SemanticQueryResp semanticQueryResp) {
        ArrayList header = Lists.newArrayList();
        for (QueryColumn column : semanticQueryResp.getColumns()) {
            header.add(Lists.newArrayList((Object[])new String[]{column.getName()}));
        }
        return header;
    }

    private List<List<String>> buildHeader(List<QueryColumn> queryColumns, List<String> dateList) {
        ArrayList headers = Lists.newArrayList();
        for (QueryColumn queryColumn : queryColumns) {
            if (SemanticType.DATE.name().equals(queryColumn.getShowType())) continue;
            headers.add(Lists.newArrayList((Object[])new String[]{queryColumn.getName()}));
        }
        for (String date : dateList) {
            headers.add(Lists.newArrayList((Object[])new String[]{date}));
        }
        headers.add(Lists.newArrayList((Object[])new String[]{internMetricCol}));
        return headers;
    }

    private List<List<String>> buildData(SemanticQueryResp semanticQueryResp) {
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        for (Map row : semanticQueryResp.getResultList()) {
            ArrayList<String> rowData = new ArrayList<String>();
            for (QueryColumn column : semanticQueryResp.getColumns()) {
                rowData.add(String.valueOf(row.get(column.getNameEn())));
            }
            data.add(rowData);
        }
        return data;
    }

    private List<List<String>> buildData(List<List<String>> headers, Map<String, String> nameMap, List<Map<String, Object>> dataTransformed, String metricName) {
        ArrayList data = Lists.newArrayList();
        for (Map<String, Object> map : dataTransformed) {
            ArrayList row = Lists.newArrayList();
            for (List<String> header : headers) {
                String head = header.get(0);
                if (internMetricCol.equals(head)) continue;
                Object object = map.getOrDefault(nameMap.getOrDefault(head, head), "");
                if (object == null) {
                    row.add("");
                    continue;
                }
                row.add(String.valueOf(object));
            }
            row.add(metricName);
            data.add(row);
        }
        return data;
    }

    private DataDownload buildDataDownload(SemanticQueryResp queryResult, QueryStructReq queryStructReq, boolean isTransform) {
        List metricColumns = queryResult.getMetricColumns();
        List dimensionColumns = queryResult.getDimensionColumns();
        if (isTransform && !CollectionUtils.isEmpty((Collection)metricColumns)) {
            QueryColumn metric = (QueryColumn)metricColumns.get(0);
            List groups = queryStructReq.getGroups();
            List dataTransformed = DataTransformUtils.transform((List)queryResult.getResultList(), (String)metric.getNameEn(), (List)groups, (DateConf)queryStructReq.getDateInfo());
            List<List<String>> headers = this.buildHeader(dimensionColumns, queryStructReq.getDateInfo().getDateList());
            List<List<String>> data = this.buildData(headers, this.getDimensionNameMap(dimensionColumns), dataTransformed, metric.getName());
            return DataDownload.builder().headers(headers).data(data).build();
        }
        List<List<String>> data = this.buildData(queryResult);
        List<List<String>> header = this.buildHeader(queryResult);
        return DataDownload.builder().data(data).headers(header).build();
    }

    private QueryStructReq buildDownloadReq(List<DimensionResp> dimensionResps, MetricResp metricResp, BatchDownloadReq batchDownloadReq) {
        DateConf dateConf = batchDownloadReq.getDateInfo();
        Set modelIds = dimensionResps.stream().map(DimensionResp::getModelId).collect(Collectors.toSet());
        modelIds.add(metricResp.getModelId());
        QueryStructReq queryStructReq = new QueryStructReq();
        queryStructReq.setGroups(dimensionResps.stream().map(SchemaItem::getBizName).collect(Collectors.toList()));
        queryStructReq.getGroups().add(0, this.getTimeDimension(dateConf));
        Aggregator aggregator = new Aggregator();
        aggregator.setColumn(metricResp.getBizName());
        queryStructReq.setAggregators((List)Lists.newArrayList((Object[])new Aggregator[]{aggregator}));
        queryStructReq.setDateInfo(dateConf);
        queryStructReq.setModelIds(modelIds);
        queryStructReq.setLimit(Long.valueOf(10000L));
        return queryStructReq;
    }

    private String getTimeDimension(DateConf dateConf) {
        if ("MONTH".equals(dateConf.getPeriod())) {
            return TimeDimensionEnum.MONTH.getName();
        }
        if ("WEEK".equals(dateConf.getPeriod())) {
            return TimeDimensionEnum.WEEK.getName();
        }
        return TimeDimensionEnum.DAY.getName();
    }

    private Map<String, List<MetricResp>> getMetricMap(List<MetricResp> metricResps) {
        for (MetricResp metricResp : metricResps) {
            List<DrillDownDimension> drillDownDimensions = this.metricService.getDrillDownDimension(metricResp.getId());
            RelateDimension relateDimension = RelateDimension.builder().drillDownDimensions(drillDownDimensions).build();
            metricResp.setRelateDimension(relateDimension);
        }
        return metricResps.stream().collect(Collectors.groupingBy(MetricResp::getRelaDimensionIdKey));
    }

    private Map<String, String> getDimensionNameMap(List<QueryColumn> queryColumns) {
        return queryColumns.stream().collect(Collectors.toMap(QueryColumn::getName, QueryColumn::getNameEn));
    }

    private List<DimensionResp> getMetricRelaDimensions(MetricResp metricResp, Map<Long, DimensionResp> dimensionRespMap) {
        if (metricResp.getRelateDimension() == null || CollectionUtils.isEmpty((Collection)metricResp.getRelateDimension().getDrillDownDimensions())) {
            return Lists.newArrayList();
        }
        return metricResp.getRelateDimension().getDrillDownDimensions().stream().map(drillDownDimension -> (DimensionResp)dimensionRespMap.get(drillDownDimension.getDimensionId())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private void downloadFile(HttpServletResponse response, File file, String filename) {
        try {
            byte[] buffer = this.readFileToByteArray(file);
            response.reset();
            response.setCharacterEncoding("UTF-8");
            response.addHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(filename, "UTF-8"));
            response.addHeader("Content-Length", "" + file.length());
            try (BufferedOutputStream outputStream = new BufferedOutputStream((OutputStream)response.getOutputStream());){
                response.setContentType("application/octet-stream");
                ((OutputStream)outputStream).write(buffer);
                ((OutputStream)outputStream).flush();
            }
        }
        catch (Exception e) {
            log.error("failed to download file", (Throwable)e);
        }
    }

    private byte[] readFileToByteArray(File file) throws IOException {
        try (BufferedInputStream fis = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
            byte[] buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            byte[] byArray = buffer;
            return byArray;
        }
    }
}

