/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.web.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.common.jsqlparser.SqlSelectFunctionHelper;
import com.tencent.supersonic.common.pojo.Aggregator;
import com.tencent.supersonic.common.pojo.DataEvent;
import com.tencent.supersonic.common.pojo.DataItem;
import com.tencent.supersonic.common.pojo.Filter;
import com.tencent.supersonic.common.pojo.enums.AuthType;
import com.tencent.supersonic.common.pojo.enums.EventType;
import com.tencent.supersonic.common.pojo.enums.StatusEnum;
import com.tencent.supersonic.common.pojo.enums.TypeEnums;
import com.tencent.supersonic.common.util.BeanMapper;
import com.tencent.supersonic.headless.api.pojo.DrillDownDimension;
import com.tencent.supersonic.headless.api.pojo.Measure;
import com.tencent.supersonic.headless.api.pojo.MeasureParam;
import com.tencent.supersonic.headless.api.pojo.MetricParam;
import com.tencent.supersonic.headless.api.pojo.MetricQueryDefaultConfig;
import com.tencent.supersonic.headless.api.pojo.SchemaElementMatch;
import com.tencent.supersonic.headless.api.pojo.SchemaElementType;
import com.tencent.supersonic.headless.api.pojo.SchemaItem;
import com.tencent.supersonic.headless.api.pojo.enums.MapModeEnum;
import com.tencent.supersonic.headless.api.pojo.enums.MetricDefineType;
import com.tencent.supersonic.headless.api.pojo.enums.TagDefineType;
import com.tencent.supersonic.headless.api.pojo.request.MetaBatchReq;
import com.tencent.supersonic.headless.api.pojo.request.MetricBaseReq;
import com.tencent.supersonic.headless.api.pojo.request.MetricReq;
import com.tencent.supersonic.headless.api.pojo.request.PageMetricReq;
import com.tencent.supersonic.headless.api.pojo.request.QueryMapReq;
import com.tencent.supersonic.headless.api.pojo.request.QueryMetricReq;
import com.tencent.supersonic.headless.api.pojo.request.QueryStructReq;
import com.tencent.supersonic.headless.api.pojo.response.DataSetMapInfo;
import com.tencent.supersonic.headless.api.pojo.response.DataSetResp;
import com.tencent.supersonic.headless.api.pojo.response.DimensionResp;
import com.tencent.supersonic.headless.api.pojo.response.MapInfoResp;
import com.tencent.supersonic.headless.api.pojo.response.MetricResp;
import com.tencent.supersonic.headless.api.pojo.response.ModelResp;
import com.tencent.supersonic.headless.api.pojo.response.TagItem;
import com.tencent.supersonic.headless.server.facade.service.ChatLayerService;
import com.tencent.supersonic.headless.server.persistence.dataobject.CollectDO;
import com.tencent.supersonic.headless.server.persistence.dataobject.MetricDO;
import com.tencent.supersonic.headless.server.persistence.dataobject.MetricQueryDefaultConfigDO;
import com.tencent.supersonic.headless.server.persistence.dataobject.TagDO;
import com.tencent.supersonic.headless.server.persistence.mapper.MetricDOMapper;
import com.tencent.supersonic.headless.server.persistence.repository.MetricRepository;
import com.tencent.supersonic.headless.server.pojo.DimensionsFilter;
import com.tencent.supersonic.headless.server.pojo.MetaFilter;
import com.tencent.supersonic.headless.server.pojo.MetricFilter;
import com.tencent.supersonic.headless.server.pojo.MetricsFilter;
import com.tencent.supersonic.headless.server.pojo.ModelCluster;
import com.tencent.supersonic.headless.server.pojo.ModelFilter;
import com.tencent.supersonic.headless.server.pojo.TagFilter;
import com.tencent.supersonic.headless.server.utils.AliasGenerateHelper;
import com.tencent.supersonic.headless.server.utils.MetricCheckUtils;
import com.tencent.supersonic.headless.server.utils.MetricConverter;
import com.tencent.supersonic.headless.server.utils.ModelClusterBuilder;
import com.tencent.supersonic.headless.server.web.service.CollectService;
import com.tencent.supersonic.headless.server.web.service.DataSetService;
import com.tencent.supersonic.headless.server.web.service.DimensionService;
import com.tencent.supersonic.headless.server.web.service.MetricService;
import com.tencent.supersonic.headless.server.web.service.ModelService;
import com.tencent.supersonic.headless.server.web.service.TagMetaService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MetricServiceImpl
extends ServiceImpl<MetricDOMapper, MetricDO>
implements MetricService {
    private static final Logger log = LoggerFactory.getLogger(MetricServiceImpl.class);
    private MetricRepository metricRepository;
    private ModelService modelService;
    private DimensionService dimensionService;
    private AliasGenerateHelper aliasGenerateHelper;
    private CollectService collectService;
    private DataSetService dataSetService;
    private ApplicationEventPublisher eventPublisher;
    private TagMetaService tagMetaService;
    private ChatLayerService chatLayerService;

    public MetricServiceImpl(MetricRepository metricRepository, ModelService modelService, AliasGenerateHelper aliasGenerateHelper, CollectService collectService, DataSetService dataSetService, ApplicationEventPublisher eventPublisher, DimensionService dimensionService, TagMetaService tagMetaService, @Lazy ChatLayerService chatLayerService) {
        this.metricRepository = metricRepository;
        this.modelService = modelService;
        this.aliasGenerateHelper = aliasGenerateHelper;
        this.eventPublisher = eventPublisher;
        this.collectService = collectService;
        this.dataSetService = dataSetService;
        this.dimensionService = dimensionService;
        this.tagMetaService = tagMetaService;
        this.chatLayerService = chatLayerService;
    }

    @Override
    public MetricResp createMetric(MetricReq metricReq, User user) {
        this.checkExist(Lists.newArrayList((Object[])new MetricBaseReq[]{metricReq}));
        MetricCheckUtils.checkParam(metricReq);
        metricReq.createdBy(user.getName());
        MetricDO metricDO = MetricConverter.convert2MetricDO(metricReq);
        this.metricRepository.createMetric(metricDO);
        this.sendEventBatch(Lists.newArrayList((Object[])new MetricDO[]{metricDO}), EventType.ADD);
        return MetricConverter.convert2MetricResp(metricDO);
    }

    @Override
    public void createMetricBatch(List<MetricReq> metricReqs, User user) {
        if (CollectionUtils.isEmpty(metricReqs)) {
            return;
        }
        Long modelId = metricReqs.get(0).getModelId();
        List<MetricResp> metricResps = this.getMetrics(new MetaFilter(Lists.newArrayList((Object[])new Long[]{modelId})));
        Map<String, MetricResp> bizNameMap = metricResps.stream().collect(Collectors.toMap(SchemaItem::getBizName, a -> a, (k1, k2) -> k1));
        Map<String, MetricResp> nameMap = metricResps.stream().collect(Collectors.toMap(SchemaItem::getName, a -> a, (k1, k2) -> k1));
        List metricToInsert = metricReqs.stream().filter(metric -> !bizNameMap.containsKey(metric.getBizName()) && !nameMap.containsKey(metric.getName())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(metricToInsert)) {
            return;
        }
        List<MetricDO> metricDOS = metricToInsert.stream().peek(metric -> metric.createdBy(user.getName())).map(MetricConverter::convert2MetricDO).collect(Collectors.toList());
        this.metricRepository.createMetricBatch(metricDOS);
        this.sendEventBatch(metricDOS, EventType.ADD);
    }

    @Override
    public MetricResp updateMetric(MetricReq metricReq, User user) {
        MetricCheckUtils.checkParam(metricReq);
        this.checkExist(Lists.newArrayList((Object[])new MetricBaseReq[]{metricReq}));
        metricReq.updatedBy(user.getName());
        MetricDO metricDO = this.metricRepository.getMetricById(metricReq.getId());
        String oldName = metricDO.getName();
        MetricConverter.convert(metricDO, metricReq);
        this.metricRepository.updateMetric(metricDO);
        if (!oldName.equals(metricDO.getName())) {
            DataItem dataItem = this.getDataItem(metricDO);
            dataItem.setName(oldName);
            dataItem.setNewName(metricDO.getName());
            this.sendEvent(dataItem, EventType.UPDATE);
        }
        return MetricConverter.convert2MetricResp(metricDO);
    }

    @Override
    public void batchUpdateStatus(MetaBatchReq metaBatchReq, User user) {
        if (CollectionUtils.isEmpty((Collection)metaBatchReq.getIds())) {
            return;
        }
        List<MetricDO> metricDOS = this.getMetrics(metaBatchReq.getIds());
        if (CollectionUtils.isEmpty(metricDOS)) {
            return;
        }
        metricDOS = metricDOS.stream().peek(metricDO -> {
            metricDO.setStatus(metaBatchReq.getStatus());
            metricDO.setUpdatedAt(new Date());
            metricDO.setUpdatedBy(user.getName());
        }).collect(Collectors.toList());
        this.metricRepository.batchUpdateStatus(metricDOS);
        if (StatusEnum.OFFLINE.getCode().equals(metaBatchReq.getStatus()) || StatusEnum.DELETED.getCode().equals(metaBatchReq.getStatus())) {
            this.sendEventBatch(metricDOS, EventType.DELETE);
        } else if (StatusEnum.ONLINE.getCode().equals(metaBatchReq.getStatus())) {
            this.sendEventBatch(metricDOS, EventType.ADD);
        }
    }

    @Override
    public void batchPublish(List<Long> metricIds, User user) {
        List<MetricDO> metrics = this.getMetrics(metricIds);
        for (MetricDO metricDO : metrics) {
            metricDO.setUpdatedAt(new Date());
            metricDO.setUpdatedBy(user.getName());
        }
        this.metricRepository.batchPublish(metrics);
    }

    @Override
    public void batchUnPublish(List<Long> metricIds, User user) {
        List<MetricDO> metrics = this.getMetrics(metricIds);
        for (MetricDO metricDO : metrics) {
            metricDO.setUpdatedAt(new Date());
            metricDO.setUpdatedBy(user.getName());
        }
        this.metricRepository.batchUnPublish(metrics);
    }

    @Override
    public void batchUpdateClassifications(MetaBatchReq metaBatchReq, User user) {
        List<MetricDO> metrics = this.getMetrics(metaBatchReq.getIds());
        for (MetricDO metricDO : metrics) {
            metricDO.setUpdatedAt(new Date());
            metricDO.setUpdatedBy(user.getName());
            this.fillClassifications(metaBatchReq, metricDO);
        }
        this.metricRepository.updateClassificationsBatch(metrics);
    }

    private void fillClassifications(MetaBatchReq metaBatchReq, MetricDO metricDO) {
        String classificationStr = metricDO.getClassifications();
        HashSet<Object> classificationsList = StringUtils.isBlank((CharSequence)classificationStr) ? new HashSet() : new HashSet<String>(Arrays.asList(classificationStr.split(",")));
        if (EventType.ADD.equals((Object)metaBatchReq.getType())) {
            classificationsList.addAll(metaBatchReq.getClassifications());
        }
        if (EventType.DELETE.equals((Object)metaBatchReq.getType())) {
            classificationsList.removeAll(metaBatchReq.getClassifications());
        }
        String classifications = "";
        if (!CollectionUtils.isEmpty(classificationsList)) {
            classifications = StringUtils.join(classificationsList, (String)",");
        }
        metricDO.setClassifications(classifications);
    }

    @Override
    public void batchUpdateSensitiveLevel(MetaBatchReq metaBatchReq, User user) {
        List<MetricDO> metrics = this.getMetrics(metaBatchReq.getIds());
        for (MetricDO metricDO : metrics) {
            metricDO.setUpdatedAt(new Date());
            metricDO.setUpdatedBy(user.getName());
            metricDO.setSensitiveLevel(metaBatchReq.getSensitiveLevel());
        }
        this.updateBatchById(metrics);
    }

    @Override
    public void deleteMetric(Long id, User user) {
        MetricDO metricDO = this.metricRepository.getMetricById(id);
        if (metricDO == null) {
            throw new RuntimeException(String.format("the metric %s not exist", id));
        }
        metricDO.setStatus(StatusEnum.DELETED.getCode());
        metricDO.setUpdatedAt(new Date());
        metricDO.setUpdatedBy(user.getName());
        this.metricRepository.updateMetric(metricDO);
        this.sendEventBatch(Lists.newArrayList((Object[])new MetricDO[]{metricDO}), EventType.DELETE);
    }

    @Override
    public PageInfo<MetricResp> queryMetricMarket(PageMetricReq pageMetricReq, User user) {
        PageInfo<MetricResp> metricRespPageInfo = this.queryMetric(pageMetricReq, user);
        if (metricRespPageInfo.hasContent() || StringUtils.isBlank((CharSequence)pageMetricReq.getKey())) {
            return metricRespPageInfo;
        }
        QueryMapReq queryMapReq = new QueryMapReq();
        queryMapReq.setQueryText(pageMetricReq.getKey());
        queryMapReq.setUser(user);
        queryMapReq.setMapModeEnum(MapModeEnum.LOOSE);
        MapInfoResp mapMeta = this.chatLayerService.map(queryMapReq);
        Map dataSetMapInfoMap = mapMeta.getDataSetMapInfo();
        if (CollectionUtils.isEmpty((Map)dataSetMapInfoMap)) {
            return metricRespPageInfo;
        }
        Map<Long, Double> result = dataSetMapInfoMap.values().stream().map(DataSetMapInfo::getMapFields).filter(Objects::nonNull).flatMap(Collection::stream).filter(schemaElementMatch -> SchemaElementType.METRIC.equals((Object)schemaElementMatch.getElement().getType())).collect(Collectors.toMap(schemaElementMatch -> schemaElementMatch.getElement().getId(), SchemaElementMatch::getSimilarity, (existingValue, newValue) -> existingValue));
        ArrayList<Long> metricIds = new ArrayList<Long>(result.keySet());
        if (CollectionUtils.isEmpty(result.keySet())) {
            return metricRespPageInfo;
        }
        pageMetricReq.setIds(metricIds);
        pageMetricReq.setKey("");
        PageInfo<MetricResp> metricPage = this.queryMetric(pageMetricReq, user);
        for (MetricResp metricResp : metricPage.getList()) {
            metricResp.setSimilarity(result.get(metricResp.getId()).doubleValue());
        }
        metricPage.getList().sort(Comparator.comparingDouble(MetricResp::getSimilarity).reversed());
        return metricPage;
    }

    @Override
    public PageInfo<MetricResp> queryMetric(PageMetricReq pageMetricReq, User user) {
        MetricFilter metricFilter = new MetricFilter();
        metricFilter.setUserName(user.getName());
        BeanUtils.copyProperties((Object)pageMetricReq, (Object)metricFilter);
        if (!CollectionUtils.isEmpty((Collection)pageMetricReq.getDomainIds())) {
            List<ModelResp> modelResps = this.modelService.getAllModelByDomainIds(pageMetricReq.getDomainIds());
            List modelIds = modelResps.stream().map(SchemaItem::getId).collect(Collectors.toList());
            pageMetricReq.getModelIds().addAll(modelIds);
        }
        metricFilter.setModelIds(pageMetricReq.getModelIds());
        List<Long> collectIds = this.getCollectIds(pageMetricReq, user);
        List<Long> idsToFilter = this.getIdsToFilter(pageMetricReq, collectIds);
        metricFilter.setIds(idsToFilter);
        PageInfo metricDOPageInfo = PageHelper.startPage((int)pageMetricReq.getCurrent(), (int)pageMetricReq.getPageSize()).doSelectPageInfo(() -> this.queryMetric(metricFilter));
        PageInfo pageInfo = new PageInfo();
        BeanUtils.copyProperties((Object)metricDOPageInfo, (Object)pageInfo);
        List<MetricResp> metricResps = this.convertList(metricDOPageInfo.getList(), collectIds);
        this.fillAdminRes(metricResps, user);
        this.fillTagInfo(metricResps);
        pageInfo.setList(metricResps);
        return pageInfo;
    }

    protected List<MetricDO> queryMetric(MetricFilter metricFilter) {
        return this.metricRepository.getMetric(metricFilter);
    }

    private List<MetricDO> getMetrics(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        MetricFilter metricFilter = new MetricFilter();
        metricFilter.setIds(ids);
        return this.metricRepository.getMetric(metricFilter);
    }

    @Override
    public List<MetricResp> getMetrics(MetaFilter metaFilter) {
        MetricFilter metricFilter = new MetricFilter();
        BeanUtils.copyProperties((Object)metaFilter, (Object)metricFilter);
        List<MetricResp> metricResps = this.convertList(this.queryMetric(metricFilter));
        List<Long> metricIds = metricResps.stream().map(metricResp -> metricResp.getId()).collect(Collectors.toList());
        List<TagItem> tagItems = this.tagMetaService.getTagItems(metricIds, TagDefineType.METRIC);
        Map<Long, TagItem> itemIdToTagItem = tagItems.stream().collect(Collectors.toMap(tag -> tag.getItemId(), tag -> tag, (newTag, oldTag) -> newTag));
        if (Objects.nonNull(itemIdToTagItem)) {
            metricResps.stream().forEach(metricResp -> {
                Long metricRespId = metricResp.getId();
                if (itemIdToTagItem.containsKey(metricRespId)) {
                    metricResp.setIsTag(((TagItem)itemIdToTagItem.get(metricRespId)).getIsTag());
                }
            });
        }
        if (!CollectionUtils.isEmpty(metaFilter.getFieldsDepend())) {
            return this.filterByField(metricResps, metaFilter.getFieldsDepend());
        }
        if (metaFilter.getDataSetId() != null) {
            DataSetResp dataSetResp = this.dataSetService.getDataSet(metaFilter.getDataSetId());
            return MetricConverter.filterByDataSet(metricResps, dataSetResp);
        }
        return metricResps;
    }

    private List<Long> getCollectIds(PageMetricReq pageMetricReq, User user) {
        List<CollectDO> collectList = this.collectService.getCollectionList(user.getName(), TypeEnums.METRIC);
        List<Long> collectIds = collectList.stream().map(CollectDO::getCollectId).collect(Collectors.toList());
        if (pageMetricReq.isHasCollect()) {
            if (CollectionUtils.isEmpty(collectIds)) {
                return Lists.newArrayList((Object[])new Long[]{-1L});
            }
            return collectIds;
        }
        return Lists.newArrayList();
    }

    private List<Long> getIdsToFilter(PageMetricReq pageMetricReq, List<Long> collectIds) {
        if (CollectionUtils.isEmpty((Collection)pageMetricReq.getIds())) {
            return collectIds;
        }
        if (CollectionUtils.isEmpty(collectIds)) {
            return pageMetricReq.getIds();
        }
        ArrayList<Long> idsToFilter = new ArrayList<Long>(collectIds);
        idsToFilter.retainAll(pageMetricReq.getIds());
        idsToFilter.add(-1L);
        return idsToFilter;
    }

    private void fillTagInfo(List<MetricResp> metricRespList) {
        if (CollectionUtils.isEmpty(metricRespList)) {
            return;
        }
        TagFilter tagFilter = new TagFilter();
        tagFilter.setTagDefineType(TagDefineType.METRIC);
        List<Long> metricIds = metricRespList.stream().map(metric -> metric.getId()).collect(Collectors.toList());
        tagFilter.setItemIds(metricIds);
        Map<Long, TagDO> keyAndTagMap = this.tagMetaService.getTagDOList(tagFilter).stream().collect(Collectors.toMap(tag -> tag.getItemId(), tag -> tag, (newTag, oldTag) -> newTag));
        if (Objects.nonNull(keyAndTagMap)) {
            metricRespList.stream().forEach(metric -> {
                if (keyAndTagMap.containsKey(metric.getId())) {
                    metric.setIsTag(1);
                } else {
                    metric.setIsTag(0);
                }
            });
        }
    }

    private List<MetricResp> filterByField(List<MetricResp> metricResps, List<String> fields) {
        HashSet metricRespFiltered = Sets.newHashSet();
        for (MetricResp metricResp : metricResps) {
            this.filterByField(metricResps, metricResp, fields, metricRespFiltered);
        }
        return new ArrayList<MetricResp>(metricRespFiltered);
    }

    private boolean filterByField(List<MetricResp> metricResps, MetricResp metricResp, List<String> fields, Set<MetricResp> metricRespFiltered) {
        if (MetricDefineType.METRIC.equals((Object)metricResp.getMetricDefineType())) {
            List ids = metricResp.getMetricDefineByMetricParams().getMetrics().stream().map(MetricParam::getId).collect(Collectors.toList());
            List metricById = metricResps.stream().filter(metric -> ids.contains(metric.getId())).collect(Collectors.toList());
            for (MetricResp metric2 : metricById) {
                if (!this.filterByField(metricResps, metric2, fields, metricRespFiltered)) continue;
                metricRespFiltered.add(metricResp);
                return true;
            }
        } else if (MetricDefineType.FIELD.equals((Object)metricResp.getMetricDefineType())) {
            if (fields.stream().anyMatch(field -> metricResp.getExpr().contains((CharSequence)field))) {
                metricRespFiltered.add(metricResp);
                return true;
            }
        } else if (MetricDefineType.MEASURE.equals((Object)metricResp.getMetricDefineType())) {
            List measures = metricResp.getMetricDefineByMeasureParams().getMeasures();
            List fieldNameDepended = measures.stream().map(MeasureParam::getBizName).map(name -> name.replaceFirst(metricResp.getModelBizName() + "_", "")).collect(Collectors.toList());
            if (fields.stream().anyMatch(fieldNameDepended::contains)) {
                metricRespFiltered.add(metricResp);
                return true;
            }
        }
        return false;
    }

    @Override
    public List<MetricResp> getMetricsToCreateNewMetric(Long modelId) {
        MetricFilter metricFilter = new MetricFilter();
        metricFilter.setModelIds(Lists.newArrayList((Object[])new Long[]{modelId}));
        List<MetricResp> metricResps = this.getMetrics(metricFilter);
        return metricResps.stream().filter(metricResp -> MetricDefineType.FIELD.equals((Object)metricResp.getMetricDefineType()) || MetricDefineType.MEASURE.equals((Object)metricResp.getMetricDefineType())).collect(Collectors.toList());
    }

    private void fillAdminRes(List<MetricResp> metricResps, User user) {
        List<ModelResp> modelResps = this.modelService.getModelListWithAuth(user, null, AuthType.ADMIN);
        if (CollectionUtils.isEmpty(modelResps)) {
            return;
        }
        Set modelIdSet = modelResps.stream().map(SchemaItem::getId).collect(Collectors.toSet());
        for (MetricResp metricResp : metricResps) {
            if (!modelIdSet.contains(metricResp.getModelId())) continue;
            metricResp.setHasAdminRes(true);
        }
    }

    @Override
    @Deprecated
    public MetricResp getMetric(Long modelId, String bizName) {
        MetricFilter metricFilter = new MetricFilter();
        metricFilter.setBizName(bizName);
        metricFilter.setModelIds(Lists.newArrayList((Object[])new Long[]{modelId}));
        List<MetricResp> metricResps = this.getMetrics(metricFilter);
        MetricResp metricResp = null;
        if (CollectionUtils.isEmpty(metricResps)) {
            return metricResp;
        }
        return metricResps.get(0);
    }

    @Override
    public MetricResp getMetric(Long id, User user) {
        MetricDO metricDO = this.metricRepository.getMetricById(id);
        if (metricDO == null) {
            return null;
        }
        ModelFilter modelFilter = new ModelFilter(false, Lists.newArrayList((Object[])new Long[]{metricDO.getModelId()}));
        Map<Long, ModelResp> modelMap = this.modelService.getModelMap(modelFilter);
        List<CollectDO> collectList = this.collectService.getCollectionList(user.getName(), TypeEnums.METRIC);
        List<Long> collect = collectList.stream().map(CollectDO::getCollectId).collect(Collectors.toList());
        MetricResp metricResp = MetricConverter.convert2MetricResp(metricDO, modelMap, collect);
        this.fillAdminRes(Lists.newArrayList((Object[])new MetricResp[]{metricResp}), user);
        return metricResp;
    }

    @Override
    public MetricResp getMetric(Long id) {
        MetricDO metricDO = this.metricRepository.getMetricById(id);
        if (metricDO == null) {
            return null;
        }
        return MetricConverter.convert2MetricResp(metricDO, new HashMap<Long, ModelResp>(), Lists.newArrayList());
    }

    @Override
    public List<String> mockAlias(MetricBaseReq metricReq, String mockType, User user) {
        String mockAlias = this.aliasGenerateHelper.generateAlias(mockType, metricReq.getName(), metricReq.getBizName(), "", metricReq.getDescription(), !"".equals(metricReq.getDataFormatType()));
        return (List)JSONObject.parseObject((String)mockAlias, (TypeReference)new TypeReference<List<String>>(){}, (Feature[])new Feature[0]);
    }

    @Override
    public Set<String> getMetricTags() {
        List<MetricResp> metricResps = this.getMetrics(new MetaFilter());
        if (CollectionUtils.isEmpty(metricResps)) {
            return new HashSet<String>();
        }
        return metricResps.stream().flatMap(metricResp -> metricResp.getClassifications().stream()).collect(Collectors.toSet());
    }

    @Override
    public List<DrillDownDimension> getDrillDownDimension(Long metricId) {
        ModelResp modelResp;
        ArrayList drillDownDimensions = Lists.newArrayList();
        MetricResp metricResp = this.getMetric(metricId);
        if (metricResp == null) {
            return drillDownDimensions;
        }
        if (metricResp.getRelateDimension() != null && !CollectionUtils.isEmpty((Collection)metricResp.getRelateDimension().getDrillDownDimensions())) {
            for (DrillDownDimension drillDownDimension : metricResp.getRelateDimension().getDrillDownDimensions()) {
                if (drillDownDimension.isInheritedFromModel() && !drillDownDimension.isNecessary()) continue;
                drillDownDimensions.add(drillDownDimension);
            }
        }
        if ((modelResp = this.modelService.getModel(metricResp.getModelId())).getDrillDownDimensions() == null) {
            return drillDownDimensions;
        }
        for (DrillDownDimension drillDownDimension : modelResp.getDrillDownDimensions()) {
            if (drillDownDimensions.stream().map(DrillDownDimension::getDimensionId).collect(Collectors.toList()).contains(drillDownDimension.getDimensionId())) continue;
            drillDownDimension.setInheritedFromModel(true);
            drillDownDimensions.add(drillDownDimension);
        }
        return drillDownDimensions;
    }

    @Override
    public void saveMetricQueryDefaultConfig(MetricQueryDefaultConfig defaultConfig, User user) {
        MetricQueryDefaultConfigDO defaultConfigDO = this.metricRepository.getDefaultQueryConfig(defaultConfig.getMetricId(), user.getName());
        if (defaultConfigDO == null) {
            defaultConfigDO = new MetricQueryDefaultConfigDO();
            defaultConfig.createdBy(user.getName());
            BeanMapper.mapper((Object)defaultConfig, (Object)defaultConfigDO);
            this.metricRepository.saveDefaultQueryConfig(defaultConfigDO);
        } else {
            defaultConfig.setId(defaultConfigDO.getId());
            defaultConfig.updatedBy(user.getName());
            BeanMapper.mapper((Object)defaultConfig, (Object)defaultConfigDO);
            this.metricRepository.updateDefaultQueryConfig(defaultConfigDO);
        }
    }

    @Override
    public MetricQueryDefaultConfig getMetricQueryDefaultConfig(Long metricId, User user) {
        MetricQueryDefaultConfigDO metricQueryDefaultConfigDO = this.metricRepository.getDefaultQueryConfig(metricId, user.getName());
        MetricQueryDefaultConfig metricQueryDefaultConfig = new MetricQueryDefaultConfig();
        BeanMapper.mapper((Object)metricQueryDefaultConfigDO, (Object)metricQueryDefaultConfig);
        return metricQueryDefaultConfig;
    }

    private void checkExist(List<MetricBaseReq> metricReqs) {
        Long modelId = metricReqs.get(0).getModelId();
        MetaFilter metaFilter = new MetaFilter();
        metaFilter.setModelIds(Lists.newArrayList((Object[])new Long[]{modelId}));
        List<MetricResp> metricResps = this.getMetrics(metaFilter);
        Map<String, MetricResp> bizNameMap = metricResps.stream().collect(Collectors.toMap(SchemaItem::getBizName, a -> a, (k1, k2) -> k1));
        Map<String, MetricResp> nameMap = metricResps.stream().collect(Collectors.toMap(SchemaItem::getName, a -> a, (k1, k2) -> k1));
        for (MetricBaseReq metricReq : metricReqs) {
            MetricResp metricResp;
            if (bizNameMap.containsKey(metricReq.getBizName()) && !(metricResp = bizNameMap.get(metricReq.getBizName())).getId().equals(metricReq.getId())) {
                throw new RuntimeException(String.format("\u8be5\u6a21\u578b\u4e0b\u5b58\u5728\u76f8\u540c\u7684\u6307\u6807\u5b57\u6bb5\u540d:%s \u521b\u5efa\u4eba:%s", metricReq.getBizName(), metricResp.getCreatedBy()));
            }
            if (!nameMap.containsKey(metricReq.getName()) || (metricResp = nameMap.get(metricReq.getName())).getId().equals(metricReq.getId())) continue;
            throw new RuntimeException(String.format("\u8be5\u6a21\u578b\u4e0b\u5b58\u5728\u76f8\u540c\u7684\u6307\u6807\u540d:%s \u521b\u5efa\u4eba:%s", metricReq.getName(), metricResp.getCreatedBy()));
        }
    }

    private List<MetricResp> convertList(List<MetricDO> metricDOS) {
        return this.convertList(metricDOS, Lists.newArrayList());
    }

    private List<MetricResp> convertList(List<MetricDO> metricDOS, List<Long> collect) {
        List<Object> metricResps = Lists.newArrayList();
        List<Long> modelIds = metricDOS.stream().map(MetricDO::getModelId).collect(Collectors.toList());
        ModelFilter modelFilter = new ModelFilter(false, modelIds);
        Map<Long, ModelResp> modelMap = this.modelService.getModelMap(modelFilter);
        if (!CollectionUtils.isEmpty(metricDOS)) {
            metricResps = metricDOS.stream().map(metricDO -> MetricConverter.convert2MetricResp(metricDO, modelMap, collect)).collect(Collectors.toList());
        }
        return metricResps;
    }

    @Override
    public void sendMetricEventBatch(List<Long> modelIds, EventType eventType) {
        MetricFilter metricFilter = new MetricFilter();
        metricFilter.setModelIds(modelIds);
        List<MetricDO> metricDOS = this.queryMetric(metricFilter);
        this.sendEventBatch(metricDOS, eventType);
    }

    @Override
    public List<MetricResp> queryMetrics(MetricsFilter metricsFilter) {
        List<MetricDO> metricDOS = this.metricRepository.getMetrics(metricsFilter);
        return this.convertList(metricDOS, new ArrayList<Long>());
    }

    @Override
    public DataEvent getDataEvent() {
        MetricsFilter metricsFilter = new MetricsFilter();
        List<MetricDO> metricDOS = this.metricRepository.getMetrics(metricsFilter);
        return this.getDataEvent(metricDOS, EventType.ADD);
    }

    private DataEvent getDataEvent(List<MetricDO> metricDOS, EventType eventType) {
        List dataItems = metricDOS.stream().map(this::getDataItem).collect(Collectors.toList());
        return new DataEvent((Object)this, dataItems, eventType);
    }

    private void sendEventBatch(List<MetricDO> metricDOS, EventType eventType) {
        DataEvent dataEvent = this.getDataEvent(metricDOS, eventType);
        this.eventPublisher.publishEvent((ApplicationEvent)dataEvent);
    }

    private void sendEvent(DataItem dataItem, EventType eventType) {
        this.eventPublisher.publishEvent((ApplicationEvent)new DataEvent((Object)this, (List)Lists.newArrayList((Object[])new DataItem[]{dataItem}), eventType));
    }

    private DataItem getDataItem(MetricDO metricDO) {
        MetricResp metricResp = MetricConverter.convert2MetricResp(metricDO, new HashMap<Long, ModelResp>(), Lists.newArrayList());
        this.fillDefaultAgg(metricResp);
        return DataItem.builder().id(metricDO.getId() + "_").name(metricDO.getName()).bizName(metricDO.getBizName()).modelId(metricDO.getModelId() + "_").type(TypeEnums.METRIC).defaultAgg(metricResp.getDefaultAgg()).build();
    }

    @Override
    public void batchFillMetricDefaultAgg(List<MetricResp> metricResps, List<ModelResp> modelResps) {
        Map<Long, ModelResp> modelRespMap = modelResps.stream().collect(Collectors.toMap(SchemaItem::getId, m -> m));
        for (MetricResp metricResp : metricResps) {
            this.fillDefaultAgg(metricResp, modelRespMap.get(metricResp.getModelId()));
        }
    }

    private void fillDefaultAgg(MetricResp metricResp) {
        if (MetricDefineType.MEASURE.equals((Object)metricResp.getMetricDefineType())) {
            Long modelId = metricResp.getModelId();
            ModelResp modelResp = this.modelService.getModel(modelId);
            this.fillDefaultAgg(metricResp, modelResp);
        }
    }

    private void fillDefaultAgg(MetricResp metricResp, ModelResp modelResp) {
        metricResp.setDefaultAgg(this.getDefaultAgg(metricResp, modelResp));
    }

    private String getDefaultAgg(MetricResp metricResp, ModelResp modelResp) {
        if (modelResp == null || Objects.nonNull(metricResp.getDefaultAgg()) && !metricResp.getDefaultAgg().isEmpty()) {
            return metricResp.getDefaultAgg();
        }
        if (MetricDefineType.FIELD.equals((Object)metricResp.getMetricDefineType())) {
            return SqlSelectFunctionHelper.getFirstAggregateFunctions((String)metricResp.getExpr());
        }
        if (MetricDefineType.METRIC.equals((Object)metricResp.getMetricDefineType()) && !CollectionUtils.isEmpty((Collection)metricResp.getMetricDefineByMetricParams().getMetrics())) {
            MetricParam metricParam = (MetricParam)metricResp.getMetricDefineByMetricParams().getMetrics().get(0);
            MetricResp firstMetricResp = this.getMetric(modelResp.getDomainId(), metricParam.getBizName());
            if (Objects.nonNull(firstMetricResp)) {
                return this.getDefaultAgg(firstMetricResp, modelResp);
            }
            return "";
        }
        List measures = modelResp.getModelDetail().getMeasures();
        List measureParams = metricResp.getMetricDefineByMeasureParams().getMeasures();
        if (CollectionUtils.isEmpty((Collection)measureParams)) {
            return "";
        }
        MeasureParam firstMeasure = (MeasureParam)measureParams.get(0);
        for (Measure measure : measures) {
            if (!measure.getBizName().equalsIgnoreCase(firstMeasure.getBizName())) continue;
            return measure.getAgg();
        }
        return "";
    }

    @Override
    public QueryStructReq convert(QueryMetricReq queryMetricReq) {
        List metricBizNames;
        Set<Long> modelIdsByDomainId = this.getModelIdsByDomainId(queryMetricReq);
        List<MetricResp> metricResps = this.getMetricResps(queryMetricReq, modelIdsByDomainId);
        List<DimensionResp> dimensionResps = this.getDimensionResps(modelIdsByDomainId);
        Map<Long, DimensionResp> dimensionRespMap = dimensionResps.stream().collect(Collectors.toMap(SchemaItem::getId, d -> d));
        Set<Long> modelIds = this.getModelIds(modelIdsByDomainId, metricResps, dimensionResps);
        ModelCluster modelCluster = this.getModelCluster(metricResps, modelIds);
        if (modelCluster == null) {
            throw new IllegalArgumentException("Invalid input parameters, unable to obtain valid metrics");
        }
        List dimensionBizNames = dimensionResps.stream().filter(entry -> modelCluster.getModelIds().contains(entry.getModelId())).filter(entry -> queryMetricReq.getDimensionNames().contains(entry.getName()) || queryMetricReq.getDimensionNames().contains(entry.getBizName()) || queryMetricReq.getDimensionIds().contains(entry.getId())).map(SchemaItem::getBizName).collect(Collectors.toList());
        QueryStructReq queryStructReq = new QueryStructReq();
        if (queryMetricReq.getDateInfo().isGroupByDate()) {
            queryStructReq.getGroups().add(queryMetricReq.getDateInfo().getGroupByTimeDimension());
        }
        if (!CollectionUtils.isEmpty(dimensionBizNames)) {
            queryStructReq.getGroups().addAll(dimensionBizNames);
        }
        if (CollectionUtils.isEmpty(metricBizNames = metricResps.stream().filter(entry -> modelCluster.getModelIds().contains(entry.getModelId())).map(SchemaItem::getBizName).collect(Collectors.toList()))) {
            throw new IllegalArgumentException("Invalid input parameters, unable to obtain valid metrics");
        }
        ArrayList<Aggregator> aggregators = new ArrayList<Aggregator>();
        for (String metricBizName : metricBizNames) {
            Aggregator aggregator = new Aggregator();
            aggregator.setColumn(metricBizName);
            aggregators.add(aggregator);
        }
        queryStructReq.setAggregators(aggregators);
        queryStructReq.setLimit(queryMetricReq.getLimit());
        for (Long modelId : modelCluster.getModelIds()) {
            queryStructReq.addModelId(modelId);
        }
        List filters = queryMetricReq.getFilters();
        for (Filter filter : filters) {
            DimensionResp dimensionResp;
            if (!StringUtils.isBlank((CharSequence)filter.getBizName()) || (dimensionResp = dimensionRespMap.get(filter.getId())) == null) continue;
            filter.setBizName(dimensionResp.getBizName());
        }
        queryStructReq.setDimensionFilters(filters);
        queryStructReq.setDateInfo(queryMetricReq.getDateInfo());
        return queryStructReq;
    }

    private ModelCluster getModelCluster(List<MetricResp> metricResps, Set<Long> modelIds) {
        Map<String, ModelCluster> modelClusterMap = ModelClusterBuilder.buildModelClusters(new ArrayList<Long>(modelIds));
        HashMap<String, List> modelClusterToMatchCount = new HashMap<String, List>();
        for (ModelCluster modelCluster : modelClusterMap.values()) {
            for (MetricResp metricResp : metricResps) {
                if (!modelCluster.getModelIds().contains(metricResp.getModelId())) continue;
                modelClusterToMatchCount.computeIfAbsent(modelCluster.getKey(), k -> new ArrayList()).add(metricResp);
            }
        }
        String keyWithMaxSize = modelClusterToMatchCount.entrySet().stream().max(Comparator.comparingInt(entry -> ((List)entry.getValue()).size())).map(Map.Entry::getKey).orElse(null);
        return modelClusterMap.get(keyWithMaxSize);
    }

    private Set<Long> getModelIds(Set<Long> modelIdsByDomainId, List<MetricResp> metricResps, List<DimensionResp> dimensionResps) {
        HashSet<Long> result = new HashSet<Long>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(modelIdsByDomainId)) {
            result.addAll(modelIdsByDomainId);
            return result;
        }
        Set metricModelIds = metricResps.stream().map(entry -> entry.getModelId()).collect(Collectors.toSet());
        result.addAll(metricModelIds);
        Set dimensionModelIds = dimensionResps.stream().map(entry -> entry.getModelId()).collect(Collectors.toSet());
        result.addAll(dimensionModelIds);
        return result;
    }

    private List<DimensionResp> getDimensionResps(Set<Long> modelIds) {
        DimensionsFilter dimensionsFilter = new DimensionsFilter();
        dimensionsFilter.setModelIds(new ArrayList<Long>(modelIds));
        return this.dimensionService.queryDimensions(dimensionsFilter);
    }

    private List<MetricResp> getMetricResps(QueryMetricReq queryMetricReq, Set<Long> modelIds) {
        MetricsFilter metricsFilter = new MetricsFilter();
        BeanUtils.copyProperties((Object)queryMetricReq, (Object)metricsFilter);
        metricsFilter.setModelIds(new ArrayList<Long>(modelIds));
        return this.queryMetrics(metricsFilter);
    }

    private Set<Long> getModelIdsByDomainId(QueryMetricReq queryMetricReq) {
        List<ModelResp> modelResps = this.modelService.getAllModelByDomainIds(Collections.singletonList(queryMetricReq.getDomainId()));
        return modelResps.stream().map(SchemaItem::getId).collect(Collectors.toSet());
    }
}

