/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.web.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.common.pojo.JoinCondition;
import com.tencent.supersonic.common.pojo.ModelRela;
import com.tencent.supersonic.common.util.BeanMapper;
import com.tencent.supersonic.headless.server.persistence.dataobject.ModelRelaDO;
import com.tencent.supersonic.headless.server.persistence.mapper.ModelRelaDOMapper;
import com.tencent.supersonic.headless.server.web.service.ModelRelaService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ModelRelaServiceImpl
extends ServiceImpl<ModelRelaDOMapper, ModelRelaDO>
implements ModelRelaService {
    @Override
    public void save(ModelRela modelRela, User user) {
        modelRela.createdBy(user.getName());
        ModelRelaDO modelRelaDO = this.convert(modelRela);
        this.save(modelRelaDO);
    }

    @Override
    public void update(ModelRela modelRela, User user) {
        modelRela.updatedBy(user.getName());
        ModelRelaDO modelRelaDO = this.convert(modelRela);
        this.updateById(modelRelaDO);
    }

    @Override
    public List<ModelRela> getModelRelaList(Long domainId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.lambda().eq(ModelRelaDO::getDomainId, (Object)domainId);
        return this.list((Wrapper)wrapper).stream().map(this::convert).collect(Collectors.toList());
    }

    @Override
    public List<ModelRela> getModelRela(List<Long> modelIds) {
        QueryWrapper wrapper = new QueryWrapper();
        if (CollectionUtils.isEmpty(modelIds)) {
            return Lists.newArrayList();
        }
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.lambda().in(ModelRelaDO::getFromModelId, modelIds)).or()).in(ModelRelaDO::getToModelId, modelIds);
        return this.list((Wrapper)wrapper).stream().map(this::convert).collect(Collectors.toList());
    }

    @Override
    public void delete(Long id) {
        this.removeById(id);
    }

    private ModelRela convert(ModelRelaDO modelRelaDO) {
        ModelRela modelRela = new ModelRela();
        BeanMapper.mapper((Object)modelRelaDO, (Object)modelRela);
        modelRela.setJoinConditions(JSONObject.parseArray((String)modelRelaDO.getJoinCondition(), JoinCondition.class));
        return modelRela;
    }

    private ModelRelaDO convert(ModelRela modelRelaReq) {
        ModelRelaDO modelRelaDO = new ModelRelaDO();
        BeanMapper.mapper((Object)modelRelaReq, (Object)modelRelaDO);
        modelRelaDO.setJoinCondition(JSONObject.toJSONString((Object)modelRelaReq.getJoinConditions()));
        return modelRelaDO;
    }
}

