/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.web.service.impl;

import com.google.common.collect.Lists;
import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.auth.api.authentication.service.UserService;
import com.tencent.supersonic.common.pojo.ItemDateResp;
import com.tencent.supersonic.common.pojo.enums.AuthType;
import com.tencent.supersonic.common.pojo.enums.EventType;
import com.tencent.supersonic.common.pojo.enums.StatusEnum;
import com.tencent.supersonic.common.pojo.exception.InvalidArgumentException;
import com.tencent.supersonic.common.util.JsonUtil;
import com.tencent.supersonic.headless.api.pojo.Dim;
import com.tencent.supersonic.headless.api.pojo.Identify;
import com.tencent.supersonic.headless.api.pojo.ItemDateFilter;
import com.tencent.supersonic.headless.api.pojo.Measure;
import com.tencent.supersonic.headless.api.pojo.SchemaItem;
import com.tencent.supersonic.headless.api.pojo.request.DateInfoReq;
import com.tencent.supersonic.headless.api.pojo.request.DimensionReq;
import com.tencent.supersonic.headless.api.pojo.request.FieldRemovedReq;
import com.tencent.supersonic.headless.api.pojo.request.MetaBatchReq;
import com.tencent.supersonic.headless.api.pojo.request.MetricReq;
import com.tencent.supersonic.headless.api.pojo.request.ModelReq;
import com.tencent.supersonic.headless.api.pojo.response.DataSetResp;
import com.tencent.supersonic.headless.api.pojo.response.DatabaseResp;
import com.tencent.supersonic.headless.api.pojo.response.DimensionResp;
import com.tencent.supersonic.headless.api.pojo.response.DomainResp;
import com.tencent.supersonic.headless.api.pojo.response.MetricResp;
import com.tencent.supersonic.headless.api.pojo.response.ModelResp;
import com.tencent.supersonic.headless.api.pojo.response.UnAvailableItemResp;
import com.tencent.supersonic.headless.server.persistence.dataobject.DateInfoDO;
import com.tencent.supersonic.headless.server.persistence.dataobject.ModelDO;
import com.tencent.supersonic.headless.server.persistence.repository.DateInfoRepository;
import com.tencent.supersonic.headless.server.persistence.repository.ModelRepository;
import com.tencent.supersonic.headless.server.pojo.MetaFilter;
import com.tencent.supersonic.headless.server.pojo.ModelFilter;
import com.tencent.supersonic.headless.server.utils.ModelConverter;
import com.tencent.supersonic.headless.server.utils.NameCheckUtils;
import com.tencent.supersonic.headless.server.web.service.DataSetService;
import com.tencent.supersonic.headless.server.web.service.DatabaseService;
import com.tencent.supersonic.headless.server.web.service.DimensionService;
import com.tencent.supersonic.headless.server.web.service.DomainService;
import com.tencent.supersonic.headless.server.web.service.MetricService;
import com.tencent.supersonic.headless.server.web.service.ModelService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ModelServiceImpl
implements ModelService {
    private static final Logger log = LoggerFactory.getLogger(ModelServiceImpl.class);
    private ModelRepository modelRepository;
    private DatabaseService databaseService;
    private DimensionService dimensionService;
    private MetricService metricService;
    private DomainService domainService;
    private UserService userService;
    private DataSetService dataSetService;
    private DateInfoRepository dateInfoRepository;

    public ModelServiceImpl(ModelRepository modelRepository, DatabaseService databaseService, @Lazy DimensionService dimensionService, @Lazy MetricService metricService, DomainService domainService, UserService userService, DataSetService dataSetService, DateInfoRepository dateInfoRepository) {
        this.modelRepository = modelRepository;
        this.databaseService = databaseService;
        this.dimensionService = dimensionService;
        this.metricService = metricService;
        this.domainService = domainService;
        this.userService = userService;
        this.dataSetService = dataSetService;
        this.dateInfoRepository = dateInfoRepository;
    }

    @Override
    @Transactional
    public ModelResp createModel(ModelReq modelReq, User user) throws Exception {
        this.checkName(modelReq);
        ModelDO modelDO = ModelConverter.convert(modelReq, user);
        this.modelRepository.createModel(modelDO);
        this.batchCreateDimension(modelDO, user);
        this.batchCreateMetric(modelDO, user);
        return ModelConverter.convert(modelDO);
    }

    @Override
    @Transactional
    public ModelResp updateModel(ModelReq modelReq, User user) throws Exception {
        this.checkName(modelReq);
        ModelDO modelDO = this.modelRepository.getModelById(modelReq.getId());
        ModelConverter.convert(modelDO, modelReq, user);
        this.modelRepository.updateModel(modelDO);
        this.batchCreateDimension(modelDO, user);
        this.batchCreateMetric(modelDO, user);
        return ModelConverter.convert(modelDO);
    }

    @Override
    public List<ModelResp> getModelList(MetaFilter metaFilter) {
        ModelFilter modelFilter = new ModelFilter();
        BeanUtils.copyProperties((Object)metaFilter, (Object)modelFilter);
        List<ModelResp> modelResps = ModelConverter.convertList(this.modelRepository.getModelList(modelFilter));
        if (modelFilter.getDataSetId() != null) {
            DataSetResp dataSetResp = this.dataSetService.getDataSet(modelFilter.getDataSetId());
            return modelResps.stream().filter(modelResp -> dataSetResp.getAllModels().contains(modelResp.getId())).collect(Collectors.toList());
        }
        return modelResps;
    }

    @Override
    public Map<Long, ModelResp> getModelMap(ModelFilter modelFilter) {
        HashMap<Long, ModelResp> map = new HashMap<Long, ModelResp>();
        List<ModelResp> modelResps = this.getModelList(modelFilter);
        if (CollectionUtils.isEmpty(modelResps)) {
            return map;
        }
        return modelResps.stream().collect(Collectors.toMap(SchemaItem::getId, a -> a, (k1, k2) -> k1));
    }

    @Override
    public void deleteModel(Long id, User user) {
        ModelDO datasourceDO = this.modelRepository.getModelById(id);
        if (datasourceDO == null) {
            return;
        }
        this.checkDelete(id);
        datasourceDO.setStatus(StatusEnum.DELETED.getCode());
        datasourceDO.setUpdatedAt(new Date());
        datasourceDO.setUpdatedBy(user.getName());
        this.modelRepository.updateModel(datasourceDO);
    }

    @Override
    public ItemDateResp getItemDate(ItemDateFilter dimension, ItemDateFilter metric) {
        ArrayList<DateInfoReq> itemDates = new ArrayList<DateInfoReq>();
        List<DateInfoDO> dimensions = this.dateInfoRepository.getDateInfos(dimension);
        List<DateInfoDO> metrics = this.dateInfoRepository.getDateInfos(metric);
        log.info("getDateDate, dimension:{}, dimensions dateInfo:{}", (Object)dimension, dimensions);
        log.info("getDateDate, metric:{}, metrics dateInfo:{}", (Object)metric, metrics);
        itemDates.addAll(this.convert(dimensions));
        itemDates.addAll(this.convert(metrics));
        ItemDateResp itemDateDescriptor = this.calculateDateInternal(itemDates);
        log.info("itemDateDescriptor:{}", (Object)itemDateDescriptor);
        return itemDateDescriptor;
    }

    @Override
    public UnAvailableItemResp getUnAvailableItem(FieldRemovedReq fieldRemovedReq) {
        if (CollectionUtils.isEmpty((Collection)fieldRemovedReq.getFields())) {
            return UnAvailableItemResp.builder().build();
        }
        MetaFilter metaFilter = new MetaFilter(Lists.newArrayList((Object[])new Long[]{fieldRemovedReq.getModelId()}));
        metaFilter.setFieldsDepend(fieldRemovedReq.getFields());
        List<MetricResp> metricResps = this.metricService.getMetrics(metaFilter);
        List<DimensionResp> dimensionResps = this.dimensionService.getDimensions(metaFilter);
        return UnAvailableItemResp.builder().dimensionResps(dimensionResps).metricResps(metricResps).build();
    }

    private void batchCreateDimension(ModelDO modelDO, User user) throws Exception {
        List<DimensionReq> dimensionReqs = ModelConverter.convertDimensionList(modelDO);
        this.dimensionService.createDimensionBatch(dimensionReqs, user);
    }

    private void batchCreateMetric(ModelDO datasourceDO, User user) throws Exception {
        List<MetricReq> metricReqs = ModelConverter.convertMetricList(datasourceDO);
        this.metricService.createMetricBatch(metricReqs, user);
    }

    private void checkName(ModelReq modelReq) {
        String forbiddenCharacters = NameCheckUtils.findForbiddenCharacters(modelReq.getName());
        if (StringUtils.isNotBlank((CharSequence)forbiddenCharacters)) {
            String message = String.format("\u6a21\u578b\u540d\u79f0[%s]\u5305\u542b\u7279\u6b8a\u5b57\u7b26(%s), \u8bf7\u4fee\u6539", modelReq.getName(), forbiddenCharacters);
            throw new InvalidArgumentException(message);
        }
        List dims = modelReq.getModelDetail().getDimensions();
        List measures = modelReq.getModelDetail().getMeasures();
        List timeDims = modelReq.getTimeDimension();
        List identifies = modelReq.getModelDetail().getIdentifiers();
        if (CollectionUtils.isEmpty((Collection)dims)) {
            throw new InvalidArgumentException("\u7f3a\u5c11\u7ef4\u5ea6\u4fe1\u606f");
        }
        if (!CollectionUtils.isEmpty((Collection)measures) && CollectionUtils.isEmpty((Collection)timeDims)) {
            throw new InvalidArgumentException("\u6709\u5ea6\u91cf\u65f6, \u4e0d\u53ef\u7f3a\u5c11\u65f6\u95f4\u7ef4\u5ea6");
        }
        for (Measure measure : measures) {
            String measureForbiddenCharacters = NameCheckUtils.findForbiddenCharacters(measure.getName());
            if (!StringUtils.isNotBlank((CharSequence)measure.getName()) || !StringUtils.isNotBlank((CharSequence)measureForbiddenCharacters)) continue;
            String message = String.format("\u5ea6\u91cf[%s]\u5305\u542b\u7279\u6b8a\u5b57\u7b26(%s), \u8bf7\u4fee\u6539", measure.getName(), measureForbiddenCharacters);
            throw new InvalidArgumentException(message);
        }
        for (Dim dim : dims) {
            String dimForbiddenCharacters = NameCheckUtils.findForbiddenCharacters(dim.getName());
            if (!StringUtils.isNotBlank((CharSequence)dim.getName()) || !StringUtils.isNotBlank((CharSequence)dimForbiddenCharacters)) continue;
            String message = String.format("\u7ef4\u5ea6[%s]\u5305\u542b\u7279\u6b8a\u5b57\u7b26(%s), \u8bf7\u4fee\u6539", dim.getName(), dimForbiddenCharacters);
            throw new InvalidArgumentException(message);
        }
        for (Identify identify : identifies) {
            String identifyForbiddenCharacters = NameCheckUtils.findForbiddenCharacters(identify.getName());
            if (!StringUtils.isNotBlank((CharSequence)identify.getName()) || !StringUtils.isNotBlank((CharSequence)identifyForbiddenCharacters)) continue;
            String message = String.format("\u4e3b\u952e/\u5916\u952e[%s]\u5305\u542b\u7279\u6b8a\u5b57\u7b26(%s), \u8bf7\u4fee\u6539", identify.getName(), identifyForbiddenCharacters);
            throw new InvalidArgumentException(message);
        }
    }

    private void checkDelete(Long modelId) {
        MetaFilter metaFilter = new MetaFilter();
        metaFilter.setModelIds(Lists.newArrayList((Object[])new Long[]{modelId}));
        List<MetricResp> metricResps = this.metricService.getMetrics(metaFilter);
        List<DimensionResp> dimensionResps = this.dimensionService.getDimensions(metaFilter);
        if (!CollectionUtils.isEmpty(metricResps) || !CollectionUtils.isEmpty(dimensionResps)) {
            throw new RuntimeException("\u5b58\u5728\u57fa\u4e8e\u8be5\u6a21\u578b\u521b\u5efa\u7684\u6307\u6807\u548c\u7ef4\u5ea6, \u6682\u4e0d\u80fd\u5220\u9664, \u8bf7\u786e\u8ba4");
        }
    }

    private ItemDateResp calculateDateInternal(List<DateInfoReq> itemDates) {
        if (CollectionUtils.isEmpty(itemDates)) {
            log.warn("itemDates is empty!");
            return null;
        }
        String dateFormat = itemDates.get(0).getDateFormat();
        String startDate = itemDates.get(0).getStartDate();
        String endDate = itemDates.get(0).getEndDate();
        String datePeriod = itemDates.get(0).getDatePeriod();
        List unavailableDateList = itemDates.get(0).getUnavailableDateList();
        for (DateInfoReq item : itemDates) {
            String startDate1 = item.getStartDate();
            String endDate1 = item.getEndDate();
            List unavailableDateList1 = item.getUnavailableDateList();
            if (StringUtils.isNotEmpty((CharSequence)startDate1) && startDate1.compareTo(startDate) > 0) {
                startDate = startDate1;
            }
            if (StringUtils.isNotEmpty((CharSequence)endDate1) && endDate1.compareTo(endDate) < 0) {
                endDate = endDate1;
            }
            if (CollectionUtils.isEmpty((Collection)unavailableDateList1)) continue;
            unavailableDateList.addAll(unavailableDateList1);
        }
        return new ItemDateResp(dateFormat, startDate, endDate, datePeriod, unavailableDateList);
    }

    @Override
    public List<ModelResp> getModelListWithAuth(User user, Long domainId, AuthType authType) {
        List<ModelResp> modelResps = this.getModelAuthList(user, domainId, authType);
        HashSet<ModelResp> modelRespSet = new HashSet<ModelResp>(modelResps);
        List<ModelResp> modelRespsAuthInheritDomain = this.getModelRespAuthInheritDomain(user, domainId, authType);
        modelRespSet.addAll(modelRespsAuthInheritDomain);
        return modelRespSet.stream().sorted(Comparator.comparingLong(SchemaItem::getId)).collect(Collectors.toList());
    }

    public List<ModelResp> getModelRespAuthInheritDomain(User user, Long domainId, AuthType authType) {
        List<Long> domainIds = this.domainService.getDomainAuthSet(user, authType).stream().filter(domainResp -> {
            if (domainId == null) {
                return true;
            }
            return domainId.equals(domainResp.getId()) || domainId.equals(domainResp.getParentId());
        }).map(SchemaItem::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(domainIds)) {
            return Lists.newArrayList();
        }
        ModelFilter modelFilter = new ModelFilter();
        modelFilter.setIncludesDetail(false);
        modelFilter.setDomainIds(domainIds);
        return this.getModelList(modelFilter);
    }

    @Override
    public List<ModelResp> getModelAuthList(User user, Long domainId, AuthType authTypeEnum) {
        ModelFilter modelFilter = new ModelFilter();
        modelFilter.setIncludesDetail(false);
        modelFilter.setDomainId(domainId);
        List<ModelResp> modelResps = this.getModelList(modelFilter);
        Set orgIds = this.userService.getUserAllOrgId(user.getName());
        List<Object> modelWithAuth = Lists.newArrayList();
        if (authTypeEnum.equals((Object)AuthType.ADMIN)) {
            modelWithAuth = modelResps.stream().filter(modelResp -> ModelServiceImpl.checkAdminPermission(orgIds, user, modelResp)).collect(Collectors.toList());
        }
        if (authTypeEnum.equals((Object)AuthType.VISIBLE)) {
            modelWithAuth = modelResps.stream().filter(domainResp -> ModelServiceImpl.checkDataSetPermission(orgIds, user, domainResp)).collect(Collectors.toList());
        }
        return modelWithAuth;
    }

    @Override
    public List<ModelResp> getModelByDomainIds(List<Long> domainIds) {
        if (CollectionUtils.isEmpty(domainIds)) {
            return Lists.newArrayList();
        }
        ModelFilter modelFilter = new ModelFilter();
        modelFilter.setDomainIds(domainIds);
        modelFilter.setIncludesDetail(false);
        List<ModelResp> modelResps = this.getModelList(modelFilter);
        if (CollectionUtils.isEmpty(modelResps)) {
            return modelResps;
        }
        return modelResps.stream().filter(modelResp -> domainIds.contains(modelResp.getDomainId())).collect(Collectors.toList());
    }

    @Override
    public List<ModelResp> getAllModelByDomainIds(List<Long> domainIds) {
        Set<DomainResp> domainResps = this.domainService.getDomainChildren(domainIds);
        List<Long> allDomainIds = domainResps.stream().map(SchemaItem::getId).collect(Collectors.toList());
        return this.getModelByDomainIds(allDomainIds);
    }

    @Override
    public ModelResp getModel(Long id) {
        ModelDO modelDO = this.getModelDO(id);
        if (modelDO == null) {
            return null;
        }
        Map<Long, DomainResp> domainRespMap = this.domainService.getDomainList().stream().collect(Collectors.toMap(SchemaItem::getId, d -> d));
        return ModelConverter.convert(modelDO, domainRespMap);
    }

    @Override
    public List<String> getModelAdmin(Long id) {
        ModelResp modelResp = this.getModel(id);
        if (modelResp == null) {
            return Lists.newArrayList();
        }
        if (!CollectionUtils.isEmpty((Collection)modelResp.getAdmins())) {
            return modelResp.getAdmins();
        }
        Long domainId = modelResp.getDomainId();
        DomainResp domainResp = this.domainService.getDomain(domainId);
        while (domainResp != null) {
            if (!CollectionUtils.isEmpty((Collection)domainResp.getAdmins())) {
                return domainResp.getAdmins();
            }
            domainId = domainResp.getParentId();
            domainResp = this.domainService.getDomain(domainId);
        }
        return Lists.newArrayList();
    }

    @Override
    public DatabaseResp getDatabaseByModelId(Long modelId) {
        ModelResp modelResp = this.getModel(modelId);
        if (modelResp != null) {
            Long databaseId = modelResp.getDatabaseId();
            return this.databaseService.getDatabase(databaseId);
        }
        return null;
    }

    @Override
    public void batchUpdateStatus(MetaBatchReq metaBatchReq, User user) {
        if (CollectionUtils.isEmpty((Collection)metaBatchReq.getIds())) {
            return;
        }
        ModelFilter modelFilter = new ModelFilter();
        modelFilter.setIds(metaBatchReq.getIds());
        List<ModelDO> modelDOS = this.modelRepository.getModelList(modelFilter);
        if (CollectionUtils.isEmpty(modelDOS)) {
            return;
        }
        modelDOS = modelDOS.stream().peek(modelDO -> {
            modelDO.setStatus(metaBatchReq.getStatus());
            modelDO.setUpdatedAt(new Date());
            modelDO.setUpdatedBy(user.getName());
            if (StatusEnum.OFFLINE.getCode().equals(metaBatchReq.getStatus()) || StatusEnum.DELETED.getCode().equals(metaBatchReq.getStatus())) {
                this.metricService.sendMetricEventBatch(Lists.newArrayList((Object[])new Long[]{modelDO.getId()}), EventType.DELETE);
                this.dimensionService.sendDimensionEventBatch(Lists.newArrayList((Object[])new Long[]{modelDO.getId()}), EventType.DELETE);
            } else if (StatusEnum.ONLINE.getCode().equals(metaBatchReq.getStatus())) {
                this.metricService.sendMetricEventBatch(Lists.newArrayList((Object[])new Long[]{modelDO.getId()}), EventType.ADD);
                this.dimensionService.sendDimensionEventBatch(Lists.newArrayList((Object[])new Long[]{modelDO.getId()}), EventType.ADD);
            }
        }).collect(Collectors.toList());
        this.modelRepository.batchUpdate(modelDOS);
    }

    protected ModelDO getModelDO(Long id) {
        return this.modelRepository.getModelById(id);
    }

    private List<DateInfoReq> convert(List<DateInfoDO> dateInfoDOList) {
        ArrayList<DateInfoReq> dateInfoCommendList = new ArrayList<DateInfoReq>();
        dateInfoDOList.forEach(dateInfoDO -> {
            DateInfoReq dateInfoCommend = new DateInfoReq();
            BeanUtils.copyProperties((Object)dateInfoDO, (Object)dateInfoCommend);
            dateInfoCommend.setUnavailableDateList(JsonUtil.toList((String)dateInfoDO.getUnavailableDateList(), String.class));
            dateInfoCommendList.add(dateInfoCommend);
        });
        return dateInfoCommendList;
    }

    public static boolean checkAdminPermission(Set<String> orgIds, User user, ModelResp modelResp) {
        List admins = modelResp.getAdmins();
        List adminOrgs = modelResp.getAdminOrgs();
        if (user.isSuperAdmin()) {
            return true;
        }
        String userName = user.getName();
        if (admins.contains(userName) || modelResp.getCreatedBy().equals(userName)) {
            return true;
        }
        if (CollectionUtils.isEmpty((Collection)adminOrgs)) {
            return false;
        }
        for (String orgId : orgIds) {
            if (!adminOrgs.contains(orgId)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkDataSetPermission(Set<String> orgIds, User user, ModelResp modelResp) {
        if (ModelServiceImpl.checkAdminPermission(orgIds, user, modelResp)) {
            return true;
        }
        List viewers = modelResp.getViewers();
        List viewOrgs = modelResp.getViewOrgs();
        if (user.isSuperAdmin()) {
            return true;
        }
        if (modelResp.openToAll()) {
            return true;
        }
        String userName = user.getName();
        if (viewers.contains(userName) || modelResp.getCreatedBy().equals(userName)) {
            return true;
        }
        if (CollectionUtils.isEmpty((Collection)viewOrgs)) {
            return false;
        }
        for (String orgId : orgIds) {
            if (!viewOrgs.contains(orgId)) continue;
            return true;
        }
        return false;
    }
}

