/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.web.service.impl;

import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.common.pojo.enums.StatusEnum;
import com.tencent.supersonic.common.util.BeanMapper;
import com.tencent.supersonic.headless.api.pojo.request.QueryRuleFilter;
import com.tencent.supersonic.headless.api.pojo.request.QueryRuleReq;
import com.tencent.supersonic.headless.api.pojo.response.DataSetResp;
import com.tencent.supersonic.headless.api.pojo.response.QueryRuleResp;
import com.tencent.supersonic.headless.server.persistence.dataobject.QueryRuleDO;
import com.tencent.supersonic.headless.server.persistence.repository.QueryRuleRepository;
import com.tencent.supersonic.headless.server.utils.QueryRuleConverter;
import com.tencent.supersonic.headless.server.web.service.DataSetService;
import com.tencent.supersonic.headless.server.web.service.QueryRuleService;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class QueryRuleServiceImpl
implements QueryRuleService {
    private static final Logger log = LoggerFactory.getLogger(QueryRuleServiceImpl.class);
    private final QueryRuleRepository queryRuleRepository;
    private final DataSetService dataSetService;

    public QueryRuleServiceImpl(QueryRuleRepository queryRuleRepository, DataSetService dataSetService) {
        this.queryRuleRepository = queryRuleRepository;
        this.dataSetService = dataSetService;
    }

    @Override
    public QueryRuleResp addQueryRule(QueryRuleReq queryRuleReq, User user) {
        this.checkPermission(queryRuleReq, user);
        QueryRuleDO queryRuleDO = QueryRuleConverter.convert2DO(queryRuleReq);
        Date date = new Date();
        queryRuleDO.setCreatedBy(user.getName());
        queryRuleDO.setCreatedAt(date);
        queryRuleDO.setUpdatedBy(user.getName());
        queryRuleDO.setUpdatedAt(date);
        queryRuleDO.setStatus(StatusEnum.ONLINE.getCode());
        queryRuleDO.setId(null);
        this.queryRuleRepository.create(queryRuleDO);
        return this.getQueryRuleById(queryRuleDO.getId(), user);
    }

    @Override
    public QueryRuleResp updateQueryRule(QueryRuleReq queryRuleReq, User user) {
        this.checkPermission(queryRuleReq, user);
        QueryRuleDO queryRuleDO = this.queryRuleRepository.getQueryRuleById(queryRuleReq.getId());
        QueryRuleDO queryRuleNew = QueryRuleConverter.convert2DO(queryRuleReq);
        BeanMapper.mapper((Object)queryRuleNew, (Object)queryRuleDO);
        queryRuleDO.setUpdatedAt(new Date());
        queryRuleDO.setUpdatedBy(user.getName());
        this.queryRuleRepository.update(queryRuleDO);
        return this.getQueryRuleById(queryRuleDO.getId(), user);
    }

    @Override
    public Boolean dropQueryRule(Long id, User user) {
        QueryRuleDO queryRuleDO = this.queryRuleRepository.getQueryRuleById(id);
        this.checkPermission(queryRuleDO, user);
        queryRuleDO.setStatus(StatusEnum.DELETED.getCode());
        this.queryRuleRepository.update(queryRuleDO);
        return true;
    }

    @Override
    public QueryRuleResp getQueryRuleById(Long id, User user) {
        QueryRuleDO queryRuleDO = this.queryRuleRepository.getQueryRuleById(id);
        QueryRuleResp queryRuleResp = QueryRuleConverter.convert2Resp(queryRuleDO);
        return queryRuleResp;
    }

    @Override
    public List<QueryRuleResp> getQueryRuleList(QueryRuleFilter queryRuleFilter, User user) {
        List<QueryRuleDO> queryRules = this.queryRuleRepository.getQueryRules(queryRuleFilter);
        List<QueryRuleResp> queryRuleRespList = QueryRuleConverter.convert2RespList(queryRules);
        return queryRuleRespList;
    }

    private void checkPermission(QueryRuleReq queryRuleReq, User user) {
        String userName = user.getName();
        if (Objects.nonNull(queryRuleReq.getDataSetId())) {
            DataSetResp dataSet = this.dataSetService.getDataSet(queryRuleReq.getDataSetId());
            if (dataSet.getAdmins().contains(userName) || dataSet.getCreatedBy().equalsIgnoreCase(userName)) {
                log.debug(String.format("user:%s, queryRuleReq:%s", userName, queryRuleReq));
                return;
            }
            throw new RuntimeException("\u7528\u6237\u6682\u65e0\u6743\u9650\u53d8\u66f4\u6570\u636e\u96c6\u7684\u89c4\u5219, \u8bf7\u786e\u8ba4");
        }
    }

    private void checkPermission(QueryRuleDO queryRuleDO, User user) {
        String userName = user.getName();
        if (Objects.nonNull(queryRuleDO.getDataSetId())) {
            DataSetResp dataSet = this.dataSetService.getDataSet(queryRuleDO.getDataSetId());
            if (dataSet.getAdmins().contains(userName) || dataSet.getCreatedBy().equalsIgnoreCase(userName)) {
                log.debug(String.format("user:%s, queryRuleDO:%s", userName, queryRuleDO));
                return;
            }
            throw new RuntimeException("\u7528\u6237\u6682\u65e0\u6743\u9650\u53d8\u66f4\u6570\u636e\u96c6\u7684\u89c4\u5219, \u8bf7\u786e\u8ba4");
        }
    }
}

