/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.supersonic.headless.server.web.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tencent.supersonic.auth.api.authentication.pojo.User;
import com.tencent.supersonic.common.util.BeanMapper;
import com.tencent.supersonic.common.util.JsonUtil;
import com.tencent.supersonic.headless.api.pojo.request.TermReq;
import com.tencent.supersonic.headless.api.pojo.response.TermResp;
import com.tencent.supersonic.headless.server.persistence.dataobject.TermDO;
import com.tencent.supersonic.headless.server.persistence.mapper.TermMapper;
import com.tencent.supersonic.headless.server.web.service.TermService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TermServiceImpl
extends ServiceImpl<TermMapper, TermDO>
implements TermService {
    @Override
    public void saveOrUpdate(TermReq termReq, User user) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(TermDO::getId, (Object)termReq.getId());
        TermDO termSetDO = (TermDO)this.getOne((Wrapper)queryWrapper);
        if (termSetDO == null) {
            termReq.createdBy(user.getName());
            termSetDO = new TermDO();
        }
        termReq.updatedBy(user.getName());
        this.convert(termReq, termSetDO);
        this.saveOrUpdate(termSetDO);
    }

    @Override
    public void delete(Long id) {
        this.removeById(id);
    }

    @Override
    public List<TermResp> getTerms(Long domainId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(TermDO::getDomainId, (Object)domainId);
        List termDOS = this.list((Wrapper)queryWrapper);
        return termDOS.stream().map(this::convert).collect(Collectors.toList());
    }

    @Override
    public Map<Long, List<TermResp>> getTermSets(Set<Long> domainIds) {
        if (CollectionUtils.isEmpty(domainIds)) {
            return new HashMap<Long, List<TermResp>>();
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().in(TermDO::getDomainId, domainIds);
        List list = this.list((Wrapper)queryWrapper);
        return list.stream().map(this::convert).collect(Collectors.groupingBy(TermResp::getDomainId));
    }

    private TermResp convert(TermDO termDO) {
        TermResp termSetResp = new TermResp();
        BeanMapper.mapper((Object)termDO, (Object)termSetResp);
        termSetResp.setAlias(JsonUtil.toList((String)termDO.getAlias(), String.class));
        termSetResp.setRelatedMetrics(JsonUtil.toList((String)termDO.getRelatedMetrics(), Long.class));
        termSetResp.setRelateDimensions(JsonUtil.toList((String)termDO.getRelatedDimensions(), Long.class));
        return termSetResp;
    }

    private void convert(TermReq termReq, TermDO termDO) {
        BeanMapper.mapper((Object)termReq, (Object)termDO);
        termDO.setAlias(JsonUtil.toString((Object)termReq.getAlias()));
        termDO.setRelatedDimensions(JsonUtil.toString((Object)termReq.getRelateDimensions()));
        termDO.setRelatedMetrics(JsonUtil.toString((Object)termReq.getRelatedMetrics()));
    }
}

