/*
 * Decompiled with CFR 0.152.
 */
package com.els;

import com.els.config.LogSink;
import com.els.config.SourceLog;
import java.net.InetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.actuate.autoconfigure.security.servlet.ManagementWebSecurityAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.security.servlet.SecurityAutoConfiguration;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.cloud.stream.messaging.Sink;
import org.springframework.cloud.stream.messaging.Source;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.scheduling.annotation.EnableAsync;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@EnableSwagger2
@EnableAsync
@EnableBinding(value={Source.class, SourceLog.class, Sink.class, LogSink.class})
@SpringBootApplication(exclude={SecurityAutoConfiguration.class, ManagementWebSecurityAutoConfiguration.class}, scanBasePackages={"com.els"})
public class ImApplication {
    private static final Logger log = LoggerFactory.getLogger(ImApplication.class);

    public static void main(String[] args) throws Exception {
        System.setProperty("spring.devtools.restart.enabled", "true");
        ConfigurableApplicationContext application = SpringApplication.run(ImApplication.class, (String[])args);
        ConfigurableEnvironment env = application.getEnvironment();
        String ip = InetAddress.getLocalHost().getHostAddress();
        String port = env.getProperty("server.port");
        String path = env.getProperty("server.servlet.context-path");
        log.info("\n----------------------------------------------------------\n\tApplication SRM is running! Access URLs:\n\tLocal: \t\thttp://localhost:" + port + path + "/\n\tExternal: \thttp://" + ip + ":" + port + path + "/\n\tswagger-ui: \thttp://" + ip + ":" + port + path + "/swagger-ui.html\n\tDoc: \t\thttp://" + ip + ":" + port + path + "/doc.html\n----------------------------------------------------------");
    }
}

