/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.single.rpc.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.els.common.api.vo.Result;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.modules.account.api.dto.ImUserDTO;
import com.els.modules.account.api.service.ImAccountRpcService;
import com.els.modules.im.api.dto.ImRecordDto;
import com.els.modules.im.api.enumerate.ImRecordTypeEnum;
import com.els.modules.im.api.service.ImUserRecordRpcService;
import com.els.modules.im.rpc.base.AbstractInvokeImUserRecordServiceImpl;
import com.els.modules.im.rpc.service.ImUserRecordHandlerService;
import com.els.modules.im.single.config.SrmInterfaceProperties;
import com.els.modules.im.utils.HttpRequestUtil;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class InvokeImUserRecordBeanServiceImpl
extends AbstractInvokeImUserRecordServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(InvokeImUserRecordBeanServiceImpl.class);
    @Resource
    protected ImAccountRpcService imAccountRpcService;
    @Resource
    protected ImUserRecordHandlerService imUserRecordHandlerService;
    @Resource
    private SrmInterfaceProperties srmInterfaceProperties;
    @Autowired(required=false)
    private RestTemplate imRestTemplate;
    private static final String NGINX_308 = "<head><title>308 Permanent Redirect</title></head>";

    public List<ImUserDTO> getRecordPersonInCharge(ImRecordDto imRecordDto) {
        ImRecordTypeEnum recordTypeEnum = ImRecordTypeEnum.getImRecordTypeEnum((String)imRecordDto.getType());
        if (recordTypeEnum == null) {
            return Lists.newArrayList();
        }
        List imRecordVoList = null;
        if ("merge".equals(this.srmInterfaceProperties.getDeployType())) {
            ImUserRecordRpcService imUserRecordRpcService = this.imUserRecordHandlerService.getImUserRecordRpcService(recordTypeEnum.getRpcServiceName());
            if (imUserRecordRpcService == null) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u6539\u5355\u636e\u7c7b\u578b\u670d\u52a1\u672a\u63d0\u4f9b\u63a5\u53e3\u5b9e\u73b0\uff01"));
            }
            imRecordVoList = imUserRecordRpcService.getRecordPersonInCharge(imRecordDto);
        } else {
            imRecordVoList = this.getRecordPersonInChargeFromHttp(imRecordDto);
        }
        if (CollUtil.isEmpty(imRecordVoList)) {
            return Lists.newArrayList();
        }
        return this.getImUserOfElsAccount(imRecordVoList, p -> this.imAccountRpcService.getImUserByLoginNames(p));
    }

    private List<ImUserDTO> getRecordPersonInChargeFromHttp(ImRecordDto imRecordDto) {
        List<ImUserDTO> result;
        if (CharSequenceUtil.isEmpty((CharSequence)this.srmInterfaceProperties.getSrmImRecordPath())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_LERWWVVWWWSMWFjyVnR_8b107421", (String)"\u672a\u914d\u7f6eIm\u8bf7\u6c42SRM\u83b7\u53d6\u6570\u636e\u7684\u63a5\u53e3\u5730\u5740"));
        }
        log.info("::: els-im\u5f00\u59cb\u4ece==>{}\u67e5\u8be2\u6570\u636e", (Object)this.srmInterfaceProperties.getSrmImRecordPath());
        String body = "";
        try {
            Map param = (Map)Convert.convert(Map.class, (Object)imRecordDto);
            result = this.sendHttp(param, this.srmInterfaceProperties.getSrmImRecordPath(), false);
        }
        catch (Exception e) {
            log.error("els-im\u8bf7\u6c42\u83b7\u53d6srm\u63a5\u53e3\u6570\u636e\u5931\u8d25:{}", (Object)e.getMessage());
            String errorMsg = "Im\u8bf7\u6c42\u83b7\u53d6srm\u63a5\u53e3\u6570\u636e\u5931\u8d25";
            try {
                Result error = (Result)JSON.parseObject((String)body, Result.class);
                errorMsg = error.getMessage();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_WWVVSMWWWyVWFKm_b3a52cf0", (String)errorMsg));
        }
        log.info("::: els-im\u4ece==>{}\u67e5\u8be2\u6570\u636e\u5b8c\u6bd5", (Object)this.srmInterfaceProperties.getSrmImRecordPath());
        return result;
    }

    protected List<ImUserDTO> sendHttp(Map<String, Object> param, String path, boolean stop) {
        List result;
        ResponseEntity response = this.imRestTemplate.exchange(String.valueOf(path) + "?" + HttpRequestUtil.buildGetUrlParam(param), HttpMethod.GET, HttpRequestUtil.buildHeaders(null, null), String.class, param);
        try {
            result = JSON.parseArray((String)((String)response.getBody()), ImUserDTO.class);
        }
        catch (JSONException e) {
            if (CharSequenceUtil.isNotBlank((CharSequence)((CharSequence)response.getBody())) && Objects.requireNonNull((String)response.getBody()).contains(NGINX_308) && !stop) {
                path = path.startsWith("https") ? path.replace("https", "http") : path.replace("http", "https");
                return this.sendHttp(param, path, true);
            }
            throw e;
        }
        return result;
    }
}

