/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.core.tio;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.system.vo.LoginUser;
import com.els.modules.account.api.dto.ImUserDTO;
import com.els.modules.im.core.ImMessageInfo;
import com.els.modules.im.core.SendInfo;
import com.els.modules.im.core.tio.WsOnlineContext;
import com.els.modules.im.entity.ImChatGroup;
import com.els.modules.im.entity.ImMessage;
import com.els.modules.im.rpc.service.InvokeImAccountRpcService;
import com.els.modules.im.service.IImChatGroupService;
import com.els.modules.im.service.IImMessageService;
import com.els.shiro.authc.ShiroRealm;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tio.core.ChannelContext;
import org.tio.core.GroupContext;
import org.tio.core.Tio;
import org.tio.core.intf.Packet;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponse;
import org.tio.utils.lock.SetWithLock;
import org.tio.websocket.common.WsRequest;
import org.tio.websocket.common.WsResponse;
import org.tio.websocket.server.handler.IWsMsgHandler;

@Component
public class TioWsMsgHandler
implements IWsMsgHandler {
    private static final Logger log = LoggerFactory.getLogger(TioWsMsgHandler.class);
    @Resource(name="imMessageServiceImpl")
    private IImMessageService iImMessageService;
    @Autowired
    private ShiroRealm shiroRealm;
    @Resource(name="imChatGroupServiceImpl")
    private IImChatGroupService imChatGroupServiceImpl;
    @Resource
    private InvokeImAccountRpcService imAccountRpcService;

    public HttpResponse handshake(HttpRequest request, HttpResponse httpResponse, ChannelContext channelContext) {
        String token = request.getParam("token");
        log.info("handshake start token:" + token);
        LoginUser sysUser = this.shiroRealm.checkUserTokenIsEffect(token);
        String userId = this.imAccountRpcService.getImUserByLoginName(sysUser.getElsAccount(), sysUser.getSubAccount()).getId();
        Tio.bindUser((ChannelContext)channelContext, (String)userId);
        WsOnlineContext.bindUser(userId, channelContext);
        List<ImChatGroup> groups = this.imChatGroupServiceImpl.getChatGroups(userId);
        for (ImChatGroup group : groups) {
            Tio.bindGroup((ChannelContext)channelContext, (String)group.getId());
        }
        log.info("handshake success token:" + token);
        return httpResponse;
    }

    public void onAfterHandshaked(HttpRequest httpRequest, HttpResponse httpResponse, ChannelContext channelContext) throws Exception {
        List<ImUserDTO> friendsRequest = this.imAccountRpcService.getUserFriendsRequest(channelContext.userid);
        if (CollectionUtils.isNotEmpty(friendsRequest)) {
            JSONObject jo = new JSONObject();
            jo.put("msg_type", (Object)"addUser");
            jo.put("data", friendsRequest);
            WsResponse toWsResponse = WsResponse.fromText((String)jo.toString(), (String)"utf-8");
            Tio.send((ChannelContext)channelContext, (Packet)toWsResponse);
        }
    }

    public Object onBytes(WsRequest wsRequest, byte[] bytes, ChannelContext channelContext) throws Exception {
        return null;
    }

    public Object onClose(WsRequest wsRequest, byte[] bytes, ChannelContext channelContext) throws Exception {
        Tio.remove((ChannelContext)channelContext, (String)"receive close flag");
        HashMap<String, String> resultMap = new HashMap<String, String>();
        ImUserDTO user = this.imAccountRpcService.getImUserById(channelContext.userid);
        resultMap.put("msg_type", "close");
        resultMap.put("data", (String)user);
        return null;
    }

    public Object onText(WsRequest wsRequest, String text, ChannelContext channelContext) {
        try {
            JSONObject resultMap = new JSONObject();
            ObjectMapper objectMapper = new ObjectMapper();
            SendInfo sendInfo = (SendInfo)objectMapper.readValue(text, SendInfo.class);
            System.out.println(text);
            if ("0".equals(sendInfo.getCode())) {
                resultMap.put("msg_type", (Object)"msg_ping");
                resultMap.put("data", (Object)"\u5fc3\u8df3\u68c0\u6d4b\u5305");
                WsResponse wsResponse = WsResponse.fromText((String)resultMap.toString(), (String)"utf-8");
                Tio.send((ChannelContext)channelContext, (Packet)wsResponse);
            } else if ("2".equals(sendInfo.getCode())) {
                ImMessageInfo message = sendInfo.getMessage();
                if (CharSequenceUtil.isNotBlank((CharSequence)message.getCid())) {
                    resultMap.put("msg_type", (Object)"msg_customer");
                } else {
                    resultMap.put("msg_type", (Object)"msg_message");
                }
                resultMap.put("data", (Object)sendInfo.getMessage());
                message.setMine(false);
                WsResponse wsResponse = WsResponse.fromText((String)resultMap.toString(), (String)"utf-8");
                if ("friend".equals(message.getType()) || "customer".equals(message.getType())) {
                    SetWithLock channelContextSetWithLock = Tio.getChannelContextsByUserid((GroupContext)channelContext.groupContext, (String)message.getId());
                    if (channelContextSetWithLock == null || channelContextSetWithLock.size() == 0) {
                        this.saveMessage(message, "1");
                    } else {
                        Tio.sendToUser((GroupContext)channelContext.groupContext, (String)message.getId(), (Packet)wsResponse);
                        this.saveMessage(message, "0");
                    }
                } else {
                    Tio.sendToGroup((GroupContext)channelContext.groupContext, (String)message.getId(), (Packet)wsResponse);
                    this.saveMessage(message, "0");
                }
            } else if ("1".equals(sendInfo.getCode())) {
                this.sendOffLineMessage(channelContext, StrUtil.blankToDefault((CharSequence)sendInfo.getConnectType(), (String)"friend"));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void sendOffLineMessage(ChannelContext channelContext, String type) throws IOException {
        JSONObject resultMap = new JSONObject();
        List<ImMessage> imMessageList = this.iImMessageService.getUnReadMessage(channelContext.userid, type);
        ArrayList<ImMessageInfo> messageList = new ArrayList<ImMessageInfo>();
        for (ImMessage imMessage : imMessageList) {
            ImMessageInfo message = new ImMessageInfo();
            message.setId(imMessage.getFromId());
            message.setMine(false);
            message.setType("customer".equals(imMessage.getType()) ? "friend" : imMessage.getType());
            ImUserDTO imUser = this.imAccountRpcService.getImUserById(imMessage.getFromId());
            message.setUsername(imUser.getUsername());
            message.setCid("customer".equals(imMessage.getType()) ? "kefu" : String.valueOf(imMessage.getId()));
            message.setContent(imMessage.getContent());
            message.setTimestamp(imMessage.getSendTime());
            message.setFromid(imMessage.getFromId());
            message.setAvatar(imUser.getAvatar());
            messageList.add(message);
        }
        resultMap.put("msg_type", (Object)"unread");
        resultMap.put("data", messageList);
        WsResponse wsResponse = WsResponse.fromText((String)resultMap.toString(), (String)"utf-8");
        Tio.send((ChannelContext)channelContext, (Packet)wsResponse);
    }

    private void saveMessage(ImMessageInfo message, String readStatus) {
        ImMessage imMessage = new ImMessage();
        imMessage.setToId(message.getId());
        imMessage.setFromId(message.getFromid());
        imMessage.setSendTime(System.currentTimeMillis());
        imMessage.setContent(message.getContent());
        imMessage.setReadStatus(readStatus);
        imMessage.setType("kefu".equals(message.getCid()) ? "customer" : message.getType());
        this.iImMessageService.saveMessage(imMessage);
    }
}

