/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.kefu.core;

import com.els.modules.im.kefu.core.CircularBlockingQueue;
import com.els.modules.im.kefu.core.Seat;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeatCircularBlockingQueue
extends CircularBlockingQueue<Seat> {
    private static final Logger log = LoggerFactory.getLogger(SeatCircularBlockingQueue.class);

    public int getQueueServiceCount() {
        int count = 0;
        for (Seat seat : this) {
            count += seat.getSeatServiceCount();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String removeClientUser(String userId) {
        if (this.size() == 0) {
            return null;
        }
        ReentrantLock lock = this.putLock;
        try {
            lock.lockInterruptibly();
            for (Seat seat : this) {
                if (!seat.removeClient(userId)) continue;
                String string = seat.getKefuUserId();
                return string;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.putLock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pushToUser(String userId, int limit) {
        if (this.size() == 0) {
            return null;
        }
        ReentrantLock putLock = this.putLock;
        try {
            putLock.lockInterruptibly();
            Seat seat = null;
            int evg = this.getQueueServiceCount() / this.size();
            for (int i = 0; i < this.size(); ++i) {
                seat = (Seat)this.peek();
                if (seat.getSeatServiceCount() <= evg && seat.getSeatServiceCount() < limit) {
                    seat.addClient(userId);
                    String string = seat.getKefuUserId();
                    return string;
                }
                this.next();
            }
        }
        catch (Exception e) {
            log.error("pushToUser:{}", (Object)e.getMessage());
            String string = null;
            return string;
        }
        finally {
            putLock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pushLastServiceToUser(String userId, int limit, String lastToUserId) {
        if (this.size() == 0) {
            return null;
        }
        ReentrantLock putLock = this.putLock;
        try {
            putLock.lockInterruptibly();
            Seat seat = null;
            for (int i = 0; i < this.size(); ++i) {
                seat = (Seat)this.peek();
                if (Objects.equals(seat.getKefuUserId(), lastToUserId) && seat.getSeatServiceCount() < limit) {
                    seat.addClient(userId);
                    String string = seat.getKefuUserId();
                    return string;
                }
                this.next();
            }
        }
        catch (InterruptedException exp) {
            log.error("pushLastServiceToUser:{}", (Object)exp.getMessage());
            String string = null;
            return string;
        }
        finally {
            putLock.unlock();
        }
        return this.pushToUser(userId, limit);
    }
}

