/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.rpc.base;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import com.els.modules.account.api.dto.ImUserDTO;
import com.els.modules.im.rpc.service.InvokeImUserRecordRpcService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class AbstractInvokeImUserRecordServiceImpl
implements InvokeImUserRecordRpcService {
    protected List<ImUserDTO> getImUserOfElsAccount(List<ImUserDTO> imRecordVoList, Function<Set<String>, List<ImUserDTO>> app) {
        Map<String, List<ImUserDTO>> distinctAccount = imRecordVoList.stream().collect(Collectors.groupingBy(ImUserDTO::getElsAccount));
        List<ImUserDTO> imUsers = app.apply(distinctAccount.keySet());
        ArrayList result = Lists.newArrayList();
        for (ImUserDTO u : imUsers) {
            String keyAccount = u.getElsAccount() + "_" + u.getSubAccount();
            if (!distinctAccount.containsKey(keyAccount)) continue;
            distinctAccount.get(keyAccount).forEach(x -> {
                ImUserDTO v = (ImUserDTO)Convert.convert(ImUserDTO.class, (Object)u);
                String username = CharSequenceUtil.isBlank((CharSequence)x.getGroupName()) ? "" : "_" + x.getGroupName();
                v.setUsername(u.getUsername() + username);
                v.setGroupName(CharSequenceUtil.nullToDefault((CharSequence)x.getGroupName(), (String)""));
                v.setAvatar(x.getAvatar());
                result.add(v);
            });
        }
        result.sort(Comparator.comparing(ImUserDTO::getGroupName));
        return result;
    }
}

