/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.controller;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.api.vo.Result;
import com.els.common.exception.ELSBootException;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.dto.ImUserDTO;
import com.els.modules.im.core.tio.StartTioRunner;
import com.els.modules.im.core.tio.WsOnlineContext;
import com.els.modules.im.dto.ImChatGroupDto;
import com.els.modules.im.entity.ImChatGroup;
import com.els.modules.im.entity.ImChatGroupUser;
import com.els.modules.im.entity.ImGroup;
import com.els.modules.im.rpc.service.InvokeImAccountRpcService;
import com.els.modules.im.service.IImChatGroupService;
import com.els.modules.im.service.IImChatGroupUserService;
import com.els.modules.im.service.IImGroupService;
import com.els.modules.im.service.IImMessageService;
import com.els.modules.im.service.IImUserFriendService;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.core.intf.Packet;
import org.tio.websocket.common.WsResponse;

@RestController
@RequestMapping(value={"/im/userGroup"})
@Api(tags={"IM\u7528\u6237"})
public class ImUserGroupController {
    private static final Logger log = LoggerFactory.getLogger(ImUserGroupController.class);
    @Resource
    private StartTioRunner startTioRunner;
    @Resource(name="imUserFriendServiceImpl")
    private IImUserFriendService imUserFriendService;
    @Resource(name="imChatGroupUserServiceImpl")
    private IImChatGroupUserService imChatGroupUserService;
    @Resource(name="imMessageServiceImpl")
    private IImMessageService iImMessageService;
    @Resource(name="imChatGroupServiceImpl")
    private IImChatGroupService imChatGroupService;
    @Resource(name="imGroupServiceImpl")
    private IImGroupService iImGroupService;
    @Resource(name="imGroupServiceImpl")
    private IImGroupService imGroupServiceImpl;
    @Resource
    private InvokeImAccountRpcService imAccountRpcService;

    @PostMapping(value={"/add"})
    @ApiOperation(value="IM-\u6dfb\u52a0\u5206\u7ec4", notes="IM-\u6dfb\u52a0\u5206\u7ec4")
    public Result<?> add(@RequestParam(name="groupName") String groupName) {
        log.debug("\u6dfb\u52a0\u597d\u53cb\u5206\u7ec4:{}", (Object)groupName);
        LoginUser sysUser = SysUtil.getLoginUser();
        ImGroup imGroup = this.iImGroupService.addGroup(sysUser.getId(), groupName);
        return Result.ok((Object)imGroup);
    }

    @PostMapping(value={"/rename"})
    @ApiOperation(value="IM-\u5206\u7ec4\u91cd\u547d\u540d", notes="IM-\u5206\u7ec4\u91cd\u547d\u540d")
    public Result<?> rename(@RequestParam(name="groupId") String groupId, @RequestParam(name="groupName") String groupName) {
        log.debug("\u91cd\u547d\u540d\u597d\u53cb\u5206\u7ec4:{},{}", (Object)groupId, (Object)groupName);
        LoginUser sysUser = SysUtil.getLoginUser();
        this.iImGroupService.rename(groupId, sysUser.getId(), groupName);
        return Result.ok();
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="IM-\u597d\u53cb\u5206\u7ec4\u5220\u9664", notes="IM-\u597d\u53cb\u5206\u7ec4\u5220\u9664")
    public Result<?> deleteGroup(@RequestParam(name="groupId") String groupId) {
        log.debug("\u5220\u9664\u540d\u597d\u53cb\u5206\u7ec4:{}", (Object)groupId);
        LoginUser sysUser = SysUtil.getLoginUser();
        this.iImGroupService.deleteGroup(sysUser.getId(), groupId);
        return Result.ok();
    }

    @PostMapping(value={"/moveFriendToGroup"})
    @ApiOperation(value="IM-\u79fb\u52a8\u7528\u6237\u5230\u5206\u7ec4", notes="IM-\u79fb\u52a8\u7528\u6237\u5230\u5206\u7ec4")
    public Result<?> moveFriendToGroup(@RequestParam(name="friendId") String friendId, @RequestParam(name="groupId") String groupId) {
        log.debug("\u79fb\u52a8\u597d\u53cb\u5230\u5206\u7ec4:friendId:{},groupId:{}", (Object)friendId, (Object)groupId);
        LoginUser sysUser = SysUtil.getLoginUser();
        this.imUserFriendService.moveFriendToGroup(sysUser.getId(), friendId, groupId);
        return Result.ok();
    }

    @PostMapping(value={"/groupUpAndDown"})
    @ApiOperation(value="IM-\u5206\u7ec4\u4e0a\u4e0b\u79fb\u52a8", notes="IM-\u5206\u7ec4\u4e0a\u4e0b\u79fb\u52a8")
    public Result<?> groupUpAndDown(@RequestParam(name="moveGroupId") String moveGroupId, @RequestParam(name="targetGroupId") String targetGroupId) {
        LoginUser sysUser = SysUtil.getLoginUser();
        this.iImGroupService.groupUpAndDown(sysUser.getId(), moveGroupId, targetGroupId);
        return Result.ok();
    }

    @PostMapping(value={"/groupDrag"})
    @ApiOperation(value="IM-\u5206\u7ec4\u62d6\u62fd", notes="IM-\u5206\u7ec4\u62d6\u62fd")
    public Result<?> groupDrag(@RequestBody List<String> imGroups) {
        LoginUser sysUser = SysUtil.getLoginUser();
        this.iImGroupService.groupDrag(sysUser.getId(), imGroups);
        return Result.ok();
    }

    @PostMapping(value={"/noToken/initGroup/{userId}"})
    @ApiOperation(value="\u7528\u6237\u5206\u7ec4\u521d\u59cb\u5316", notes="\u7528\u6237\u5206\u7ec4\u521d\u59cb\u5316")
    public Boolean initGroup(@PathVariable String userId) {
        ImUserDTO account = this.imAccountRpcService.getImUserById(userId);
        if (null == account) {
            return false;
        }
        this.imGroupServiceImpl.initGroup(userId);
        return true;
    }

    @PostMapping(value={"/noToken/initGroupBatch"})
    @ApiOperation(value="\u7528\u6237\u5206\u7ec4\u6279\u91cf\u521d\u59cb\u5316", notes="\u7528\u6237\u5206\u7ec4\u6279\u91cf\u521d\u59cb\u5316")
    public Boolean initGroupBatch(@RequestBody List<String> userIdList) {
        List<ImUserDTO> accountList = this.imAccountRpcService.getUsersByUserIdList(userIdList);
        if (CollUtil.isEmpty(accountList)) {
            return false;
        }
        List<String> ids = accountList.stream().map(ImUserDTO::getId).collect(Collectors.toList());
        this.imGroupServiceImpl.initGroupBatch(ids);
        return true;
    }

    @PostMapping(value={"/addChatGroupUser"})
    @ApiOperation(value="IM-\u6dfb\u52a0\u7fa4\u5458", notes="IM-\u6dfb\u52a0\u7fa4\u5458")
    public Result<?> addChatGroupUser(@RequestBody ImChatGroupDto imChatGroupDto) {
        if (CollUtil.isEmpty(imChatGroupDto.getUserId())) {
            return Result.ok(Collections.emptyList());
        }
        ImChatGroup imChatGroup = (ImChatGroup)this.imChatGroupService.getById((Serializable)((Object)imChatGroupDto.getChatGroupId()));
        if (null == imChatGroup) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u4e0d\u5b58\u5728\u8be5\u7fa4"));
        }
        String userId = SysUtil.getLoginUser().getId();
        if (!imChatGroup.getMaster().equals(userId)) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u65e0\u8be5\u7fa4\u64cd\u4f5c\u6743\u9650"));
        }
        List<ImChatGroupUser> userList = this.imChatGroupUserService.getByKey(imChatGroupDto.getUserId(), imChatGroupDto.getChatGroupId());
        List userIds = userList.stream().map(ImChatGroupUser::getUserId).distinct().collect(Collectors.toList());
        imChatGroupDto.getUserId().removeAll(userIds);
        if (CollUtil.isEmpty(imChatGroupDto.getUserId())) {
            return Result.ok(Collections.emptyList());
        }
        List<ImUserDTO> imUserMap = this.imAccountRpcService.getUsersByUserIdList(imChatGroupDto.getUserId());
        if (CollUtil.isEmpty(imUserMap)) {
            return Result.ok(imUserMap);
        }
        JSONObject resultMap = new JSONObject();
        resultMap.put("msg_type", (Object)"addChatGroup");
        resultMap.put("data", (Object)imChatGroup);
        ArrayList chatGroupUserList = Lists.newArrayList();
        for (ImUserDTO member : imUserMap) {
            ImChatGroupUser chatGroupUser = new ImChatGroupUser();
            chatGroupUser.setChatGroupId(imChatGroupDto.getChatGroupId());
            chatGroupUser.setUserId(member.getId());
            chatGroupUser.setCreateDate(new Date());
            chatGroupUserList.add(chatGroupUser);
        }
        this.imChatGroupUserService.saveBatch(chatGroupUserList);
        for (ImUserDTO member : imUserMap) {
            ChannelContext channelContext = WsOnlineContext.getChannelContextByUser(member.getId());
            if (null == channelContext) continue;
            Tio.bindGroup((ChannelContext)channelContext, (String)imChatGroupDto.getChatGroupId());
            WsResponse toWsResponse = WsResponse.fromText((String)resultMap.toString(), (String)"utf-8");
            Tio.send((ChannelContext)channelContext, (Packet)toWsResponse);
        }
        return Result.ok(imUserMap);
    }

    @PostMapping(value={"/removeChatGroupUser"})
    @ApiOperation(value="IM-\u6dfb\u52a0\u7fa4\u5458", notes="IM-\u6dfb\u52a0\u7fa4\u5458")
    public Result<?> removeChatGroupUser(@RequestBody ImChatGroupDto imChatGroupDto) {
        if (CollUtil.isEmpty(imChatGroupDto.getUserId())) {
            return Result.ok();
        }
        ImChatGroup imChatGroup = (ImChatGroup)this.imChatGroupService.getById((Serializable)((Object)imChatGroupDto.getChatGroupId()));
        if (null == imChatGroup) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u4e0d\u5b58\u5728\u8be5\u7fa4"));
        }
        String userId = SysUtil.getLoginUser().getId();
        if (!imChatGroup.getMaster().equals(userId)) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u65e0\u8be5\u7fa4\u64cd\u4f5c\u6743\u9650"));
        }
        this.imChatGroupUserService.removeChatGroupUser(imChatGroupDto.getChatGroupId(), imChatGroupDto.getUserId());
        JSONObject resultMap = new JSONObject();
        resultMap.put("msg_type", (Object)"removeChatGroup");
        resultMap.put("data", (Object)imChatGroup);
        for (String memberId : imChatGroupDto.getUserId()) {
            ChannelContext channelContext = WsOnlineContext.getChannelContextByUser(memberId);
            if (null == channelContext) continue;
            Tio.unbindGroup((String)imChatGroupDto.getChatGroupId(), (ChannelContext)channelContext);
            WsResponse toWsResponse = WsResponse.fromText((String)resultMap.toString(), (String)"utf-8");
            Tio.send((ChannelContext)channelContext, (Packet)toWsResponse);
        }
        return Result.ok();
    }
}

