/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.core.tio.handler;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.async.MyAsync;
import com.els.common.util.SpringContextUtils;
import com.els.config.IpaasConfig;
import com.els.modules.account.api.dto.ImUserDTO;
import com.els.modules.im.core.ImMessageInfo;
import com.els.modules.im.core.SendInfo;
import com.els.modules.im.core.common.utils.ChatUtils;
import com.els.modules.im.core.tio.handler.HandlerDbService;
import com.els.modules.im.core.tio.handler.HandlerManager;
import com.els.modules.im.core.tio.handler.OptHandler;
import com.els.modules.im.entity.ImChatGroup;
import com.els.modules.im.entity.ImMessage;
import com.els.modules.im.rpc.service.InvokeImAccountRpcService;
import com.els.modules.im.service.IImChatGroupService;
import com.els.modules.im.service.IImMessageService;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.core.intf.Packet;
import org.tio.websocket.common.WsRequest;
import org.tio.websocket.common.WsResponse;

public abstract class AbstractConnHandler
implements OptHandler,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(AbstractConnHandler.class);
    @Autowired
    protected HandlerDbService handlerDbService;
    protected final ObjectMapper objectMapper = new ObjectMapper();
    protected final IImMessageService iImMessageService = (IImMessageService)SpringContextUtils.getBean((String)"imMessageServiceImpl", IImMessageService.class);
    protected final InvokeImAccountRpcService imAccountRpcService = (InvokeImAccountRpcService)SpringContextUtils.getBean(InvokeImAccountRpcService.class);
    protected final IImChatGroupService imChatGroupServiceImpl = (IImChatGroupService)SpringContextUtils.getBean((String)"imChatGroupServiceImpl", IImChatGroupService.class);
    protected final Map<String, String> configMap = ((IpaasConfig)SpringContextUtils.getBean(IpaasConfig.class)).getConfig();

    @Override
    public Object reCallOnText(WsRequest wsRequest, String text, ChannelContext channelContext) {
        try {
            OptHandler optHandler;
            SendInfo sendInfo = (SendInfo)this.objectMapper.readValue(text, SendInfo.class);
            ImMessageInfo temMsg = sendInfo.getMessage();
            if (null != temMsg) {
                sendInfo.getMessage().setMessageType(ChatUtils.MessageType.type(temMsg.getContent()));
            }
            if (null == (optHandler = HandlerManager.execHandler(sendInfo.getCode()))) {
                return null;
            }
            return optHandler.handler(wsRequest, sendInfo, channelContext);
        }
        catch (Exception e) {
            log.error("AbstractConnHandler handler \u5904\u7406\u6d88\u606f\u5f02\u5e38:{}", (Object)e.getMessage());
            return null;
        }
    }

    @Override
    public Object handler(WsRequest wsRequest, SendInfo sendInfo, ChannelContext channelContext) {
        JSONObject outputResultMap = new JSONObject();
        Object obj = this.doHandler(outputResultMap, sendInfo, wsRequest, channelContext);
        this.asyncHandlerAfter(obj, outputResultMap, sendInfo, wsRequest, channelContext);
        return obj;
    }

    protected abstract Object doHandler(JSONObject var1, SendInfo var2, WsRequest var3, ChannelContext var4);

    @MyAsync
    protected void asyncHandlerAfter(Object resutlObj, JSONObject outputResultMap, SendInfo sendInfo, WsRequest wsRequest, ChannelContext channelContext) {
    }

    protected void sendOffLineMessage(ChannelContext channelContext, String type) {
        JSONObject resultMap = new JSONObject();
        List<ImMessage> imMessageList = this.iImMessageService.getUnReadMessage(channelContext.userid, type);
        if (CollectionUtil.isEmpty(imMessageList)) {
            return;
        }
        List<String> imUserId = imMessageList.stream().map(ImMessage::getFromId).distinct().collect(Collectors.toList());
        List<ImUserDTO> usersByUserIdList = this.imAccountRpcService.getUsersByUserIdList(imUserId);
        Map userDTOMap = usersByUserIdList.stream().collect(Collectors.toMap(ImUserDTO::getId, Function.identity(), (x1, x2) -> x2));
        ArrayList<ImMessageInfo> messageList = new ArrayList<ImMessageInfo>();
        for (ImMessage imMessage : imMessageList) {
            ImMessageInfo message = new ImMessageInfo();
            message.setId(imMessage.getToId());
            message.setMine(false);
            message.setType("customer".equals(imMessage.getType()) ? "friend" : imMessage.getType());
            ImUserDTO imUser = (ImUserDTO)userDTOMap.get(imMessage.getFromId());
            message.setUsername(imUser.getUsername());
            message.setCid("customer".equals(imMessage.getType()) ? "kefu" : String.valueOf(imMessage.getId()));
            message.setContent(imMessage.getContent());
            message.setTimestamp(imMessage.getSendTime());
            message.setFromid(imMessage.getFromId());
            message.setMessageType(imMessage.getMessageType());
            message.setIfTranslate(imMessage.getIfTranslate());
            message.setAudioText(imMessage.getAudioText());
            message.setAvatar(imUser.getAvatar());
            messageList.add(message);
        }
        resultMap.put("msg_type", (Object)"unread");
        resultMap.put("data", messageList);
        WsResponse wsResponse = WsResponse.fromText((String)resultMap.toString(), (String)"utf-8");
        Tio.send((ChannelContext)channelContext, (Packet)wsResponse);
    }

    protected void sendGroupOffLineMessage(ChannelContext channelContext) {
        JSONObject resultMap = new JSONObject();
        List<ImMessage> imMessageList = this.iImMessageService.getGroupUnReadMessage(channelContext.userid);
        if (CollectionUtil.isEmpty(imMessageList)) {
            return;
        }
        List<String> imUserId = imMessageList.stream().map(ImMessage::getFromId).distinct().collect(Collectors.toList());
        List<ImUserDTO> usersByUserIdList = this.imAccountRpcService.getUsersByUserIdList(imUserId);
        Map userDtoMap = usersByUserIdList.stream().collect(Collectors.toMap(ImUserDTO::getId, Function.identity(), (x1, x2) -> x2));
        ArrayList<ImMessageInfo> messageList = new ArrayList<ImMessageInfo>();
        for (ImMessage imMessage : imMessageList) {
            ImMessageInfo message = new ImMessageInfo();
            message.setId(imMessage.getToId());
            message.setMine(false);
            message.setType("group");
            ImUserDTO imUser = (ImUserDTO)userDtoMap.get(imMessage.getFromId());
            message.setUsername(imUser.getUsername());
            message.setCid(String.valueOf(imMessage.getId()));
            message.setContent(imMessage.getContent());
            message.setTimestamp(imMessage.getSendTime());
            message.setFromid(imMessage.getFromId());
            message.setMessageType(imMessage.getMessageType());
            message.setIfTranslate(imMessage.getIfTranslate());
            message.setAudioText(imMessage.getAudioText());
            message.setAvatar(imUser.getAvatar());
            messageList.add(message);
        }
        resultMap.put("msg_type", (Object)"unread");
        Map<String, List<ImMessage>> messageMap = imMessageList.stream().collect(Collectors.groupingBy(ImMessage::getToId));
        messageMap.forEach((groupId, msg) -> {
            resultMap.put("data", msg);
            resultMap.put("type", (Object)"group");
            resultMap.put("groupId", (Object)"groupId");
        });
    }

    protected ImMessage saveMessage(ImMessageInfo message, String readStatus) {
        ImMessage imMessage = new ImMessage();
        imMessage.setToId(message.getId());
        imMessage.setFromId(message.getFromid());
        imMessage.setSendTime(System.currentTimeMillis());
        imMessage.setContent(message.getContent());
        imMessage.setReadStatus(readStatus);
        imMessage.setIfTranslate("0");
        imMessage.setAudioText(null);
        imMessage.setType("kefu".equals(message.getCid()) ? "customer" : message.getType());
        imMessage.setMessageType(message.getMessageType());
        this.iImMessageService.saveMessage(imMessage);
        return imMessage;
    }

    protected ImChatGroup getImChatGroupById(String id) {
        return (ImChatGroup)this.imChatGroupServiceImpl.getById((Serializable)((Object)id));
    }

    protected ImUserDTO getImUserById(String userId) {
        return this.imAccountRpcService.getImUserById(userId);
    }

    protected OptHandler register() {
        return this;
    }

    public void afterPropertiesSet() throws Exception {
        HandlerManager.register(this.opt().getValue(), this.register());
    }
}

