/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.utils;

import com.els.common.util.SpringContextUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;

public final class HttpRequestUtil {
    private static String GET_PARAM_FORMAT = "%s={%s}%s";

    public static String buildGetUrlParam(Map<String, Object> param) {
        if (null == param) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        ArrayList keys = Lists.newArrayList(param.keySet());
        int size = keys.size();
        for (int i = 0; i < size; ++i) {
            String key = (String)keys.get(i);
            sb.append(String.format(GET_PARAM_FORMAT, key, key, i == size - 1 ? "" : "&"));
        }
        return sb.toString();
    }

    public static HttpEntity<String> buildHeaders(HttpHeaders headers, Map<String, String> param) {
        if (null == headers) {
            headers = new HttpHeaders();
        }
        headers.add("X-Access-Token", SpringContextUtils.getHttpServletRequest().getHeader("X-Access-Token"));
        headers.setContentType(MediaType.APPLICATION_JSON);
        if (null != param) {
            param.forEach((arg_0, arg_1) -> ((HttpHeaders)headers).add(arg_0, arg_1));
        }
        return new HttpEntity((MultiValueMap)headers);
    }

    private HttpRequestUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

