/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.core.tio;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.IpaasConfig;
import com.els.config.StaticConfig;
import com.els.modules.account.api.dto.ImUserDTO;
import com.els.modules.im.core.ImMessageInfo;
import com.els.modules.im.core.SendInfo;
import com.els.modules.im.core.common.utils.ChatUtils;
import com.els.modules.im.core.tio.StartTioRunner;
import com.els.modules.im.core.tio.WsOnlineContext;
import com.els.modules.im.dto.ImMessageCallbackDto;
import com.els.modules.im.entity.ImChatGroup;
import com.els.modules.im.entity.ImMessage;
import com.els.modules.im.rpc.service.ImInvokeBaseRpcService;
import com.els.modules.im.rpc.service.InvokeImAccountRpcService;
import com.els.modules.im.service.IImChatGroupService;
import com.els.modules.im.service.IImMessageService;
import com.els.modules.im.service.ImSrmToIPaasService;
import com.els.modules.im.utils.TuLingRobotUtil;
import com.els.shiro.authc.ShiroRealm;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tio.core.ChannelContext;
import org.tio.core.GroupContext;
import org.tio.core.Tio;
import org.tio.core.intf.Packet;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponse;
import org.tio.utils.lock.SetWithLock;
import org.tio.websocket.common.WsRequest;
import org.tio.websocket.common.WsResponse;
import org.tio.websocket.server.handler.IWsMsgHandler;

@Component
public class TioWsMsgHandler
implements IWsMsgHandler {
    private static final Logger log = LoggerFactory.getLogger(TioWsMsgHandler.class);
    @Resource(name="imMessageServiceImpl")
    private IImMessageService iImMessageService;
    @Autowired
    private ShiroRealm shiroRealm;
    @Resource(name="imChatGroupServiceImpl")
    private IImChatGroupService imChatGroupServiceImpl;
    @Resource
    private InvokeImAccountRpcService imAccountRpcService;
    @Resource(name="imSrmToIPaasServiceImpl")
    private ImSrmToIPaasService imSrmToIPaasServiceImpl;
    @Resource
    private StartTioRunner startTioRunner;
    @Resource
    private ImInvokeBaseRpcService imInvokeBaseRpcService;
    private String serverPath = (String)((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig().get("service.address");
    private boolean robotOn = true;
    private Map<String, String> configMap = ((IpaasConfig)SpringContextUtils.getBean(IpaasConfig.class)).getConfig();
    @Autowired
    private RedisUtil redisUtil;
    private static final String ROBOT_ANSER = "im:tuling_robot:";
    private static final String IM_KEFU = "im:kefu:";
    private static final String FUKE_QURRY_USER = "im:kefu:query_user";
    private static final List<String> IGNORE = Lists.newArrayList((Object[])new String[]{"file"});

    public HttpResponse handshake(HttpRequest request, HttpResponse httpResponse, ChannelContext channelContext) {
        String token = request.getParam("token");
        log.info("handshake start token:" + token);
        LoginUser sysUser = this.shiroRealm.checkUserTokenIsEffect(token);
        String userId = this.imAccountRpcService.getImUserByLoginName(sysUser.getElsAccount(), sysUser.getSubAccount()).getId();
        Tio.bindUser((ChannelContext)channelContext, (String)userId);
        WsOnlineContext.bindUser(userId, channelContext);
        List<ImChatGroup> groups = this.imChatGroupServiceImpl.getChatGroups(userId);
        for (ImChatGroup group : groups) {
            Tio.bindGroup((ChannelContext)channelContext, (String)group.getId());
        }
        log.info("handshake success token:" + token);
        return httpResponse;
    }

    public void onAfterHandshaked(HttpRequest httpRequest, HttpResponse httpResponse, ChannelContext channelContext) throws Exception {
        List<ImUserDTO> friendsRequest = this.imAccountRpcService.getUserFriendsRequest(channelContext.userid);
        if (CollectionUtils.isNotEmpty(friendsRequest)) {
            JSONObject jo = new JSONObject();
            jo.put("msg_type", (Object)"addUser");
            jo.put("data", friendsRequest);
            WsResponse toWsResponse = WsResponse.fromText((String)jo.toString(), (String)"utf-8");
            Tio.send((ChannelContext)channelContext, (Packet)toWsResponse);
        }
    }

    public Object onBytes(WsRequest wsRequest, byte[] bytes, ChannelContext channelContext) throws Exception {
        return null;
    }

    public Object onClose(WsRequest wsRequest, byte[] bytes, ChannelContext channelContext) throws Exception {
        Tio.remove((ChannelContext)channelContext, (String)"receive close flag");
        HashMap<String, String> resultMap = new HashMap<String, String>();
        ImUserDTO user = this.imAccountRpcService.getImUserById(channelContext.userid);
        resultMap.put("msg_type", "close");
        resultMap.put("data", (String)user);
        return null;
    }

    public Object onText(WsRequest wsRequest, String text, ChannelContext channelContext) {
        try {
            JSONObject resultMap = new JSONObject();
            ObjectMapper objectMapper = new ObjectMapper();
            SendInfo sendInfo = (SendInfo)objectMapper.readValue(text, SendInfo.class);
            ImMessageInfo temMsg = sendInfo.getMessage();
            if (null != temMsg) {
                sendInfo.getMessage().setMessageType(ChatUtils.MessageType.type(temMsg.getContent()));
            }
            if ("0".equals(sendInfo.getCode())) {
                resultMap.put("msg_type", (Object)"msg_ping");
                resultMap.put("data", (Object)"\u5fc3\u8df3\u68c0\u6d4b\u5305");
                WsResponse wsResponse = WsResponse.fromText((String)resultMap.toString(), (String)"utf-8");
                Tio.send((ChannelContext)channelContext, (Packet)wsResponse);
            } else if ("3".equals(sendInfo.getCode())) {
                ImMessageInfo message = sendInfo.getMessage();
                String type = message.getType();
                if (type.startsWith("group")) {
                    if (type.contains("video_request")) {
                        resultMap.put("msg_type", (Object)"msg_video_request");
                        resultMap.put("data", (Object)sendInfo.getMessage());
                    } else if (type.contains("video_accept")) {
                        resultMap.put("msg_type", (Object)"msg_video_accept");
                        resultMap.put("data", (Object)sendInfo.getMessage());
                    } else {
                        resultMap.put("msg_type", (Object)"msg_video_reject");
                        resultMap.put("data", (Object)sendInfo.getMessage());
                    }
                    boolean inGroup = Tio.isInGroup((String)message.getId(), (ChannelContext)channelContext);
                    if (!inGroup) {
                        Tio.bindGroup((ChannelContext)channelContext, (String)message.getId());
                    }
                    WsResponse wsResponse = WsResponse.fromText((String)resultMap.toString(), (String)"utf-8");
                    Tio.sendToGroup((GroupContext)channelContext.groupContext, (String)message.getId(), (Packet)wsResponse);
                } else {
                    if (type.contains("video_request")) {
                        resultMap.put("msg_type", (Object)"msg_video_request");
                        resultMap.put("data", (Object)sendInfo.getMessage());
                    } else if (type.contains("video_accept")) {
                        resultMap.put("msg_type", (Object)"msg_video_accept");
                        resultMap.put("data", (Object)sendInfo.getMessage());
                    } else {
                        resultMap.put("msg_type", (Object)"msg_video_reject");
                        resultMap.put("data", (Object)sendInfo.getMessage());
                    }
                    SetWithLock channelContextSetWithLock = Tio.getChannelContextsByUserid((GroupContext)channelContext.groupContext, (String)message.getId());
                    if (channelContextSetWithLock != null && channelContextSetWithLock.size() != 0) {
                        WsResponse wsResponse = WsResponse.fromText((String)resultMap.toString(), (String)"utf-8");
                        Tio.sendToUser((GroupContext)channelContext.groupContext, (String)message.getId(), (Packet)wsResponse);
                    }
                }
            } else if ("2".equals(sendInfo.getCode())) {
                ImMessageInfo message = sendInfo.getMessage();
                if (CharSequenceUtil.isEmpty((CharSequence)message.getMessageType())) {
                    String content = message.getContent();
                    if (content.startsWith(TuLingRobotUtil.ResultType.IMAGE.getStart())) {
                        message.setMessageType(TuLingRobotUtil.ResultType.IMAGE.getType());
                    } else if (content.startsWith(TuLingRobotUtil.ResultType.VOICE.getStart())) {
                        message.setMessageType(TuLingRobotUtil.ResultType.VOICE.getType());
                    } else if (content.startsWith(TuLingRobotUtil.ResultType.VIDEO.getStart())) {
                        message.setMessageType(TuLingRobotUtil.ResultType.VIDEO.getType());
                    } else {
                        message.setMessageType(TuLingRobotUtil.ResultType.TEXT.getType());
                    }
                }
                if (CharSequenceUtil.isNotBlank((CharSequence)message.getCid())) {
                    resultMap.put("msg_type", (Object)"msg_customer");
                } else {
                    resultMap.put("msg_type", (Object)"msg_message");
                }
                resultMap.put("data", (Object)sendInfo.getMessage());
                message.setMine(false);
                WsResponse wsResponse = WsResponse.fromText((String)resultMap.toString(), (String)"utf-8");
                if ("friend".equals(message.getType()) && !"kefu".equals(message.getCid())) {
                    SetWithLock channelContextSetWithLock = Tio.getChannelContextsByUserid((GroupContext)channelContext.groupContext, (String)message.getId());
                    if (channelContextSetWithLock == null || channelContextSetWithLock.size() == 0) {
                        ImMessage imMessage = this.saveMessage(message, "1");
                    } else {
                        Tio.sendToUser((GroupContext)channelContext.groupContext, (String)message.getId(), (Packet)wsResponse);
                        ImMessage imMessage = this.saveMessage(message, "0");
                    }
                } else if ("customer".equals(message.getType()) || "kefu".equals(message.getCid())) {
                    ImMessage imMessage;
                    String toUserId = message.getId();
                    log.info(":::\u5ba2\u670d\u804a\u5929\u4e2d\uff0c\u6536\u5230\u6d88\u606f\u7684\u7528\u6237id:{}", (Object)toUserId);
                    Object o = this.redisUtil.get(IM_KEFU + toUserId);
                    boolean isKefu = false;
                    if (null == o) {
                        isKefu = this.imAccountRpcService.checkIfKefu(toUserId);
                        this.redisUtil.set(IM_KEFU + toUserId, (Object)isKefu, 86400L);
                    } else {
                        isKefu = (Boolean)o;
                    }
                    SetWithLock channelContextSetWithLock = Tio.getChannelContextsByUserid((GroupContext)channelContext.groupContext, (String)message.getId());
                    if (channelContextSetWithLock == null || channelContextSetWithLock.size() == 0) {
                        imMessage = this.saveMessage(message, "1");
                        if (BooleanUtil.isTrue((Boolean)this.robotOn) && isKefu) {
                            log.info(":::\u5373\u5c06\u8c03\u7528\u56fe\u7075\u673a\u5668\u4eba\u67e5\u627e\u6570\u636e...");
                            this.robotReplay(message, wsRequest, message.getFromid());
                        }
                    } else {
                        Tio.sendToUser((GroupContext)channelContext.groupContext, (String)message.getId(), (Packet)wsResponse);
                        imMessage = this.saveMessage(message, "0");
                        if (BooleanUtil.isTrue((Boolean)this.robotOn) && isKefu) {
                            log.info(":::\u5373\u5c06\u8c03\u7528\u56fe\u7075\u673a\u5668\u4eba\u67e5\u627e\u6570\u636e...");
                            this.robotReplay(message, wsRequest, message.getFromid());
                        }
                    }
                    this.sendMessageToIPass(imMessage);
                } else {
                    boolean inGroup = Tio.isInGroup((String)message.getId(), (ChannelContext)channelContext);
                    if (!inGroup) {
                        Tio.bindGroup((ChannelContext)channelContext, (String)message.getId());
                    }
                    Tio.sendToGroup((GroupContext)channelContext.groupContext, (String)message.getId(), (Packet)wsResponse);
                    this.saveMessage(message, "0");
                }
            } else if ("1".equals(sendInfo.getCode())) {
                this.sendOffLineMessage(channelContext, StrUtil.blankToDefault((CharSequence)sendInfo.getConnectType(), (String)"friend"));
            }
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        return null;
    }

    private void sendMessageToIPass(ImMessage imMessage) {
        try {
            String key = "im:kefu:query_user:" + imMessage.getFromId();
            ImUserDTO user = (ImUserDTO)this.redisUtil.get(key);
            if (null == user) {
                user = this.imAccountRpcService.getLoginUser(imMessage.getFromId());
            }
            if (null == user) {
                log.error(":::\u7528\u6237\u4e0d\u5b58\u5728 userId:{}", (Object)imMessage.getFromId());
                return;
            }
            this.redisUtil.set("im:kefu:query_user:" + user.getId(), (Object)user, 259200L);
            JSONObject requestJSON = TuLingRobotUtil.buildJSONObject(imMessage, user, this.configMap.get("elsAccount"), this.serverPath);
            JSONObject result = this.imSrmToIPaasServiceImpl.callIPaasInterface(requestJSON, "valueAddedApplication", this.imInvokeBaseRpcService.getIpaasInterfaceCode("ipass-kefu-anser"));
            log.info(":::\u5ba2\u670d\u53d1\u9001\u6570\u636e\u7ed9ipass\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)result));
        }
        catch (Exception e) {
            log.error(":::\u5ba2\u670d\u53d1\u9001\u6570\u636e\u7ed9ipass\u5931\u8d25:{}", (Object)e.getMessage());
        }
    }

    private void robotReplay(ImMessageInfo message, WsRequest wsRequest, String userid) {
        if (IGNORE.contains(message.getMessageType())) {
            return;
        }
        Integer hashCode = message.getContent().hashCode();
        Object obj = this.redisUtil.get(ROBOT_ANSER + message.getId() + ":" + hashCode.toString());
        List<Object> tuLingRobotResults = new ArrayList();
        if (obj != null) {
            log.info(":::\u81ea\u52a8\u56de\u590d\u4ece\u7f13\u5b58\u4e2d\u56de\u53bb\u7ed3\u679c:{}", obj);
            tuLingRobotResults = JSONArray.parseArray((String)JSON.toJSONString((Object)obj), TuLingRobotUtil.TuLingRobotResult.class);
        } else {
            JSONObject requestJSON = TuLingRobotUtil.buildJSONObject(message, this.configMap.get("elsAccount"), this.serverPath);
            JSONObject result = this.imSrmToIPaasServiceImpl.callIPaasInterface(requestJSON, "valueAddedApplication", this.imInvokeBaseRpcService.getIpaasInterfaceCode("tuling-anser"));
            tuLingRobotResults = TuLingRobotUtil.analysisResult(result);
            if (!tuLingRobotResults.isEmpty()) {
                this.redisUtil.set(ROBOT_ANSER + message.getId() + ":" + hashCode.toString(), tuLingRobotResults, 259200L);
            }
        }
        if (null == tuLingRobotResults || tuLingRobotResults.isEmpty()) {
            return;
        }
        ImUserDTO imUser = this.imAccountRpcService.getImUserById(message.getId());
        if (null == imUser) {
            return;
        }
        ChannelContext cc = WsOnlineContext.getChannelContextByUser(userid);
        for (TuLingRobotUtil.TuLingRobotResult tuLingRobotResult : tuLingRobotResults) {
            List<String> values = tuLingRobotResult.getValues();
            for (String v : values) {
                SendInfo sendInfo = new SendInfo();
                sendInfo.setCode("2");
                ImMessageInfo messageInfo = new ImMessageInfo();
                messageInfo.setId(message.getFromid());
                messageInfo.setFromid(message.getId());
                messageInfo.setCid("kefu");
                messageInfo.setUsername("\u4f01\u4f01\u901a\u5728\u7ebfRobot");
                messageInfo.setAvatar(imUser.getAvatar());
                JSONObject jsonObject = (JSONObject)JSON.parseObject((String)v, JSONObject.class);
                String value = jsonObject.getString(tuLingRobotResult.getResultType());
                messageInfo.setContent(value);
                messageInfo.setContent(TuLingRobotUtil.ResultType.buildText(tuLingRobotResult.getResultType(), value));
                messageInfo.setMine(false);
                messageInfo.setMessageType(TuLingRobotUtil.ResultType.buildType(tuLingRobotResult.getResultType()));
                messageInfo.setTimestamp(System.currentTimeMillis());
                messageInfo.setType(message.getType());
                messageInfo.setIfTranslate("0");
                sendInfo.setMessage(messageInfo);
                log.info(":::\u6536\u5230\u7684\u6d88\u606f:{},\u56fe\u7075\u673a\u5668\u4eba\u81ea\u52a8\u56de\u590d\u7684\u6d88\u606f:{}", (Object)message, (Object)sendInfo);
                if (cc == null || cc.isClosed) continue;
                try {
                    ObjectMapper objectMapper = new ObjectMapper();
                    this.onText(wsRequest, objectMapper.writeValueAsString((Object)sendInfo), cc);
                }
                catch (JsonProcessingException e) {
                    log.error("::: \u81ea\u52a8\u56de\u53bb\u56fe\u7075\u673a\u5668\u4eba\u67e5\u8be2\u7684\u5185\u5bb9\u5931\u8d25:{}", (Object)e.getMessage());
                }
            }
        }
    }

    private void sendOffLineMessage(ChannelContext channelContext, String type) throws IOException {
        JSONObject resultMap = new JSONObject();
        List<ImMessage> imMessageList = this.iImMessageService.getUnReadMessage(channelContext.userid, type);
        ArrayList<ImMessageInfo> messageList = new ArrayList<ImMessageInfo>();
        for (ImMessage imMessage : imMessageList) {
            ImMessageInfo message = new ImMessageInfo();
            message.setId(imMessage.getFromId());
            message.setMine(false);
            message.setType("customer".equals(imMessage.getType()) ? "friend" : imMessage.getType());
            ImUserDTO imUser = this.imAccountRpcService.getImUserById(imMessage.getFromId());
            message.setUsername(imUser.getUsername());
            message.setCid("customer".equals(imMessage.getType()) ? "kefu" : String.valueOf(imMessage.getId()));
            message.setContent(imMessage.getContent());
            message.setTimestamp(imMessage.getSendTime());
            message.setFromid(imMessage.getFromId());
            message.setMessageType(imMessage.getMessageType());
            message.setIfTranslate(imMessage.getIfTranslate());
            message.setAudioText(imMessage.getAudioText());
            message.setAvatar(imUser.getAvatar());
            messageList.add(message);
        }
        resultMap.put("msg_type", (Object)"unread");
        resultMap.put("data", messageList);
        WsResponse wsResponse = WsResponse.fromText((String)resultMap.toString(), (String)"utf-8");
        Tio.send((ChannelContext)channelContext, (Packet)wsResponse);
    }

    private ImMessage saveMessage(ImMessageInfo message, String readStatus) {
        ImMessage imMessage = new ImMessage();
        imMessage.setToId(message.getId());
        imMessage.setFromId(message.getFromid());
        imMessage.setSendTime(System.currentTimeMillis());
        imMessage.setContent(message.getContent());
        imMessage.setReadStatus(readStatus);
        imMessage.setIfTranslate("0");
        imMessage.setAudioText(null);
        imMessage.setType("kefu".equals(message.getCid()) ? "customer" : message.getType());
        imMessage.setMessageType(message.getMessageType());
        this.iImMessageService.saveMessage(imMessage);
        return imMessage;
    }

    public void messageCallback(ImMessage imMessage, ImMessageCallbackDto dto) {
        String type;
        String fromId = imMessage.getFromId();
        String toId = imMessage.getToId();
        ImUserDTO user = this.imAccountRpcService.getImUserById(toId);
        ImMessageInfo messageInfo = new ImMessageInfo();
        messageInfo.setId(fromId);
        messageInfo.setFromid(toId);
        messageInfo.setCid("kefu");
        messageInfo.setUsername(user.getUsername());
        messageInfo.setAvatar(user.getAvatar());
        switch (dto.getSendNewsType()) {
            case "0": {
                type = TuLingRobotUtil.ResultType.TEXT.getType();
                break;
            }
            case "1": {
                type = TuLingRobotUtil.ResultType.IMAGE.getType();
                break;
            }
            default: {
                type = TuLingRobotUtil.ResultType.TEXT.getType();
            }
        }
        messageInfo.setContent(TuLingRobotUtil.ResultType.buildText(type, dto.getSendNews()));
        messageInfo.setMine(false);
        messageInfo.setMessageType(TuLingRobotUtil.ResultType.buildType(type));
        messageInfo.setTimestamp(System.currentTimeMillis());
        messageInfo.setType("friend");
        messageInfo.setIfTranslate("0");
        messageInfo.setMine(false);
        JSONObject resultMap = new JSONObject();
        resultMap.put("msg_type", (Object)"msg_customer");
        resultMap.put("data", (Object)messageInfo);
        ChannelContext cc = WsOnlineContext.getChannelContextByUser(fromId);
        if (null != cc) {
            WsResponse wsResponse = WsResponse.fromText((String)resultMap.toString(), (String)"utf-8");
            SetWithLock channelContextSetWithLock = Tio.getChannelContextsByUserid((GroupContext)cc.groupContext, (String)messageInfo.getId());
            if (channelContextSetWithLock != null && channelContextSetWithLock.size() > 0) {
                Tio.sendToUser((GroupContext)cc.groupContext, (String)messageInfo.getId(), (Packet)wsResponse);
                this.saveMessage(messageInfo, "0");
                return;
            }
        }
        this.saveMessage(messageInfo, "1");
    }
}

