/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.im.entity.ImGroup;
import com.els.modules.im.entity.ImUserFriend;
import com.els.modules.im.mapper.ImGroupMapper;
import com.els.modules.im.mapper.ImUserFriendMapper;
import com.els.modules.im.service.IImUserFriendService;
import com.els.modules.im.vo.ImGroupVO;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="imUserFriendServiceImpl")
public class ImUserFriendServiceImpl
extends ServiceImpl<ImUserFriendMapper, ImUserFriend>
implements IImUserFriendService {
    @Autowired
    private ImGroupMapper imGroupMapper;

    @Override
    public List<ImGroupVO> getUserFriends(String userId) {
        return ((ImUserFriendMapper)this.baseMapper).getUserFriends(userId);
    }

    @Override
    public void delFriendRequest(String requestId) {
        LoginUser sysUser = SysUtil.getLoginUser();
        ((ImUserFriendMapper)this.baseMapper).delFriendRequest(sysUser.getId(), requestId);
    }

    @Override
    public void moveFriendToGroup(String userId, String friendId, String groupId) {
        ImGroup imGroup = (ImGroup)this.imGroupMapper.selectById((Serializable)((Object)groupId));
        if (null == imGroup) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_zVxMK_beac1f5f", (String)"\u5206\u7ec4\u4e0d\u5b58\u5728"));
        }
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.set(ImUserFriend::getUserGroupId, (Object)groupId)).eq(ImUserFriend::getUserId, (Object)userId)).eq(ImUserFriend::getFriendId, (Object)friendId);
        ((ImUserFriendMapper)this.baseMapper).update(null, (Wrapper)wrapper);
        wrapper.clear();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.set(ImUserFriend::getFriendGroupId, (Object)groupId)).eq(ImUserFriend::getUserId, (Object)friendId)).eq(ImUserFriend::getFriendId, (Object)userId);
        ((ImUserFriendMapper)this.baseMapper).update(null, (Wrapper)wrapper);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void deleteFriend(String userId, String friendId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(ImUserFriend::getUserId, (Object)friendId)).eq(ImUserFriend::getFriendId, (Object)userId);
        ((ImUserFriendMapper)this.baseMapper).delete((Wrapper)queryWrapper);
        queryWrapper.clear();
        ((LambdaQueryWrapper)queryWrapper.eq(ImUserFriend::getUserId, (Object)userId)).eq(ImUserFriend::getFriendId, (Object)friendId);
        ((ImUserFriendMapper)this.baseMapper).delete((Wrapper)queryWrapper);
    }

    @Override
    public List<ImUserFriend> listImUserFriendOfUid(String userId) {
        return ((ImUserFriendMapper)this.baseMapper).listImUserFriendOfUid(userId);
    }
}

