/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.im.core.common.BaseEntity;
import com.els.modules.im.entity.ImGroup;
import com.els.modules.im.entity.ImUserFriend;
import com.els.modules.im.mapper.ImGroupMapper;
import com.els.modules.im.mapper.ImUserFriendMapper;
import com.els.modules.im.service.IImGroupService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="imGroupServiceImpl")
public class ImGroupServiceImpl
extends ServiceImpl<ImGroupMapper, ImGroup>
implements IImGroupService {
    private static final Integer MAX_GROUP = 30;
    private static final String DEFAULT_GROUP_NAME = "\u6211\u7684\u597d\u53cb";
    @Autowired
    private ImUserFriendMapper imUserFriendMapper;

    @Override
    public ImGroup addGroup(String userId, String imGroupName) {
        if (DEFAULT_GROUP_NAME.equals(imGroupName)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_CLzVxiTVB_e641053a", (String)"\u9ed8\u8ba4\u5206\u7ec4\u4e0d\u5141\u8bb8\u91cd\u590d"));
        }
        if (this.countUserGroup(userId) >= MAX_GROUP) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_eOROSuWWWWWWmzV_b8d7d21a", (String)"\u6700\u591a\u53ea\u80fd\u6dfb\u52a0${0}\u4e2a\u5206\u7ec4", (String[])new String[]{String.valueOf(MAX_GROUP)}));
        }
        Integer nextSort = ((ImGroupMapper)this.baseMapper).getMaxSort(userId);
        ImGroup group = new ImGroup();
        group.setSort(nextSort);
        group.setUserId(userId);
        group.setGroupname(imGroupName);
        group.setCreateDate(new Date());
        group.setUpdateDate(new Date());
        group.setDelFlag(CommonConstant.DEL_FLAG_0.toString());
        ((ImGroupMapper)this.baseMapper).insert(group);
        return group;
    }

    @Override
    public void initGroupBatch(List<String> userIdList) {
        ArrayList<ImGroup> imGroupList = new ArrayList<ImGroup>();
        ArrayList<ImUserFriend> imUserFriendList = new ArrayList<ImUserFriend>();
        for (String userId : userIdList) {
            ImGroup imGroup = new ImGroup();
            imGroup.setId(IdWorker.getIdStr());
            imGroup.setUserId(userId);
            imGroup.setGroupname(DEFAULT_GROUP_NAME);
            imGroup.setCreateDate(new Date());
            imGroup.setUpdateDate(new Date());
            imGroup.setDelFlag(CommonConstant.DEL_FLAG_0.toString());
            ImUserFriend imUserFriend = new ImUserFriend();
            imUserFriend.setUserId(userId);
            imUserFriend.setFriendId(userId);
            imUserFriend.setUserGroupId(imGroup.getId());
            imUserFriend.setFriendGroupId(imGroup.getId());
            imUserFriend.setCreateDate(new Date());
            imUserFriend.setUpdateDate(new Date());
            imUserFriend.setDelFlag(CommonConstant.DEL_FLAG_0.toString());
            imGroupList.add(imGroup);
            imUserFriendList.add(imUserFriend);
        }
        ((ImGroupMapper)this.baseMapper).insertBatchSomeColumn(imGroupList);
        this.imUserFriendMapper.insertBatchSomeColumn(imUserFriendList);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public String initGroup(String userId) {
        ImGroup group = new ImGroup();
        group.setUserId(userId);
        group.setGroupname(DEFAULT_GROUP_NAME);
        group.setSort(-1);
        group.setCreateDate(new Date());
        group.setUpdateDate(new Date());
        group.setDelFlag(CommonConstant.DEL_FLAG_0.toString());
        ((ImGroupMapper)this.baseMapper).insert(group);
        ImUserFriend userFriend = this.buildImUserFriend(userId, userId, group.getId());
        userFriend.setFriendGroupId(group.getId());
        this.imUserFriendMapper.insert(userFriend);
        return group.getId();
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public ImUserFriend addFriend(String friendId, String groupId) {
        LoginUser sysUser = SysUtil.getLoginUser();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(ImUserFriend::getUserId, (Object)sysUser.getId())).eq(ImUserFriend::getFriendId, (Object)friendId);
        Integer count = Math.toIntExact(this.imUserFriendMapper.selectCount((Wrapper)queryWrapper));
        String temUserId = sysUser.getId();
        String temFriendId = friendId;
        boolean exist = false;
        if (count > 0) {
            exist = true;
        }
        queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(ImUserFriend::getUserId, (Object)friendId)).eq(ImUserFriend::getFriendId, (Object)sysUser.getId());
        count = Math.toIntExact(this.imUserFriendMapper.selectCount((Wrapper)queryWrapper));
        if (count > 0) {
            temUserId = friendId;
            temFriendId = sysUser.getId();
            exist = true;
        }
        if (CharSequenceUtil.isBlank((CharSequence)groupId)) {
            ImGroup imGroup = this.checkGroupNameExist(sysUser.getId(), DEFAULT_GROUP_NAME, null);
            groupId = null == imGroup ? this.initGroup(sysUser.getId()) : imGroup.getId();
        }
        ImUserFriend userFriend = this.buildImUserFriend(sysUser.getId(), friendId, groupId);
        if (exist) {
            LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
            ((LambdaUpdateWrapper)wrapper.eq(ImUserFriend::getUserId, (Object)temUserId)).eq(ImUserFriend::getFriendId, (Object)temFriendId);
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.set(ImUserFriend::getUserGroupId, (Object)userFriend.getUserGroupId())).set(ImUserFriend::getFriendGroupId, (Object)userFriend.getFriendGroupId())).set(BaseEntity::getUpdateDate, (Object)userFriend.getUpdateDate())).set(BaseEntity::getCreateDate, (Object)userFriend.getCreateDate());
            this.imUserFriendMapper.update(null, (Wrapper)wrapper);
        } else {
            this.imUserFriendMapper.insert(userFriend);
        }
        return userFriend;
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public ImUserFriend agreeFriendRequest(String friendId, String groupId) {
        LoginUser sysUser = SysUtil.getLoginUser();
        if (CharSequenceUtil.isBlank((CharSequence)groupId)) {
            ImGroup imGroup = this.checkGroupNameExist(sysUser.getId(), DEFAULT_GROUP_NAME, null);
            groupId = null == imGroup ? this.initGroup(sysUser.getId()) : imGroup.getId();
        }
        ImUserFriend userFriend = this.buildImUserFriend(sysUser.getId(), friendId, groupId);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(ImUserFriend::getUserId, (Object)friendId)).eq(ImUserFriend::getFriendId, (Object)sysUser.getId());
        ImUserFriend friend = (ImUserFriend)this.imUserFriendMapper.selectOne((Wrapper)queryWrapper);
        this.imUserFriendMapper.setFriendGroup(friendId, sysUser.getId(), groupId);
        userFriend.setFriendGroupId(friend.getUserGroupId());
        this.imUserFriendMapper.insert(userFriend);
        return friend;
    }

    @Override
    public void rename(String groupId, String userId, String groupName) {
        ImGroup old = (ImGroup)((ImGroupMapper)this.baseMapper).selectById((Serializable)((Object)groupId));
        if (null == old) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_zVxMK_beac1f5f", (String)"\u5206\u7ec4\u4e0d\u5b58\u5728"));
        }
        if (DEFAULT_GROUP_NAME.equals(old.getGroupname())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_CLzVxiTsRR_e1df68a3", (String)"\u9ed8\u8ba4\u5206\u7ec4\u4e0d\u5141\u8bb8\u91cd\u547d\u540d"));
        }
        if (DEFAULT_GROUP_NAME.equals(groupName)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_CLzVxiTVB_e641053a", (String)"\u9ed8\u8ba4\u5206\u7ec4\u4e0d\u5141\u8bb8\u91cd\u590d"));
        }
        ImGroup imGroup = new ImGroup();
        imGroup.setUserId(userId);
        imGroup.setGroupname(groupName);
        imGroup.setId(groupId);
        ((ImGroupMapper)this.baseMapper).updateById(imGroup);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void deleteGroup(String userId, String groupId) {
        ImGroup imGroup = (ImGroup)((ImGroupMapper)this.baseMapper).selectById((Serializable)((Object)groupId));
        if (null == imGroup) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_zVxMK_beac1f5f", (String)"\u5206\u7ec4\u4e0d\u5b58\u5728"));
        }
        if (DEFAULT_GROUP_NAME.equals(imGroup.getGroupname())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_CLzVxiTQG_e6398c9e", (String)"\u9ed8\u8ba4\u5206\u7ec4\u4e0d\u5141\u8bb8\u5220\u9664"));
        }
        String newGroupId = null;
        ImGroup defaultGroup = this.checkGroupNameExist(userId, DEFAULT_GROUP_NAME, null);
        newGroupId = null == defaultGroup ? this.initGroup(userId) : defaultGroup.getId();
        this.moveFriendToGroup(userId, newGroupId, groupId);
        ((ImGroupMapper)this.baseMapper).deleteById((Serializable)((Object)groupId));
    }

    private void moveFriendToGroup(String userId, String newGroupId, String oldGroupId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.set(ImUserFriend::getUserGroupId, (Object)newGroupId)).eq(ImUserFriend::getUserId, (Object)userId)).eq(ImUserFriend::getUserGroupId, (Object)oldGroupId);
        this.imUserFriendMapper.update(null, (Wrapper)wrapper);
        LambdaQueryWrapper friendWrapper = Wrappers.lambdaQuery();
        friendWrapper.select(new SFunction[]{ImUserFriend::getFriendId});
        ((LambdaQueryWrapper)friendWrapper.eq(ImUserFriend::getUserId, (Object)userId)).eq(ImUserFriend::getUserGroupId, (Object)newGroupId);
        List friends = this.imUserFriendMapper.selectList((Wrapper)friendWrapper);
        if (friends.isEmpty()) {
            return;
        }
        wrapper.clear();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.set(ImUserFriend::getFriendGroupId, (Object)newGroupId)).in(ImUserFriend::getUserId, (Collection)friends.stream().map(ImUserFriend::getFriendId).collect(Collectors.toList()))).eq(ImUserFriend::getFriendId, (Object)userId);
        this.imUserFriendMapper.update(null, (Wrapper)wrapper);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void groupUpAndDown(String userId, String moveGroupId, String targetGroupId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.select(new SFunction[]{ImGroup::getSort, ImGroup::getId});
        wrapper.eq(ImGroup::getUserId, (Object)userId);
        wrapper.in(ImGroup::getId, (Collection)Lists.newArrayList((Object[])new String[]{moveGroupId, targetGroupId}));
        List friends = ((ImGroupMapper)this.baseMapper).selectList((Wrapper)wrapper);
        if (friends.size() != 2) {
            return;
        }
        this.swapSort((ImGroup)friends.get(0), (ImGroup)friends.get(1));
        friends.forEach(arg_0 -> ((ImGroupMapper)((ImGroupMapper)this.baseMapper)).updateById(arg_0));
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void groupDrag(String userId, List<String> imGroups) {
        ArrayList<ImGroup> groups = new ArrayList<ImGroup>();
        for (int i = 0; i < imGroups.size(); ++i) {
            if (CharSequenceUtil.isBlank((CharSequence)imGroups.get(i))) continue;
            ImGroup group = new ImGroup();
            group.setId(imGroups.get(i));
            group.setSort(i);
            groups.add(group);
        }
        if (groups.isEmpty()) {
            return;
        }
        this.updateBatchById(groups);
    }

    private void swapSort(ImGroup m1, ImGroup m2) {
        Integer sort = m1.getSort();
        m1.setSort(m2.getSort());
        m2.setSort(sort);
    }

    private ImUserFriend buildImUserFriend(String userId, String friendId, String groupId) {
        ImUserFriend userFriend = new ImUserFriend();
        userFriend.setUserId(userId);
        userFriend.setFriendId(friendId);
        userFriend.setUserGroupId(groupId);
        userFriend.setCreateDate(new Date());
        userFriend.setUpdateDate(new Date());
        userFriend.setDelFlag(CommonConstant.DEL_FLAG_0.toString());
        return userFriend;
    }

    private ImGroup checkGroupNameExist(String userId, String imGroupName, String groupId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.select(new SFunction[]{ImGroup::getId});
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ImGroup::getUserId, (Object)userId)).eq(ImGroup::getGroupname, (Object)imGroupName)).eq(BaseEntity::getDelFlag, (Object)CommonConstant.DEL_FLAG_0.toString())).ne(CharSequenceUtil.isNotBlank((CharSequence)groupId), ImGroup::getId, (Object)groupId);
        List groups = ((ImGroupMapper)this.baseMapper).selectList((Wrapper)wrapper);
        if (groups.isEmpty()) {
            return null;
        }
        return (ImGroup)groups.get(0);
    }

    private Integer countUserGroup(String userId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(ImGroup::getUserId, (Object)userId);
        return Math.toIntExact(((ImGroupMapper)this.baseMapper).selectCount((Wrapper)wrapper));
    }
}

