/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.utils;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.els.modules.im.entity.ElsChatConfig;
import com.els.modules.im.utils.ImI18LocalCacheInit;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImUtils {
    private static final Logger log = LoggerFactory.getLogger(ImUtils.class);

    public static String getRecordI18Value(String value, List<ElsChatConfig> configLink) {
        for (ElsChatConfig link : configLink) {
            if (!link.getTypeValue().equals(value)) continue;
            String recordI18Value = ImI18LocalCacheInit.translate(link.getI18Key(), link.getTypeValue());
            if (StrUtil.isBlank((CharSequence)recordI18Value) || recordI18Value.equals(link.getTypeValue())) {
                recordI18Value = link.getDescription();
            }
            return recordI18Value;
        }
        return null;
    }

    public static String getImRecordTypeEnum(String value, List<ElsChatConfig> configLink) {
        if (CharSequenceUtil.isEmpty((CharSequence)value)) {
            return "";
        }
        List split = CharSequenceUtil.split((CharSequence)value, (CharSequence)"-");
        for (ElsChatConfig link : configLink) {
            if (!split.contains(link.getDescription())) continue;
            return value.replace(link.getDescription(), link.getTypeValue());
        }
        return value;
    }

    private ImUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

