/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.kefu.core;

import com.els.modules.im.kefu.core.CircularQueue;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CircularBlockingQueue<E>
extends CircularQueue<E> {
    private static final Logger log = LoggerFactory.getLogger(CircularBlockingQueue.class);
    protected final ReentrantLock putLock = new ReentrantLock();
    private QueueListener<E> listener;

    public CircularBlockingQueue() {
    }

    public CircularBlockingQueue(QueueListener<E> listener) {
        this.listener = listener;
    }

    public void setListener(QueueListener<E> listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E e) {
        ReentrantLock lock = this.putLock;
        try {
            lock.lockInterruptibly();
            super.add(e);
            if (this.listener != null) {
                this.listener.afterAdd(e);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exp) {
            log.error(":::\u5faa\u73af\u961f\u5217\u6dfb\u52a0\u503c\u5f02\u5e38:{}", (Object)exp.getMessage());
            Thread.currentThread().interrupt();
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E next() {
        ReentrantLock lock = this.putLock;
        try {
            lock.lockInterruptibly();
            Object e = super.next();
            return e;
        }
        catch (InterruptedException e) {
            log.error("CircularBlockingQueue next:{}", (Object)e.getMessage());
            Thread.currentThread().interrupt();
            E e2 = null;
            return e2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E prev() {
        ReentrantLock lock = this.putLock;
        try {
            lock.lockInterruptibly();
            Object e = super.prev();
            return e;
        }
        catch (InterruptedException e) {
            log.error("CircularBlockingQueue prev:{}", (Object)e.getMessage());
            Thread.currentThread().interrupt();
            E e2 = null;
            return e2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove(E e) {
        ReentrantLock lock = this.putLock;
        try {
            lock.lockInterruptibly();
            if (this.listener != null) {
                this.listener.afterAdd(e);
            }
            E e2 = super.remove(e);
            return e2;
        }
        catch (InterruptedException exp) {
            log.error("CircularBlockingQueue prev:{}", (Object)exp.getMessage());
            Thread.currentThread().interrupt();
            E e3 = null;
            return e3;
        }
        finally {
            lock.unlock();
        }
    }

    static interface QueueListener<E> {
        public void afterAdd(E var1);

        public void afterRemove(E var1);
    }
}

