/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.im.entity.ElsChatConfig;
import com.els.modules.im.mapper.ElsChatConfigMapper;
import com.els.modules.im.service.ChatConfigService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ChatConfigServiceImpl
extends ServiceImpl<ElsChatConfigMapper, ElsChatConfig>
implements ChatConfigService {
    @Autowired
    private RedisUtil redisUtil;

    @Override
    public void add(ElsChatConfig chatConfig) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(ElsChatConfig::getTypeValue, (Object)chatConfig.getTypeValue());
        Integer count = Math.toIntExact(((ElsChatConfigMapper)this.baseMapper).selectCount((Wrapper)wrapper).intValue());
        if (count > 0) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u6c9f\u901a\u7c7b\u578b\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0"));
        }
        ((ElsChatConfigMapper)this.baseMapper).insert(chatConfig);
    }

    @Override
    public void edit(ElsChatConfig chatConfig) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(ElsChatConfig::getTypeValue, (Object)chatConfig.getTypeValue())).ne(ElsChatConfig::getId, (Object)chatConfig.getTypeValue());
        Integer count = Math.toIntExact(((ElsChatConfigMapper)this.baseMapper).selectCount((Wrapper)wrapper).intValue());
        if (count > 0) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u6c9f\u901a\u7c7b\u578b\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0"));
        }
        ((ElsChatConfigMapper)this.baseMapper).updateById(chatConfig);
    }

    @Override
    public ElsChatConfig loadChatConfigByType(String type) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(ElsChatConfig::getTypeValue, (Object)type);
        return (ElsChatConfig)((ElsChatConfigMapper)this.baseMapper).selectOne((Wrapper)wrapper);
    }

    @Override
    public List<ElsChatConfig> loadConfig() {
        Object o = this.redisUtil.get("srm:im:ElsChatConfig:" + TenantContext.getTenant());
        if (null != o) {
            return (List)o;
        }
        List imChatGroupLinks = ((ElsChatConfigMapper)this.baseMapper).selectList(null);
        this.redisUtil.set("srm:im:ElsChatConfig:" + TenantContext.getTenant(), (Object)imChatGroupLinks);
        return imChatGroupLinks;
    }
}

