/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.core.tio;

import com.alibaba.fastjson.JSONObject;
import com.els.common.system.vo.LoginUser;
import com.els.modules.account.api.dto.ImUserDTO;
import com.els.modules.im.core.ImMessageInfo;
import com.els.modules.im.core.SendInfo;
import com.els.modules.im.core.common.utils.ChatUtils;
import com.els.modules.im.core.tio.WsOnlineContext;
import com.els.modules.im.core.tio.handler.HandlerManager;
import com.els.modules.im.core.tio.handler.OptHandler;
import com.els.modules.im.dto.ImMessageCallbackDto;
import com.els.modules.im.entity.ImChatGroup;
import com.els.modules.im.entity.ImMessage;
import com.els.modules.im.rpc.service.InvokeImAccountRpcService;
import com.els.modules.im.service.IImChatGroupService;
import com.els.modules.im.service.IImMessageService;
import com.els.modules.im.utils.TuLingRobotUtil;
import com.els.shiro.authc.ShiroRealm;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tio.core.ChannelContext;
import org.tio.core.GroupContext;
import org.tio.core.Tio;
import org.tio.core.intf.Packet;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponse;
import org.tio.utils.lock.SetWithLock;
import org.tio.websocket.common.WsRequest;
import org.tio.websocket.common.WsResponse;
import org.tio.websocket.server.handler.IWsMsgHandler;

@Component
public class TioWsMsgHandler
implements IWsMsgHandler {
    private static final Logger log = LoggerFactory.getLogger(TioWsMsgHandler.class);
    @Resource(name="imMessageServiceImpl")
    private IImMessageService iImMessageService;
    @Autowired
    private ShiroRealm shiroRealm;
    @Resource(name="imChatGroupServiceImpl")
    private IImChatGroupService imChatGroupServiceImpl;
    @Resource
    private InvokeImAccountRpcService imAccountRpcService;

    public HttpResponse handshake(HttpRequest request, HttpResponse httpResponse, ChannelContext channelContext) {
        String token = request.getParam("token");
        log.info("handshake start token:" + token);
        LoginUser sysUser = this.shiroRealm.checkUserTokenIsEffect(token);
        String userId = this.imAccountRpcService.getImUserByLoginName(sysUser.getElsAccount(), sysUser.getSubAccount()).getId();
        Tio.bindUser((ChannelContext)channelContext, (String)userId);
        WsOnlineContext.bindUser(userId, channelContext);
        List<ImChatGroup> groups = this.imChatGroupServiceImpl.getChatGroups(userId);
        for (ImChatGroup group : groups) {
            Tio.bindGroup((ChannelContext)channelContext, (String)group.getId());
        }
        log.info("handshake success token:" + token);
        return httpResponse;
    }

    public void onAfterHandshaked(HttpRequest httpRequest, HttpResponse httpResponse, ChannelContext channelContext) throws Exception {
        List<ImUserDTO> friendsRequest = this.imAccountRpcService.getUserFriendsRequest(channelContext.userid);
        if (CollectionUtils.isNotEmpty(friendsRequest)) {
            JSONObject jo = new JSONObject();
            jo.put("msg_type", (Object)"addUser");
            jo.put("data", friendsRequest);
            WsResponse toWsResponse = WsResponse.fromText((String)jo.toString(), (String)"utf-8");
            Tio.send((ChannelContext)channelContext, (Packet)toWsResponse);
        }
    }

    public Object onBytes(WsRequest wsRequest, byte[] bytes, ChannelContext channelContext) throws Exception {
        return null;
    }

    public Object onClose(WsRequest wsRequest, byte[] bytes, ChannelContext channelContext) throws Exception {
        Tio.remove((ChannelContext)channelContext, (String)"receive close flag");
        HashMap<String, String> resultMap = new HashMap<String, String>();
        ImUserDTO user = this.imAccountRpcService.getImUserById(channelContext.userid);
        resultMap.put("msg_type", "close");
        resultMap.put("data", (String)user);
        Tio.unbindUser((ChannelContext)channelContext);
        WsOnlineContext.unbindUser(channelContext.userid);
        return null;
    }

    public Object onText(WsRequest wsRequest, String text, ChannelContext channelContext) {
        try {
            OptHandler optHandler;
            ObjectMapper objectMapper = new ObjectMapper();
            SendInfo sendInfo = (SendInfo)objectMapper.readValue(text, SendInfo.class);
            ImMessageInfo temMsg = sendInfo.getMessage();
            if (null != temMsg) {
                sendInfo.getMessage().setMessageType(ChatUtils.MessageType.type(temMsg.getContent()));
            }
            if (null == (optHandler = HandlerManager.execHandler(sendInfo.getCode()))) {
                return null;
            }
            return optHandler.handler(wsRequest, sendInfo, channelContext);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public void messageCallback(ImMessage imMessage, ImMessageCallbackDto dto) {
        String fromId = imMessage.getFromId();
        String toId = imMessage.getToId();
        ImUserDTO user = this.imAccountRpcService.getImUserById(toId);
        ImMessageInfo messageInfo = new ImMessageInfo();
        messageInfo.setId(fromId);
        messageInfo.setFromid(toId);
        messageInfo.setCid("kefu");
        messageInfo.setUsername(user.getUsername());
        messageInfo.setAvatar(user.getAvatar());
        String type = switch (dto.getSendNewsType()) {
            case "0" -> TuLingRobotUtil.ResultType.TEXT.getType();
            case "1" -> TuLingRobotUtil.ResultType.IMAGE.getType();
            default -> TuLingRobotUtil.ResultType.TEXT.getType();
        };
        messageInfo.setContent(TuLingRobotUtil.ResultType.buildText(type, dto.getSendNews()));
        messageInfo.setMine(false);
        messageInfo.setMessageType(TuLingRobotUtil.ResultType.buildType(type));
        messageInfo.setTimestamp(System.currentTimeMillis());
        messageInfo.setType("friend");
        messageInfo.setIfTranslate("0");
        messageInfo.setMine(false);
        JSONObject resultMap = new JSONObject();
        resultMap.put("msg_type", (Object)"msg_customer");
        resultMap.put("data", (Object)messageInfo);
        ChannelContext cc = WsOnlineContext.getChannelContextByUser(fromId);
        if (null != cc) {
            WsResponse wsResponse = WsResponse.fromText((String)resultMap.toString(), (String)"utf-8");
            SetWithLock channelContextSetWithLock = Tio.getChannelContextsByUserid((GroupContext)cc.groupContext, (String)messageInfo.getId());
            if (channelContextSetWithLock != null && channelContextSetWithLock.size() > 0) {
                Tio.sendToUser((GroupContext)cc.groupContext, (String)messageInfo.getId(), (Packet)wsResponse);
                this.saveMessage(messageInfo, "0");
                return;
            }
        }
        this.saveMessage(messageInfo, "1");
    }

    protected ImMessage saveMessage(ImMessageInfo message, String readStatus) {
        ImMessage imMessage = new ImMessage();
        imMessage.setToId(message.getId());
        imMessage.setFromId(message.getFromid());
        imMessage.setSendTime(System.currentTimeMillis());
        imMessage.setContent(message.getContent());
        imMessage.setReadStatus(readStatus);
        imMessage.setIfTranslate("0");
        imMessage.setAudioText(null);
        imMessage.setType("kefu".equals(message.getCid()) ? "customer" : message.getType());
        imMessage.setMessageType(message.getMessageType());
        this.iImMessageService.saveMessage(imMessage);
        return imMessage;
    }
}

