/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.utils;

import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.util.MqUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ImUserDTO;
import com.els.modules.im.entity.ElsChatConfig;
import com.els.modules.im.entity.ImChatGroup;
import com.els.modules.im.rpc.service.InvokeImAccountRpcService;
import com.els.modules.im.service.ChatConfigService;
import com.els.modules.im.service.IImChatGroupService;
import com.els.modules.im.utils.ImUtils;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ImMsgSendUtil {
    private static final Logger log = LoggerFactory.getLogger(ImMsgSendUtil.class);
    @Resource
    private InvokeImAccountRpcService imAccountRpcService;
    @Resource(name="imChatGroupServiceImpl")
    private IImChatGroupService imChatGroupServiceImpl;
    @Autowired
    private ChatConfigService chatConfigService;
    @Resource
    private RedisUtil redisUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    public void sendMessage(String sendId, String operateType, String groupId, Object msg, List<String> toUserIds) {
        log.info("ImMsgSendUtil\u79bb\u7ebf\u6d88\u606f\u53d1\u9001");
        try {
            ImChatGroup group;
            ImUserDTO loginUser = this.imAccountRpcService.getLoginUser(sendId);
            List<ElsChatConfig> elsChatConfigs = this.chatConfigService.loadConfig();
            TenantContext.setTenant((String)loginUser.getElsAccount());
            List<ImUserDTO> subAccountList = this.imAccountRpcService.getUsersByUserIdList(toUserIds);
            Map<String, List<ImUserDTO>> accountMap = subAccountList.stream().collect(Collectors.groupingBy(ImUserDTO::getElsAccount));
            JSONObject msgObj = new JSONObject();
            msgObj.put("msgId", (Object)IdWorker.getIdStr());
            JSONObject jsonObject = SysUtil.objectToJSON((Object)msg);
            msgObj.put("businessObj", (Object)jsonObject);
            msgObj.put("busAccount", (Object)loginUser.getElsAccount());
            msgObj.put("elsAccount", (Object)loginUser.getElsAccount());
            msgObj.put("businessType", (Object)"chatMessageReminder");
            jsonObject.put("msgFromUser", (Object)(loginUser.getElsAccount() + "_" + loginUser.getUsername()));
            if ("imChatGroup".equals(operateType) && null != (group = (ImChatGroup)this.imChatGroupServiceImpl.getById((Serializable)((Object)groupId)))) {
                String recordI18Value = ImUtils.getRecordI18Value(group.getRecordType(), elsChatConfigs);
                if (CharSequenceUtil.isNotEmpty((CharSequence)recordI18Value)) {
                    String groupName = group.getGroupname().replace(group.getRecordType(), recordI18Value);
                    jsonObject.put("imGroupName", (Object)groupName);
                } else {
                    jsonObject.put("imGroupName", (Object)group.getGroupname());
                }
                if (CharSequenceUtil.isNotEmpty((CharSequence)group.getRecordType())) {
                    jsonObject.put("imRecordNumber", (Object)group.getRecordNumber());
                    jsonObject.put("imRecordrecordType", (Object)group.getRecordType());
                }
            }
            msgObj.put("operateType", (Object)operateType);
            msgObj.put("sendObj", (Object)loginUser);
            JSONArray array = new JSONArray();
            for (String account : accountMap.keySet()) {
                List<ImUserDTO> imUserDTOS = accountMap.get(account);
                JSONObject receiveObj = new JSONObject();
                receiveObj.put("toElsAccount", (Object)account);
                receiveObj.put("urlParam", (Object)"");
                receiveObj.put("toSubAccountList", (Object)JSONArray.parseArray((String)JSON.toJSONString(imUserDTOS)));
                array.add((Object)receiveObj);
            }
            msgObj.put("receiveList", (Object)array);
            log.info("ImMsgSendUtil\u79bb\u7ebf\u6d88\u606f\u5f00\u59cb \u53d1\u9001:" + msgObj.toJSONString());
            MqUtil.sendBusMsg((String)msgObj.toJSONString());
        }
        catch (Exception e) {
            log.error("ImMsgSendUtil \u79bb\u7ebf\u6d88\u606f\u53d1\u9001\u5931\u8d25:{}", (Object)e.getMessage());
        }
        finally {
            TenantContext.clear();
        }
    }
}

