/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.utils;

import com.alibaba.fastjson.JSONObject;
import com.els.modules.account.api.dto.ImUserDTO;
import com.els.modules.im.core.ImMessageInfo;
import com.els.modules.im.entity.ImMessage;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChatGptRobotUtil
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(ChatGptRobotUtil.class);
    private static final String SUCCESS = "200";
    private static final String callBack = "els/im/message/noToken/message-callback";

    public static JSONObject buildJSONObject(ImMessageInfo message, String elsAccount, String serverPath) {
        JSONObject param = new JSONObject();
        JSONObject userId = new JSONObject();
        userId.put("userId", (Object)message.getId());
        param.put("userInfo", (Object)userId);
        Integer type = 0;
        JSONObject typeObj = new JSONObject();
        JSONObject text = new JSONObject();
        String path = serverPath.endsWith("/") ? serverPath + "els" : serverPath + "/els";
        switch (message.getMessageType()) {
            case "text": {
                text.put("text", (Object)message.getContent());
                typeObj.put("inputText", (Object)text);
                break;
            }
            case "img": {
                type = 1;
                String substring = message.getContent().substring(4);
                text.put("url", (Object)(path + substring.substring(0, substring.length() - 1)));
                typeObj.put("inputImage", (Object)text);
                break;
            }
            case "audio": {
                type = 2;
                String substring = message.getContent().substring(6);
                text.put("url", (Object)(path + substring.substring(0, substring.length() - 1)));
                typeObj.put("inputMedia", (Object)text);
                break;
            }
            case "file": {
                break;
            }
            default: {
                text.put("text", (Object)message.getContent());
                typeObj.put("inputText", (Object)text);
            }
        }
        param.put("reqType", (Object)type);
        param.put("perception", (Object)typeObj);
        param.put("currentAccount", (Object)elsAccount);
        return param;
    }

    public static JSONObject buildJSONObject(ImMessage imMessage, ImUserDTO loginUser, String elsAccount, String serverPath) {
        String type;
        JSONObject param = new JSONObject();
        String callbackUrl = serverPath.endsWith("/") ? serverPath + callBack : serverPath + "/" + callBack;
        param.put("callbackUrl", (Object)callbackUrl);
        param.put("username", (Object)loginUser.getRealname());
        param.put("companyName", (Object)loginUser.getEnterpriseName());
        param.put("subAccount", (Object)loginUser.getSubAccount());
        param.put("elsAccount", (Object)loginUser.getElsAccount());
        JSONObject news = new JSONObject();
        news.put("srmNewsId", (Object)imMessage.getId());
        ResultType resultType = ResultType.buildResultType(imMessage.getMessageType());
        switch (resultType) {
            case TEXT: {
                type = "0";
                break;
            }
            case IMAGE: {
                type = "1";
                break;
            }
            case URL: {
                type = "0";
                break;
            }
            case VIDEO: {
                type = "3";
                break;
            }
            case VOICE: {
                type = "2";
                break;
            }
            default: {
                type = "0";
            }
        }
        String text = resultType.getStart() + imMessage.getContent() + resultType.getEnd();
        news.put("sendNews", (Object)text);
        news.put("sendNewsType", (Object)type);
        param.put("news", (Object)news);
        param.put("currentAccount", (Object)elsAccount);
        return param;
    }

    public static JSONObject analysisResult(JSONObject object) {
        if (SUCCESS.equals(object.getString("code"))) {
            return JSONObject.parseObject((String)object.getString("data"));
        }
        return null;
    }

    public static enum Error {
        C_5000(5000, "\u65e0\u89e3\u6790\u7ed3\u679c"),
        C_6000(6000, "\u6682\u4e0d\u652f\u6301\u8be5\u529f\u80fd"),
        C_4000(4000, "\u8bf7\u6c42\u53c2\u6570\u683c\u5f0f\u9519\u8bef"),
        C_4001(4001, "\u52a0\u5bc6\u65b9\u5f0f\u9519\u8bef"),
        C_4002(4002, "\u65e0\u529f\u80fd\u6743\u9650"),
        C_4003(4003, "\u8be5apikey\u6ca1\u6709\u53ef\u7528\u8bf7\u6c42\u6b21\u6570"),
        C_4005(4005, "\u65e0\u529f\u80fd\u6743\u9650"),
        C_4007(4007, "apikey\u4e0d\u5408\u6cd5"),
        C_4100(4100, "userid\u83b7\u53d6\u5931\u8d25"),
        C_4200(4200, "\u4e0a\u4f20\u683c\u5f0f\u9519\u8bef"),
        C_4300(4300, "\u6279\u91cf\u64cd\u4f5c\u8d85\u8fc7\u9650\u5236"),
        C_4400(4400, "\u6ca1\u6709\u4e0a\u4f20\u5408\u6cd5userid"),
        C_4500(4500, "userid\u7533\u8bf7\u4e2a\u6570\u8d85\u8fc7\u9650\u5236"),
        C_4600(4600, "\u8f93\u5165\u5185\u5bb9\u4e3a\u7a7a"),
        C_4602(4602, "\u8f93\u5165\u6587\u672c\u5185\u5bb9\u8d85\u957f(\u4e0a\u9650150)"),
        C_7002(7002, "\u4e0a\u4f20\u4fe1\u606f\u5931\u8d25"),
        C_8008(8008, "\u670d\u52a1\u5668\u9519\u8bef"),
        C_0(0, "\u4e0a\u4f20\u6210\u529f");

        private Integer code;
        private String msg;

        public static Error buildErrorCode(Integer code) {
            Optional<Error> any = Arrays.stream(Error.values()).filter(x -> x.getCode().equals(code)).findAny();
            return any.orElse(null);
        }

        private Error(Integer code, String msg) {
            this.code = code;
            this.msg = msg;
        }

        public Integer getCode() {
            return this.code;
        }

        public String getMsg() {
            return this.msg;
        }
    }

    public static enum ResultType {
        TEXT("text", "", "", "text", false),
        URL("url", "", "", "text", false),
        VOICE("voice", "audio[", "]", "audio", true),
        VIDEO("video", "", "", "video", true),
        IMAGE("image", "img[", "]", "img", true),
        NEWS("news", "", "", "text", false);

        private String code;
        private String start;
        private String end;
        private String type;
        private boolean needPath;

        public static String buildText(String type, String context) {
            Optional<ResultType> any = Arrays.stream(ResultType.values()).filter(x -> x.code.equalsIgnoreCase(type)).findAny();
            if (!any.isPresent()) {
                return context;
            }
            ResultType resultType = any.get();
            if (context.startsWith(resultType.getStart())) {
                return context;
            }
            return resultType.getStart() + context + resultType.getEnd();
        }

        public static String buildText(String type, String context, String path) {
            Optional<ResultType> any = Arrays.stream(ResultType.values()).filter(x -> x.code.equalsIgnoreCase(type)).findAny();
            if (!any.isPresent()) {
                return context;
            }
            ResultType resultType = any.get();
            if (resultType.needPath) {
                String serverPath = path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
                return resultType.getStart() + serverPath + context + resultType.getEnd();
            }
            return resultType.getStart() + context + resultType.getEnd();
        }

        public static String buildType(String type) {
            Optional<ResultType> any = Arrays.stream(ResultType.values()).filter(x -> x.code.equalsIgnoreCase(type)).findAny();
            if (!any.isPresent()) {
                return TEXT.getType();
            }
            return any.get().getType();
        }

        public static ResultType buildResultType(String type) {
            Optional<ResultType> any = Arrays.stream(ResultType.values()).filter(x -> x.type.equalsIgnoreCase(type)).findAny();
            return any.orElse(TEXT);
        }

        private ResultType(String code, String start, String end, String type, boolean needPath) {
            this.code = code;
            this.start = start;
            this.end = end;
            this.type = type;
            this.needPath = needPath;
        }

        public String getCode() {
            return this.code;
        }

        public String getStart() {
            return this.start;
        }

        public String getEnd() {
            return this.end;
        }

        public String getType() {
            return this.type;
        }

        public boolean isNeedPath() {
            return this.needPath;
        }
    }

    public static class TuLingRobotResult
    implements Serializable {
        private String resultType;
        private Integer groupType;
        private List<String> values;

        public TuLingRobotResult(String resultType, Integer groupType, List<String> values) {
            this.resultType = resultType;
            this.groupType = groupType;
            this.values = values;
        }

        public String getResultType() {
            return this.resultType;
        }

        public Integer getGroupType() {
            return this.groupType;
        }

        public List<String> getValues() {
            return this.values;
        }

        public void setResultType(String resultType) {
            this.resultType = resultType;
        }

        public void setGroupType(Integer groupType) {
            this.groupType = groupType;
        }

        public void setValues(List<String> values) {
            this.values = values;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TuLingRobotResult)) {
                return false;
            }
            TuLingRobotResult other = (TuLingRobotResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$groupType = this.getGroupType();
            Integer other$groupType = other.getGroupType();
            if (this$groupType == null ? other$groupType != null : !((Object)this$groupType).equals(other$groupType)) {
                return false;
            }
            String this$resultType = this.getResultType();
            String other$resultType = other.getResultType();
            if (this$resultType == null ? other$resultType != null : !this$resultType.equals(other$resultType)) {
                return false;
            }
            List<String> this$values = this.getValues();
            List<String> other$values = other.getValues();
            return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TuLingRobotResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $groupType = this.getGroupType();
            result = result * 59 + ($groupType == null ? 43 : ((Object)$groupType).hashCode());
            String $resultType = this.getResultType();
            result = result * 59 + ($resultType == null ? 43 : $resultType.hashCode());
            List<String> $values = this.getValues();
            result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
            return result;
        }

        public String toString() {
            return "ChatGptRobotUtil.TuLingRobotResult(resultType=" + this.getResultType() + ", groupType=" + this.getGroupType() + ", values=" + this.getValues() + ")";
        }
    }
}

