/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.api.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.els.common.api.service.JobRpcService;
import com.els.common.util.DateUtils;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.enquiry.entity.PurchaseEnquiryHead;
import com.els.modules.enquiry.entity.PurchaseEnquiryItem;
import com.els.modules.enquiry.entity.SaleEnquiryHead;
import com.els.modules.enquiry.entity.SaleEnquiryItem;
import com.els.modules.enquiry.enumerate.EnquiryStatusEnum;
import com.els.modules.enquiry.job.utils.EnquiryJobUtil;
import com.els.modules.enquiry.service.PurchaseEnquiryHeadService;
import com.els.modules.enquiry.service.PurchaseEnquiryItemService;
import com.els.modules.enquiry.service.SaleEnquiryHeadService;
import com.els.modules.enquiry.service.SaleEnquiryItemService;
import com.els.modules.enquiry.service.impl.PurchaseEnquiryHeadServiceImpl;
import com.els.modules.enquiry.service.impl.PurchaseEnquiryItemServiceImpl;
import com.els.modules.enquiry.service.impl.SaleEnquiryHeadServiceImpl;
import com.els.modules.enquiry.service.impl.SaleEnquiryItemServiceImpl;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service(value="srmEnquiryEndJobServiceImpl")
public class SrmEnquiryEndJobBeanServiceImpl
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(SrmEnquiryEndJobBeanServiceImpl.class);

    @Async
    public void execute(String parameter) {
        log.info(" \u8be2\u4ef7\u62a5\u4ef7\u622a\u6b62\u5b9a\u65f6\u4efb\u52a1 SrmEnquiryEndJob \u5f00\u59cb\u6267\u884c\u65f6\u95f4:" + DateUtils.getTimestamp() + parameter);
        if (StrUtil.isEmpty((CharSequence)parameter)) {
            log.error("parameter must not be null.");
            return;
        }
        JSONObject paramObj = JSONObject.parseObject((String)parameter);
        String id = paramObj.getString("id");
        if (StrUtil.isEmpty((CharSequence)id)) {
            log.error("parameter must contain id.");
            return;
        }
        String tenantId = paramObj.getString("tenantId");
        if (StrUtil.isBlank((CharSequence)tenantId)) {
            tenantId = "100000";
        }
        TenantContext.setTenant((String)tenantId);
        PurchaseEnquiryHeadService purchaseEnquiryHeadService = (PurchaseEnquiryHeadService)SpringContextUtils.getBean(PurchaseEnquiryHeadServiceImpl.class);
        PurchaseEnquiryHead head = (PurchaseEnquiryHead)purchaseEnquiryHeadService.getById((Serializable)((Object)id));
        PurchaseEnquiryItem item = new PurchaseEnquiryItem();
        item.setItemStatus(EnquiryStatusEnum.NO_QUOTE.getValue());
        LambdaUpdateWrapper itemWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)itemWrapper.eq(PurchaseEnquiryItem::getHeadId, (Object)id)).eq(PurchaseEnquiryItem::getItemStatus, (Object)EnquiryStatusEnum.QUOTING.getValue());
        PurchaseEnquiryItemService purchaseEnquiryItemService = (PurchaseEnquiryItemService)SpringContextUtils.getBean(PurchaseEnquiryItemServiceImpl.class);
        purchaseEnquiryItemService.update((Object)item, (Wrapper)itemWrapper);
        SaleEnquiryHead saleHead = new SaleEnquiryHead();
        saleHead.setEnquiryStatus(EnquiryStatusEnum.NO_QUOTE.getValue());
        LambdaUpdateWrapper saleHeadWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)saleHeadWrapper.eq(SaleEnquiryHead::getRelationId, (Object)id)).eq(SaleEnquiryHead::getEnquiryStatus, (Object)EnquiryStatusEnum.QUOTING.getValue());
        SaleEnquiryHeadService saleEnquiryHeadService = (SaleEnquiryHeadService)SpringContextUtils.getBean(SaleEnquiryHeadServiceImpl.class);
        saleEnquiryHeadService.update((Object)saleHead, (Wrapper)saleHeadWrapper);
        SaleEnquiryItem saleItem = new SaleEnquiryItem();
        saleItem.setItemStatus(EnquiryStatusEnum.NO_QUOTE.getValue());
        LambdaUpdateWrapper saleItemWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)saleItemWrapper.eq(SaleEnquiryItem::getEnquiryNumber, (Object)head.getEnquiryNumber())).eq(SaleEnquiryItem::getToElsAccount, (Object)head.getElsAccount())).eq(SaleEnquiryItem::getItemStatus, (Object)EnquiryStatusEnum.QUOTING.getValue());
        SaleEnquiryItemService saleEnquiryItemService = (SaleEnquiryItemService)SpringContextUtils.getBean(SaleEnquiryItemServiceImpl.class);
        saleEnquiryItemService.update((Object)saleItem, (Wrapper)saleItemWrapper);
        List itemList = purchaseEnquiryItemService.selectByMainId(id);
        boolean flag = true;
        for (PurchaseEnquiryItem it : itemList) {
            if (EnquiryStatusEnum.NO_QUOTE.getValue().equals(it.getItemStatus())) continue;
            flag = false;
            break;
        }
        if (flag) {
            head.setEnquiryStatus(EnquiryStatusEnum.NO_QUOTE.getValue());
            purchaseEnquiryHeadService.updateById((Object)head);
        }
        String jobKey = paramObj.getString("jobKey");
        EnquiryJobUtil.deleteJob((String)jobKey);
        log.info(" \u8be2\u4ef7\u62a5\u4ef7\u622a\u6b62\u5b9a\u65f6\u4efb\u52a1 SrmEnquiryEndJob \u6267\u884c\u5b8c\u6210\u65f6\u95f4:" + DateUtils.getTimestamp() + parameter);
    }
}

