/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.api.service.impl;

import com.els.common.util.I18nUtil;
import com.els.modules.account.api.dto.ImUserDTO;
import com.els.modules.enquiry.entity.PurchaseEnquiryHead;
import com.els.modules.enquiry.enumerate.EnquiryStatusEnum;
import com.els.modules.enquiry.service.EnquirySupplierListService;
import com.els.modules.enquiry.service.PurchaseEnquiryHeadService;
import com.els.modules.im.api.dto.ImRecordDto;
import com.els.modules.im.api.service.ImUserRecordRpcService;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service(value="purchaseEnquiryImUserRecordServiceImpl")
public class PurchaseEnquiryUserRecordInvokeBeanServiceImpl
implements ImUserRecordRpcService {
    @Resource
    private PurchaseEnquiryHeadService purchaseEnquiryHeadService;
    @Resource
    private EnquirySupplierListService enquirySupplierListService;

    public List<ImUserDTO> getRecordPersonInCharge(ImRecordDto imRecordDto) {
        PurchaseEnquiryHead dbHead = (PurchaseEnquiryHead)this.purchaseEnquiryHeadService.getById((Serializable)((Object)imRecordDto.getRecordId()));
        Assert.isTrue((!EnquiryStatusEnum.NEW.getValue().equals(dbHead.getEnquiryStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_VIzEWShRe_3e411e67", (String)"\u65b0\u5efa\u72b6\u6001\uff0c\u65e0\u6cd5\u6c9f\u901a"));
        List supplierList = this.enquirySupplierListService.selectByMainId(imRecordDto.getRecordId());
        return supplierList.stream().map(supplier -> {
            String toElsAccount = supplier.getToElsAccount();
            String subAccount = StringUtils.isEmpty((Object)supplier.getSupplierPrincipal()) ? "1001" : supplier.getSupplierPrincipal().split("_")[0];
            ImUserDTO imUserDTO = new ImUserDTO();
            imUserDTO.setElsAccount(toElsAccount + "_" + subAccount);
            return imUserDTO;
        }).distinct().collect(Collectors.toList());
    }
}

