/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.demand.third.sql.api.extend;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.InterfaceUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.InterfaceCustomExtendRpcService;
import com.els.modules.base.api.service.TemplateRpcService;
import com.els.modules.demand.entity.PurchaseRequestHead;
import com.els.modules.demand.entity.PurchaseRequestItem;
import com.els.modules.demand.enumerate.PurchaseRequestStatusEnum;
import com.els.modules.demand.enumerate.PurchaseRequestStatusItemEnum;
import com.els.modules.demand.service.PurchaseRequestHeadService;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.demand.third.sql.dto.PurchaseRequestHeadOracleDto;
import com.els.modules.demand.third.sql.dto.PurchaseRequestItemOracleDto;
import com.els.modules.enquiry.utils.DefaultValueInitUtil;
import com.els.modules.material.api.dto.PurchaseMaterialHeadDTO;
import com.els.modules.material.api.service.PurchaseMaterialHeadRpcService;
import com.els.modules.third.sql.util.OracleSqlUtil;
import com.els.rpc.service.InvokeBaseRpcService;
import io.micrometer.core.instrument.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetPurchaseRequestFromCQGTOracleDbImpl
implements InterfaceCustomExtendRpcService {
    private static final Logger log = LoggerFactory.getLogger(GetPurchaseRequestFromCQGTOracleDbImpl.class);
    @Autowired
    private InterfaceUtil interfaceUtil;
    @Autowired
    private TemplateRpcService templateRpcService;
    @Autowired
    private PurchaseRequestHeadService purchaseRequestHeadService;
    @Autowired
    private PurchaseRequestItemService purchaseRequestItemService;
    @Autowired
    private PurchaseMaterialHeadRpcService purchaseMaterialHeadRpcService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    public JSONObject before(JSONObject obj, Object custom) {
        String tableName = "SRM_PO_REQUESTION_HEADERS_ALL";
        String sql = OracleSqlUtil.getAllDataSql((String)tableName);
        JSONObject customObject = (JSONObject)custom;
        boolean isIncrement = true;
        if (customObject.containsKey((Object)"custom_param")) {
            isIncrement = customObject.getJSONObject("custom_param").getBoolean("isIncrement");
        }
        if (isIncrement) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            sql = OracleSqlUtil.getIncrementDataSql((String)tableName, (Date)calendar.getTime());
        }
        obj.put("body", (Object)sql);
        obj.put("business_message", (Object)tableName);
        return obj;
    }

    public JSONObject after(JSONObject interfaceResult, JSONObject paramObj, Object custom) {
        log.info("GetMaterialCodeFromCQGTOracleDbImpl --> after result Data:{}", (Object)interfaceResult.toJSONString());
        JSONArray headList = OracleSqlUtil.handlerResultListInfo((JSONObject)interfaceResult);
        if (headList.size() <= 0) {
            return interfaceResult;
        }
        Map<String, List<PurchaseRequestItemOracleDto>> requestItemMap = this.getPurchaseRequestItem();
        String elsAccount = TenantContext.getTenant();
        List templateList = this.templateRpcService.getDefaultTemplateByType("purchaseRequest");
        Assert.notEmpty((Collection)templateList, (String)"\u8bf7\u5148\u914d\u7f6e\u91c7\u8d2d\u7533\u8bf7\u9ed8\u8ba4\u6a21\u677f", (Object[])new Object[0]);
        TemplateHeadDTO template = (TemplateHeadDTO)templateList.get(0);
        Map headValueMap = DefaultValueInitUtil.getHeadDefaultValue((String)template.getElsAccount(), (String)template.getTemplateNumber(), (String)String.valueOf(template.getTemplateVersion()));
        Map itemValueMap = DefaultValueInitUtil.getItemDefaultValue((String)template.getElsAccount(), (String)template.getTemplateNumber(), (String)String.valueOf(template.getTemplateVersion()));
        Map<String, PurchaseRequestHead> headMap = this.getPurchaseRequestHead(elsAccount);
        Map<String, PurchaseRequestItem> itemMap = this.getPurchaseRequestItem(elsAccount);
        Map<String, String> deptMap = this.invokeBaseRpcService.queryDictItemsByCode("unitCode", elsAccount).stream().collect(Collectors.toMap(DictDTO::getText, DictDTO::getValue));
        Map<String, PurchaseMaterialHeadDTO> materialHeadItems = this.getPurchaseMaterialItem(elsAccount);
        ArrayList<PurchaseRequestHead> insertHead = new ArrayList<PurchaseRequestHead>();
        ArrayList<PurchaseRequestHead> updateHead = new ArrayList<PurchaseRequestHead>();
        ArrayList<PurchaseRequestItem> insertItem = new ArrayList<PurchaseRequestItem>();
        ArrayList<PurchaseRequestItem> updateItem = new ArrayList<PurchaseRequestItem>();
        for (Object o : headList) {
            JSONObject json = (JSONObject)o;
            PurchaseRequestHead head = null;
            PurchaseRequestHeadOracleDto oracleDto = (PurchaseRequestHeadOracleDto)JSON.parseObject((String)json.toJSONString(), PurchaseRequestHeadOracleDto.class);
            if (headMap.containsKey(oracleDto.getRequestNumber())) {
                head = headMap.get(oracleDto.getRequestNumber());
                long time = OracleSqlUtil.getUpdateTime((String)head.getFbk20()).getTime();
                long time1 = OracleSqlUtil.getUpdateTime((String)oracleDto.getUpdateTime()).getTime();
                if (time1 <= time) continue;
                head.setRequestNumber(oracleDto.getRequestNumber());
                head.setApplyDate(OracleSqlUtil.getUpdateTime((String)oracleDto.getApplyDate()));
                head.setApplyDept(oracleDto.getOrgCode() + "_" + oracleDto.getApplyDept());
                head.setApplicant(oracleDto.getUserAccount() + "_" + oracleDto.getApplicant());
                head.setApplyDeptName(oracleDto.getApplyDept());
                updateHead.add(head);
            } else {
                head = (PurchaseRequestHead)JSONObject.parseObject((String)JSON.toJSONString((Object)headValueMap), PurchaseRequestHead.class);
                head.setId(IdWorker.getIdStr());
                head.setElsAccount(elsAccount);
                head.setTemplateNumber(template.getTemplateNumber());
                head.setTemplateName(template.getTemplateName());
                head.setTemplateAccount(template.getElsAccount());
                head.setTemplateVersion(template.getTemplateVersion().toString());
                head.setRequestStatus(PurchaseRequestStatusEnum.REQUEST_DEMAND.getValue());
                head.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
                head.setSourceId(oracleDto.getRequestHeadId());
                head.setSourceSystem("ERP");
                head.setRequestNumber(oracleDto.getRequestNumber());
                head.setApplyDate(OracleSqlUtil.getUpdateTime((String)oracleDto.getApplyDate()));
                head.setApplyDept(oracleDto.getOrgCode() + "_" + oracleDto.getApplyDept());
                head.setApplicant(oracleDto.getUserAccount() + "_" + oracleDto.getApplicant());
                head.setApplyDeptName(oracleDto.getApplyDept());
                head.setSourceId(oracleDto.getRequestHeadId());
                head.setFbk20(oracleDto.getUpdateTime());
                insertHead.add(head);
            }
            List<PurchaseRequestItemOracleDto> resultItems = requestItemMap.get(oracleDto.getRequestHeadId());
            if (CollectionUtils.isEmpty(resultItems)) {
                log.warn("GetMaterialCodeFromCQGTOracleDbImpl --> after item is null,headId:{}", (Object)oracleDto.getRequestHeadId());
                continue;
            }
            boolean isCancal = true;
            for (PurchaseRequestItemOracleDto resultItem : resultItems) {
                if ("Y".equals(resultItem.getStatus())) {
                    isCancal = false;
                }
                if (itemMap.containsKey(resultItem.getPurchaseRequestItemId())) {
                    PurchaseRequestItem item = itemMap.get(resultItem.getPurchaseRequestItemId());
                    long time = OracleSqlUtil.getUpdateTime((String)item.getFbk20()).getTime();
                    long time1 = OracleSqlUtil.getUpdateTime((String)resultItem.getUpdateTime()).getTime();
                    if (time1 <= time) continue;
                    updateItem.add(this.setPurchaseRequestItem(item, itemValueMap, head, resultItem, deptMap, materialHeadItems));
                    continue;
                }
                insertItem.add(this.setPurchaseRequestItem(null, itemValueMap, head, resultItem, deptMap, materialHeadItems));
            }
            if (!isCancal) continue;
            head.setRequestStatus(PurchaseRequestStatusEnum.REQUEST_CANCAL.getValue());
        }
        if (CollectionUtil.isNotEmpty(insertHead)) {
            this.purchaseRequestHeadService.saveBatch(insertHead, 2000);
        }
        if (CollectionUtil.isNotEmpty(updateHead)) {
            this.purchaseRequestHeadService.updateBatchById(updateHead, 2000);
        }
        if (CollectionUtil.isNotEmpty(insertItem)) {
            this.purchaseRequestItemService.saveBatch(insertItem, 2000);
        }
        if (CollectionUtil.isNotEmpty(updateItem)) {
            this.purchaseRequestItemService.updateBatchById(updateItem, 2000);
        }
        return interfaceResult;
    }

    private Map<String, List<PurchaseRequestItemOracleDto>> getPurchaseRequestItem() {
        String elsAccount = TenantContext.getTenant();
        String tableName = "SRM_PO_REQUESTION_LINES_ALL";
        JSONObject param = new JSONObject();
        param.put("bus_account", (Object)elsAccount);
        param.put("srm_interface_code", (Object)"getPurchaseRequestDetailData");
        param.put("body", (Object)OracleSqlUtil.getAllDataSql((String)tableName));
        param.put("business_message", (Object)tableName);
        JSONObject resultObj = this.interfaceUtil.callInterface(elsAccount, null, param, null);
        JSONArray jsonArray = OracleSqlUtil.handlerResultListInfo((JSONObject)resultObj);
        List resultItems = JSON.parseArray((String)jsonArray.toJSONString(), PurchaseRequestItemOracleDto.class);
        return resultItems.parallelStream().collect(Collectors.groupingBy(PurchaseRequestItemOracleDto::getPurchaseRequestHeadId));
    }

    private Map<String, PurchaseRequestHead> getPurchaseRequestHead(String elsAccount) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount);
        wrapper.eq(PurchaseRequestHead::getSourceSystem, (Object)"ERP");
        List list = this.purchaseRequestHeadService.list((Wrapper)wrapper);
        if (CollectionUtil.isEmpty((Collection)list)) {
            return new HashMap<String, PurchaseRequestHead>();
        }
        return list.stream().collect(Collectors.toMap(PurchaseRequestHead::getRequestNumber, Function.identity(), (newVal, oldVal) -> oldVal));
    }

    private Map<String, PurchaseRequestItem> getPurchaseRequestItem(String elsAccount) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount);
        wrapper.eq(PurchaseRequestItem::getSourceType, (Object)"interface");
        List list = this.purchaseRequestItemService.list((Wrapper)wrapper);
        if (CollectionUtil.isEmpty((Collection)list)) {
            return new HashMap<String, PurchaseRequestItem>();
        }
        return list.stream().collect(Collectors.toMap(PurchaseRequestItem::getSourceId, Function.identity(), (newVal, oldVal) -> oldVal));
    }

    private Map<String, PurchaseMaterialHeadDTO> getPurchaseMaterialItem(String elsAccount) {
        List list = this.purchaseMaterialHeadRpcService.listAll();
        if (CollectionUtil.isEmpty((Collection)list)) {
            return new HashMap<String, PurchaseMaterialHeadDTO>();
        }
        return list.stream().collect(Collectors.toMap(PurchaseMaterialHeadDTO::getMaterialNumber, Function.identity(), (newVal, oldVal) -> oldVal));
    }

    public PurchaseRequestItem setPurchaseRequestItem(PurchaseRequestItem dbItem, Map<String, String> itemValueMap, PurchaseRequestHead head, PurchaseRequestItemOracleDto resultItem, Map<String, String> deptMap, Map<String, PurchaseMaterialHeadDTO> materialHeadItems) {
        if (null != dbItem) {
            PurchaseMaterialHeadDTO materialHeadDTO = materialHeadItems.get(resultItem.getMaterialNumber());
            if (null != materialHeadDTO) {
                dbItem.setMaterialId(materialHeadDTO.getId());
                dbItem.setMaterialName(materialHeadDTO.getMaterialName());
                dbItem.setMaterialNumber(materialHeadDTO.getMaterialNumber());
                dbItem.setMaterialSpec(materialHeadDTO.getMaterialSpec());
                dbItem.setMaterialModel(materialHeadDTO.getMaterialModel());
            }
            dbItem.setItemStatus("Y".equals(resultItem.getStatus()) ? PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue() : PurchaseRequestStatusItemEnum.CANCEL.getValue());
            dbItem.setPurchaseUnit(deptMap.get(resultItem.getUomCode()));
            dbItem.setRepertoryUnit(deptMap.get(resultItem.getUomCode()));
            dbItem.setSourceId(resultItem.getPurchaseRequestItemId());
            dbItem.setFactory(resultItem.getFactory());
            dbItem.setRepertoryQuantity(StringUtils.isBlank((String)resultItem.getQuantity()) ? BigDecimal.ZERO : new BigDecimal(resultItem.getQuantity()));
            dbItem.setQuantity(StringUtils.isBlank((String)resultItem.getQuantity()) ? BigDecimal.ZERO : new BigDecimal(resultItem.getQuantity()));
            dbItem.setDeliveryDate(OracleSqlUtil.getUpdateTime((String)resultItem.getDeliveryDate()));
            dbItem.setUpdateTime(OracleSqlUtil.getUpdateTime((String)resultItem.getUpdateTime()));
            dbItem.setFbk1(resultItem.getFbk1());
            dbItem.setFbk2(resultItem.getFbk3());
            dbItem.setFbk20(resultItem.getUpdateTime());
            dbItem.setFbk19(resultItem.getStatus());
            dbItem.setRemark(resultItem.getFbk2());
            return dbItem;
        }
        PurchaseRequestItem item = new PurchaseRequestItem();
        item = (PurchaseRequestItem)JSONObject.parseObject((String)JSON.toJSONString(itemValueMap), PurchaseRequestItem.class);
        item.setHeadId(head.getId());
        item.setAuditStatus(head.getAuditStatus());
        item.setRequestNumber(head.getRequestNumber());
        item.setRequestType(head.getRequestType());
        item.setPurchaseType(head.getPurchaseType());
        item.setApplyDept(head.getApplyDept());
        item.setApplyDate(head.getApplyDate());
        item.setApplicant(head.getApplicant());
        item.setPurchasePrincipal(head.getPurchasePrincipal());
        item.setSourceType("interface");
        PurchaseMaterialHeadDTO materialHeadDTO = materialHeadItems.get(resultItem.getMaterialNumber());
        if (null != materialHeadDTO) {
            item.setMaterialId(materialHeadDTO.getId());
            item.setMaterialName(materialHeadDTO.getMaterialName());
            item.setMaterialNumber(materialHeadDTO.getMaterialNumber());
            item.setMaterialSpec(materialHeadDTO.getMaterialSpec());
            item.setMaterialModel(materialHeadDTO.getMaterialModel());
        }
        item.setItemStatus("Y".equals(resultItem.getStatus()) ? PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue() : PurchaseRequestStatusItemEnum.CANCEL.getValue());
        item.setPurchaseUnit(deptMap.get(resultItem.getUomCode()));
        item.setRepertoryUnit(deptMap.get(resultItem.getUomCode()));
        item.setSourceId(resultItem.getPurchaseRequestItemId());
        item.setFactory(resultItem.getFactory());
        item.setRepertoryQuantity(StringUtils.isBlank((String)resultItem.getQuantity()) ? BigDecimal.ZERO : new BigDecimal(resultItem.getQuantity()));
        item.setQuantity(StringUtils.isBlank((String)resultItem.getQuantity()) ? BigDecimal.ZERO : new BigDecimal(resultItem.getQuantity()));
        item.setDeliveryDate(OracleSqlUtil.getUpdateTime((String)resultItem.getDeliveryDate()));
        item.setUpdateTime(OracleSqlUtil.getUpdateTime((String)resultItem.getUpdateTime()));
        item.setFbk1(resultItem.getFbk1());
        item.setFbk2(resultItem.getFbk3());
        item.setFbk20(resultItem.getUpdateTime());
        item.setFbk19(resultItem.getStatus());
        item.setRemark(resultItem.getFbk2());
        return item;
    }
}

